/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.StochReg$Signals;
import com.motivewave.platform.study.general.StochReg$Values;
import com.motivewave.platform.study.general.n;

@StudyHeader(namespace="com.motivewave", id="ID_STRG", rb="com.motivewave.platform.study.nls.strings2", label="LBL_STRG", name="NAME_STOCHASTIC_REGULAR", desc="DESC_STRG", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/stochastic_regular.htm", signals=true, overlay=false, studyOverlay=true)
public class StochReg
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("FAST_K_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SLOW_K_PERIOD", new Object[0]), 3, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("FAST_K", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SLOW_K", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("FAST_K", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SLOW_K", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochReg$Values.FK, this.get("LBL_TBSTF", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochReg$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochReg$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)StochReg$Values.FK, "line");
        runtimeDescriptor.declarePath((Object)StochReg$Values.SK, "line2");
        runtimeDescriptor.declareIndicator((Object)StochReg$Values.FK, "ind");
        runtimeDescriptor.declareIndicator((Object)StochReg$Values.SK, "ind2");
        runtimeDescriptor.declareSignal((Object)StochReg$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StochReg$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{StochReg$Values.FK, StochReg$Values.SK});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = n.d(dataSeries, n2, n3, object);
        dataSeries.setDouble(n2, (Object)StochReg$Values.FK, Double.valueOf(d3));
        if (n2 < n3 + n4) {
            return;
        }
        Double d4 = dataSeries.ma(mAMethod, n2, n4, (Object)StochReg$Values.FK);
        dataSeries.setDouble(n2, (Object)StochReg$Values.SK, d4);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d5 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d6 = guideInfo2.getValue();
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)StochReg$Values.FK, (Object)StochReg$Values.SK) && d3 > d5 && d3 > this.a;
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)StochReg$Values.FK, (Object)StochReg$Values.SK) && d3 < d6 && d3 < this.b;
        dataSeries.setBoolean(n2, (Object)StochReg$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)StochReg$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d3;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d3);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_STRG", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d3, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)StochReg$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d3;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d3);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_STRG", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d3, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)StochReg$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

