/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.SmiErgodicOscillator$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_SMIEO", rb="com.motivewave.platform.study.nls.strings2", name="NAME_SMI_ERGODIC_OSCILLATOR", label="SMIEO", desc="DESC_SMIEO", helpLink="http://www.motivewave.com/studies/smi_ergodic_oscillator.htm", overlay=false, signals=false, studyOverlay=true)
public class SmiErgodicOscillator
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LONG_PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SHORT_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SIGNAL_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("INDICATOR", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SmiErgodicOscillator$Values.SMIEO, this.get("LBL_SMIEO", new Object[0]), new String[]{"input", "method", "period", "period2", "period3"}));
        runtimeDescriptor.declareBars((Object)SmiErgodicOscillator$Values.SMIEO);
        runtimeDescriptor.declareIndicator((Object)SmiErgodicOscillator$Values.SMIEO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{SmiErgodicOscillator$Values.SMIEO});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 + n3 + n4 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d4 = d2 - d3;
        double d5 = Math.abs(d4);
        dataSeries.setDouble(n2, (Object)SmiErgodicOscillator$Values.CHANGE, Double.valueOf(d4));
        dataSeries.setDouble(n2, (Object)SmiErgodicOscillator$Values.ABS_CHANGE, Double.valueOf(d5));
        if (n2 < n3 + 1) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)SmiErgodicOscillator$Values.CHANGE);
        dataSeries.setDouble(n2, (Object)SmiErgodicOscillator$Values.TEMP_CHANGE, d6);
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)SmiErgodicOscillator$Values.ABS_CHANGE);
        dataSeries.setDouble(n2, (Object)SmiErgodicOscillator$Values.TEMP_ABS_CHANGE, d7);
        if (n2 < n3 + n4 + 1) {
            return;
        }
        d6 = dataSeries.ma(mAMethod, n2, n4, (Object)SmiErgodicOscillator$Values.TEMP_CHANGE);
        d7 = dataSeries.ma(mAMethod, n2, n4, (Object)SmiErgodicOscillator$Values.TEMP_ABS_CHANGE);
        if (d6 == null || d7 == null) {
            return;
        }
        if (d7 == 0.0) {
            return;
        }
        Double d8 = d6 / d7;
        dataSeries.setDouble(n2, (Object)SmiErgodicOscillator$Values.SMI, d8);
        if (n2 < n3 + n4 + n5 + 1) {
            return;
        }
        Double d9 = dataSeries.ma(mAMethod, n2, n5, (Object)SmiErgodicOscillator$Values.SMI);
        if (d9 == null) {
            return;
        }
        Double d10 = d8 - d9;
        dataSeries.setDouble(n2, (Object)SmiErgodicOscillator$Values.SMIEO, d10);
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d11 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d10 > d11) {
            dataSeries.setBarColor(n2, (Object)SmiErgodicOscillator$Values.SMIEO, color);
        } else {
            dataSeries.setBarColor(n2, (Object)SmiErgodicOscillator$Values.SMIEO, color2);
        }
        dataSeries.setComplete(n2);
    }
}

