/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.SmiErgodicIndicator$Signals;
import com.motivewave.platform.study.general.SmiErgodicIndicator$Values;

@StudyHeader(namespace="com.motivewave", id="ID_SMIEI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_SMI_ERGODIC_INDICATOR", label="LBL_SMIEI", desc="DESC_SMIEI", helpLink="http://www.motivewave.com/studies/smi_ergodic_indicator.htm", overlay=false, signals=true, studyOverlay=true)
public class SmiErgodicIndicator
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LONG_PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SHORT_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SIGNAL_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_SMIEI", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_SMIEI", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.1, 0.0, 3.001, 0.001, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -3.001, 3.001, 0.001, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -0.1, -3.001, 0.0, 0.001, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SmiErgodicIndicator$Values.SMIEI, this.get("LBL_SMIEI", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SmiErgodicIndicator$Values.SIGNAL, this.get("LBL_SMIEI", new Object[0]), new String[]{"period3"}));
        runtimeDescriptor.declareSignal((Object)SmiErgodicIndicator$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)SmiErgodicIndicator$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)SmiErgodicIndicator$Values.SMIEI, "line");
        runtimeDescriptor.declarePath((Object)SmiErgodicIndicator$Values.SIGNAL, "line2");
        runtimeDescriptor.declareIndicator((Object)SmiErgodicIndicator$Values.SMIEI, "ind");
        runtimeDescriptor.declareIndicator((Object)SmiErgodicIndicator$Values.SIGNAL, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{SmiErgodicIndicator$Values.SMIEI, SmiErgodicIndicator$Values.SIGNAL});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 + n3 + n4 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d4 = d2 - d3;
        double d5 = Math.abs(d2 - d3);
        dataSeries.setDouble(n2, (Object)SmiErgodicIndicator$Values.CHANGE, Double.valueOf(d4));
        dataSeries.setDouble(n2, (Object)SmiErgodicIndicator$Values.ABS_CHANGE, Double.valueOf(d5));
        if (n2 < n3 + 1) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n3, (Object)SmiErgodicIndicator$Values.CHANGE);
        dataSeries.setDouble(n2, (Object)SmiErgodicIndicator$Values.TEMP_CHANGE, d6);
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)SmiErgodicIndicator$Values.ABS_CHANGE);
        dataSeries.setDouble(n2, (Object)SmiErgodicIndicator$Values.TEMP_ABS_CHANGE, d7);
        if (n2 < n3 + n4 + 1) {
            return;
        }
        d6 = dataSeries.ma(mAMethod, n2, n4, (Object)SmiErgodicIndicator$Values.TEMP_CHANGE);
        d7 = dataSeries.ma(mAMethod, n2, n4, (Object)SmiErgodicIndicator$Values.TEMP_ABS_CHANGE);
        Double d8 = d6 / d7;
        dataSeries.setDouble(n2, (Object)SmiErgodicIndicator$Values.SMIEI, d8);
        if (n2 < n3 + n4 + n5 + 1) {
            return;
        }
        Double d9 = dataSeries.ma(mAMethod, n2, n5, (Object)SmiErgodicIndicator$Values.SMIEI);
        dataSeries.setDouble(n2, (Object)SmiErgodicIndicator$Values.SIGNAL, d9);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d10 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d11 = guideInfo2.getValue();
        boolean bl2 = this.crossedAbove(dataSeries, n2, (Object)SmiErgodicIndicator$Values.SMIEI, (Object)SmiErgodicIndicator$Values.SIGNAL) && d8 < d11 && d8 < this.b;
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)SmiErgodicIndicator$Values.SMIEI, (Object)SmiErgodicIndicator$Values.SIGNAL) && d8 > d10 && d8 > this.a;
        dataSeries.setBoolean(n2, (Object)SmiErgodicIndicator$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)SmiErgodicIndicator$Signals.SELL, Boolean.valueOf(bl2));
        if (bl3) {
            this.b = Double.MAX_VALUE;
            this.a = d8;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_SMIEI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d8, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SmiErgodicIndicator$Signals.SELL, string, (Object)d2);
        }
        if (bl2) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d8;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d8.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_SMIEI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d8, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SmiErgodicIndicator$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

