/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.SlowKDivergence$Values;
import com.motivewave.platform.study.general.n;

@StudyHeader(namespace="com.motivewave", id="ID_SKDV", rb="com.motivewave.platform.study.nls.strings2", label="LBL_SKDV", name="NAME_SLOWK_DIVERGENCE", desc="DESC_SKDV", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/slowk_divergence.htm", signals=false, overlay=false, studyOverlay=true)
public class SlowKDivergence
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_SKDV", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SlowKDivergence$Values.SKDV, this.get("LBL_SKDV", new Object[0]), new String[]{"input", "period", "period2", "method"}));
        runtimeDescriptor.declarePath((Object)SlowKDivergence$Values.SKDV, "line");
        runtimeDescriptor.declareIndicator((Object)SlowKDivergence$Values.SKDV, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{SlowKDivergence$Values.SKDV});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 * 2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.WMA);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = n.d(dataSeries, n2, n3, object);
        dataSeries.setDouble(n2, (Object)SlowKDivergence$Values.FK, Double.valueOf(d2));
        if (n2 < n3 * 2) {
            return;
        }
        Double d3 = dataSeries.ma(mAMethod, n2, n3, (Object)SlowKDivergence$Values.FK);
        dataSeries.setDouble(n2, (Object)SlowKDivergence$Values.SK, d3);
        if (n2 < n3 * 2 + n4) {
            return;
        }
        Double d4 = dataSeries.ma(mAMethod, n2, n4, (Object)SlowKDivergence$Values.SK);
        dataSeries.setDouble(n2, (Object)SlowKDivergence$Values.SKDV, d4);
        dataSeries.setComplete(n2);
    }
}

