/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.SchaffTrendCycle$Values;

@StudyHeader(namespace="com.motivewave", id="ID_SCHAFF_TREND_CYCLE", rb="com.motivewave.platform.study.nls.strings2", label="LBL_STC", name="NAME_SCHAFF_TREND_CYCLE", desc="DESC_SCHAFF_TREND_CYCLE", helpLink="", signals=false, overlay=false, studyOverlay=true)
public class SchaffTrendCycle
extends Study {
    static final String a = "ind3";
    static final String b = "factor";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("MACD_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("STC_PERIOD", new Object[0]), 10, 1, 9099, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("MACD_PERIOD1", new Object[0]), 23, 1, 9099, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("MACD_PERIOD2", new Object[0]), 50, 1, 9099, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(b, this.get("FACTOR", new Object[0]), 0.5, 0.1, 1.0, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PATH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 75.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), -999.0, 50.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 25.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "period3", b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SchaffTrendCycle$Values.STC, this.get("LBL_STC", new Object[0]), new String[]{"input", "method", "period", "period2", "period3", b}));
        runtimeDescriptor.declarePath((Object)SchaffTrendCycle$Values.STC, "line");
        runtimeDescriptor.declareIndicator((Object)SchaffTrendCycle$Values.STC, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{SchaffTrendCycle$Values.STC});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(Math.max(n3, n4) + n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period");
        int n5 = this.getSettings().getInteger("period2");
        if (n2 < Math.max(n5, n3 = this.getSettings().getInteger("period3").intValue())) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        double d2 = this.getSettings().getDouble(b);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d3 = dataSeries.ma(mAMethod, n2, n5, object);
        Double d4 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d3 == null || d4 == null) {
            return;
        }
        Double d5 = d3 - d4;
        dataSeries.setDouble(n2, (Object)SchaffTrendCycle$Values.MACD, d5);
        Double d6 = dataSeries.lowest(n2, n4, (Object)SchaffTrendCycle$Values.MACD);
        if (d6 == null) {
            return;
        }
        Double d7 = dataSeries.highest(n2, n4, (Object)SchaffTrendCycle$Values.MACD) - d6;
        Double d8 = dataSeries.getDouble(n2 - 1, (Object)SchaffTrendCycle$Values.FRAC1, 0.0);
        Double d9 = d7 > 0.0 ? (d5 - d6) / d7 * 100.0 : d8;
        dataSeries.setDouble(n2, (Object)SchaffTrendCycle$Values.FRAC1, d9);
        Double d10 = dataSeries.getDouble(n2 - 1, (Object)SchaffTrendCycle$Values.PF, 0.0);
        Double d11 = d10 + d2 * (d9 - d10);
        dataSeries.setDouble(n2, (Object)SchaffTrendCycle$Values.PF, d11);
        Double d12 = dataSeries.lowest(n2, n4, (Object)SchaffTrendCycle$Values.PF);
        Double d13 = dataSeries.highest(n2, n4, (Object)SchaffTrendCycle$Values.PF) - d12;
        Double d14 = dataSeries.getDouble(n2 - 1, (Object)SchaffTrendCycle$Values.FRAC2, 0.0);
        Double d15 = d13 > 0.0 ? (d11 - d12) / d13 * 100.0 : d14;
        dataSeries.setDouble(n2, (Object)SchaffTrendCycle$Values.FRAC2, d15);
        Double d16 = dataSeries.getDouble(n2 - 1, (Object)SchaffTrendCycle$Values.STC, 0.0);
        Double d17 = d16 + d2 * (d15 - d16);
        dataSeries.setDouble(n2, (Object)SchaffTrendCycle$Values.STC, d17);
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

