/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.SMI$Signals;
import com.motivewave.platform.study.general.SMI$Values;

@StudyHeader(namespace="com.motivewave", id="SMI", rb="com.motivewave.platform.study.nls.strings", name="TITLE_SMI", label="LBL_SMI", desc="DESC_SMI", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/stochastic_momentum_index.htm")
public class SMI
extends Study {
    static final String a = "hlPeriod";
    static final String b = "maPeriod";
    static final String c = "smoothPeriod";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_HL_PERIOD", new Object[0]), 2, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_MA_PERIOD", new Object[0]), 8, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("LBL_SMOOTH_PERIOD", new Object[0]), 5, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 5, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_SMI", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        PathDescriptor pathDescriptor2 = new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true);
        pathDescriptor2.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 40.0, -100.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 0.0, -100.0, 100.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), -40.0, -100.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{a, b, c, "signalPeriod"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SMI$Values.SMI, this.get("LBL_SMI", new Object[0]), new String[]{a, b, c}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)SMI$Values.SMI_SIGNAL, this.get("LBL_SMI_SIGNAL", new Object[0]), new String[]{"signalPeriod"}));
        runtimeDescriptor.declarePath((Object)SMI$Values.SMI, "line");
        runtimeDescriptor.declarePath((Object)SMI$Values.SMI_SIGNAL, "signalLine");
        runtimeDescriptor.declareIndicator((Object)SMI$Values.SMI, "ind");
        runtimeDescriptor.declareIndicator((Object)SMI$Values.SMI_SIGNAL, "signalInd");
        runtimeDescriptor.declareSignal((Object)SMI$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)SMI$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setFixedTopValue(Integer.valueOf(100));
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(-100));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger(a);
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        Double d3 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
        if (d2 == null || d3 == null) {
            return;
        }
        double d4 = (d2 + d3) / 2.0;
        double d5 = (double)dataSeries.getClose(n2) - d4;
        dataSeries.setDouble(n2, (Object)SMI$Values.D, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)SMI$Values.HL, Double.valueOf(d2 - d3));
        int n4 = this.getSettings().getInteger(b);
        if (n2 < n3 + n4) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        dataSeries.setDouble(n2, (Object)SMI$Values.D_MA, dataSeries.ma(mAMethod, n2, n4, (Object)SMI$Values.D));
        dataSeries.setDouble(n2, (Object)SMI$Values.HL_MA, dataSeries.ma(mAMethod, n2, n4, (Object)SMI$Values.HL));
        int n5 = this.getSettings().getInteger(c);
        if (n2 < n3 + n4 + n5) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n5, (Object)SMI$Values.D_MA);
        Double d7 = dataSeries.ma(mAMethod, n2, n5, (Object)SMI$Values.HL_MA);
        if (d6 == null || d7 == null) {
            return;
        }
        double d8 = d7 / 2.0;
        double d9 = 0.0;
        if (d8 != 0.0) {
            d9 = 100.0 * (d6 / d8);
        }
        dataSeries.setDouble(n2, (Object)SMI$Values.SMI, Double.valueOf(d9));
        int n6 = this.getSettings().getInteger("signalPeriod");
        if (n2 < n3 + n4 + n5 + n6) {
            return;
        }
        Double d10 = dataSeries.ma(mAMethod, n2, n6, (Object)SMI$Values.SMI);
        if (d10 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)SMI$Values.SMI_SIGNAL, d10);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d10.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)SMI$Values.SMI, (Object)SMI$Values.SMI_SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_SMI_CROSS_ABOVE", new Object[]{d9, d10});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SMI$Signals.CROSS_ABOVE, string, (Object)d10);
        } else if (this.crossedBelow(dataSeries, n2, (Object)SMI$Values.SMI, (Object)SMI$Values.SMI_SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_SMI_CROSS_BELOW", new Object[]{d9, d10});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)SMI$Signals.CROSS_BELOW, string, (Object)d10);
        }
        dataSeries.setComplete(n2);
    }
}

