/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.RelativeVolatilityIndex$Signals;
import com.motivewave.platform.study.general.RelativeVolatilityIndex$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_RVI", rb="com.motivewave.platform.study.nls.strings2", name="NAME_RELATIVE_VOLATILITY_INDEX", label="LBL_RVI", desc="DESC_RVI", helpLink="http://www.motivewave.com/studies/relative_volatility_index.htm", signals=true, overlay=false, studyOverlay=true)
public class RelativeVolatilityIndex
extends Study {
    static final String a = "rsiLine";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("STD_DEV_PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SMOOTH_PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_RVI", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "method", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVolatilityIndex$Values.RVI, this.get("RVI", new Object[0]), new String[]{"input", "period", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVolatilityIndex$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeVolatilityIndex$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)RelativeVolatilityIndex$Values.RVI, "line");
        runtimeDescriptor.declareIndicator((Object)RelativeVolatilityIndex$Values.RVI, "ind");
        runtimeDescriptor.declareSignal((Object)RelativeVolatilityIndex$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RelativeVolatilityIndex$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{RelativeVolatilityIndex$Values.RVI});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input");
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.std(n2, n3, object);
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.STAND_DEV, Double.valueOf(d3));
        if (n2 < n3 + 1) {
            return;
        }
        double d4 = d3 - dataSeries.getDouble(n2 - 1, (Object)RelativeVolatilityIndex$Values.STAND_DEV, 0.0);
        double d5 = 0.0;
        double d6 = 0.0;
        if (d4 > 0.0) {
            d5 = d4;
        } else {
            d6 = d4;
        }
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.UP, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.DOWN, Double.valueOf(Math.abs(d6)));
        if (n2 <= n3 + 1 + n4) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        Double d7 = dataSeries.ma(mAMethod, n2, n4, (Object)RelativeVolatilityIndex$Values.UP);
        Double d8 = dataSeries.ma(mAMethod, n2, n4, (Object)RelativeVolatilityIndex$Values.DOWN);
        if (d7 == null || d8 == null) {
            return;
        }
        Double d9 = d7 / d8;
        double d10 = 100.0 - 100.0 / (1.0 + d9);
        dataSeries.setDouble(n2, (Object)RelativeVolatilityIndex$Values.RVI, Double.valueOf(d10));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d11 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d12 = guideInfo2.getValue();
        double d13 = dataSeries.getDouble(n2 - 1, (Object)RelativeVolatilityIndex$Values.RVI, 0.0);
        boolean bl2 = d10 > d11 && d13 > d10 && d10 > this.a;
        boolean bl3 = d10 < d12 && d13 < d10 && d10 < this.b;
        dataSeries.setBoolean(n2, (Object)RelativeVolatilityIndex$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)RelativeVolatilityIndex$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d10;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d10);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_RVI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d10, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RelativeVolatilityIndex$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d10;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d10);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_RVI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d10, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RelativeVolatilityIndex$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

