/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.RelativeMomentumAlternative$Signals;
import com.motivewave.platform.study.general.RelativeMomentumAlternative$Values;
import com.motivewave.platform.study.general.n;

@StudyHeader(namespace="com.motivewave", id="ID_RMAIX", rb="com.motivewave.platform.study.nls.strings2", name="NAME_RELATIVE_MOMENTUM_ALTERNATIVE_IND", label="LBL_RMAIX", desc="DESC_RMAIX", helpLink="http://www.motivewave.com/studies/relative_momentum_alternative_index.htm", signals=true, overlay=false, studyOverlay=true)
public class RelativeMomentumAlternative
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LOOK_BACK", new Object[0]), 10, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_RMAIX", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeMomentumAlternative$Values.RMAIX, this.get("LBL_RMAIX", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeMomentumAlternative$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RelativeMomentumAlternative$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)RelativeMomentumAlternative$Values.RMAIX, "line");
        runtimeDescriptor.declareIndicator((Object)RelativeMomentumAlternative$Values.RMAIX, "ind");
        runtimeDescriptor.declareSignal((Object)RelativeMomentumAlternative$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RelativeMomentumAlternative$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{RelativeMomentumAlternative$Values.RMAIX});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n4) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Object object = this.getSettings().getInput("input");
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        Double d3 = 0.0;
        Double d4 = 0.0;
        double d5 = 0.0;
        double d6 = n.a(dataContext, n2, n4, object);
        double d7 = 0.0;
        double d8 = 0.0;
        if (d6 > 0.0) {
            d7 = d6;
        } else {
            d8 = Math.abs(d6);
        }
        dataSeries.setDouble(n2, (Object)RelativeMomentumAlternative$Values.UP, Double.valueOf(d7));
        dataSeries.setDouble(n2, (Object)RelativeMomentumAlternative$Values.DOWN, Double.valueOf(d8));
        if (n2 < n3 + n4) {
            return;
        }
        if (n2 == n3 + n4) {
            Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
            d3 = dataSeries.ma(mAMethod, n2, n3, (Object)RelativeMomentumAlternative$Values.UP);
            d4 = dataSeries.ma(mAMethod, n2, n3, (Object)RelativeMomentumAlternative$Values.DOWN);
        }
        if (d3 == null || d4 == null) {
            return;
        }
        double d9 = dataSeries.getDouble(n2 - 1, (Object)RelativeMomentumAlternative$Values.AVGUP, d3.doubleValue());
        double d10 = dataSeries.getDouble(n2 - 1, (Object)RelativeMomentumAlternative$Values.AVGDN, d4.doubleValue());
        double d11 = (d9 * (double)(n3 - 1) + d7) / (double)n3;
        double d12 = (d10 * (double)(n3 - 1) + d8) / (double)n3;
        dataSeries.setDouble(n2, (Object)RelativeMomentumAlternative$Values.AVGUP, Double.valueOf(d11));
        dataSeries.setDouble(n2, (Object)RelativeMomentumAlternative$Values.AVGDN, Double.valueOf(d12));
        if (d11 + d12 != 0.0) {
            d5 = 100.0 * d11 / (d11 + d12);
        }
        dataSeries.setDouble(n2, (Object)RelativeMomentumAlternative$Values.RMAIX, Double.valueOf(d5));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d13 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d14 = guideInfo2.getValue();
        double d15 = dataSeries.getDouble(n2 - 1, (Object)RelativeMomentumAlternative$Values.RMAIX, 0.0);
        boolean bl2 = d5 > d13 && d15 > d5 && d5 > this.a;
        boolean bl3 = d5 < d14 && d15 < d5 && d5 < this.b;
        dataSeries.setBoolean(n2, (Object)RelativeMomentumAlternative$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)RelativeMomentumAlternative$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d5;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_RMI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RelativeMomentumAlternative$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d5;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_RMI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d5, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RelativeMomentumAlternative$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

