/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.RateOfChange$Signals;
import com.motivewave.platform.study.general.RateOfChange$Values;

@StudyHeader(namespace="com.motivewave", id="ROC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_ROC", tabName="TAB_ROC", desc="DESC_ROC", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/rate_of_change.htm")
public class RateOfChange
extends Study {
    static final String a = "compPeriod";
    static final String b = "maPeriod";
    static final String c = "rocLine";
    static final String d = "maLine";
    static final String e = "rocInd";
    static final String f = "maInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_COMP_PERIOD", new Object[0]), 12, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_SIGNAL_PERIOD", new Object[0]), 20, 1, 9999, 1), new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor(c, this.get("LBL_ROC_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, false);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), c, 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), c, 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), false, true)});
        PathDescriptor pathDescriptor2 = new PathDescriptor(d, this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, false);
        pathDescriptor2.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(e, this.get("LBL_ROC_IND", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LBL_SIGNAL_IND", new Object[0]), null, null, false, false, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", a, b});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RateOfChange$Values.ROC, this.get("VAL_ROC", new Object[0]), new String[]{a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RateOfChange$Values.SIGNAL, this.get("VAL_ROC_MA", new Object[0]), new String[]{"method", b}));
        runtimeDescriptor.declarePath((Object)RateOfChange$Values.ROC, c);
        runtimeDescriptor.declarePath((Object)RateOfChange$Values.SIGNAL, d);
        runtimeDescriptor.declareIndicator((Object)RateOfChange$Values.ROC, e);
        runtimeDescriptor.declareIndicator((Object)RateOfChange$Values.SIGNAL, f);
        runtimeDescriptor.declareSignal((Object)RateOfChange$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)RateOfChange$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{RateOfChange$Values.ROC, RateOfChange$Values.SIGNAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, null));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger(a, 12);
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.roc(n2, n3, (Object)Enums.BarInput.CLOSE) * 100.0;
        dataSeries.setDouble(n2, (Object)RateOfChange$Values.ROC, d2);
        int n4 = this.getSettings().getInteger(b, 20);
        if (n2 < n4) {
            return;
        }
        Double d3 = dataSeries.ma(this.getSettings().getMAMethod("method", Enums.MAMethod.EMA), n2, n4, (Object)RateOfChange$Values.ROC);
        if (d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)RateOfChange$Values.SIGNAL, d3);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d3.doubleValue());
        if (this.crossedAbove(dataSeries, n2, (Object)RateOfChange$Values.ROC, (Object)RateOfChange$Values.SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
            String string = this.get("SIGNAL_ROC_CROSS_ABOVE", new Object[]{d2, d3});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RateOfChange$Signals.CROSS_ABOVE, string, (Object)d3);
        } else if (this.crossedBelow(dataSeries, n2, (Object)RateOfChange$Values.ROC, (Object)RateOfChange$Values.SIGNAL)) {
            MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
            String string = this.get("SIGNAL_ROC_CROSS_BELOW", new Object[]{d2, d3});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)RateOfChange$Signals.CROSS_BELOW, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

