/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.RainbowOscillator$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_RO", rb="com.motivewave.platform.study.nls.strings2", name="NAME_RAINBOW_OSCILLATOR", label="LBL_RO", desc="DESC_RO", helpLink="http://www.motivewave.com/studies/rainbow_oscillator.htm", signals=false, overlay=false, studyOverlay=true)
public class RainbowOscillator
extends Study {
    static final String a = "Ind3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LEVELS", new Object[0]), 2, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("RBW_PLUS", new Object[0]), defaults.getRed(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("RO_UP_COLOR", new Object[0]), defaults.getBlue())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("RO_DOWN_COLOR", new Object[0]), defaults.getBlue())});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("RBW_MINUS", new Object[0]), defaults.getGreen(), 1.0f, null)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup3 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("RBW_PLUS", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("RO", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("RBW_MINUS", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)RainbowOscillator$Values.RO, this.get("LBL_RO", new Object[0]), new String[]{"input", "period", "period2"}));
        runtimeDescriptor.declareBars((Object)RainbowOscillator$Values.RO);
        runtimeDescriptor.declarePath((Object)RainbowOscillator$Values.RBW_PLUS, "line2");
        runtimeDescriptor.declarePath((Object)RainbowOscillator$Values.RBW_MINUS, "line3");
        runtimeDescriptor.declareIndicator((Object)RainbowOscillator$Values.RO, "ind");
        runtimeDescriptor.declareIndicator((Object)RainbowOscillator$Values.RBW_PLUS, "ind2");
        runtimeDescriptor.declareIndicator((Object)RainbowOscillator$Values.RBW_MINUS, a);
        runtimeDescriptor.setRangeKeys(new Object[]{RainbowOscillator$Values.RBW_PLUS, RainbowOscillator$Values.RBW_MINUS});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = this.b(dataSeries, n2, n3, n4, object);
        dataSeries.setDouble(n2, (Object)RainbowOscillator$Values.RBW_PLUS, Double.valueOf(d2));
        dataSeries.setDouble(n2, (Object)RainbowOscillator$Values.RBW_MINUS, Double.valueOf(-d2));
        double d3 = this.a(dataSeries, n2, n3, n4, object);
        dataSeries.setDouble(n2, (Object)RainbowOscillator$Values.RO, Double.valueOf(d3));
        GuideInfo guideInfo = this.getSettings().getGuide("middleGuide");
        double d4 = guideInfo.getValue();
        Color color = this.getSettings().getColor("upColor");
        Color color2 = this.getSettings().getColor("downColor");
        if (d3 > d4) {
            dataSeries.setBarColor(n2, (Object)RainbowOscillator$Values.RO, color);
        } else {
            dataSeries.setBarColor(n2, (Object)RainbowOscillator$Values.RO, color2);
        }
        dataSeries.setComplete(n2);
    }

    protected double a(DataSeries dataSeries, int n2, int n3, int n4, Object object) {
        double d2;
        double[] dArray = new double[n4 * n3];
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            n5 = 0;
            for (int i3 = n2; i3 < n2 + n3; ++i3) {
                int n6 = i2 * n3 + n5;
                if (i2 == 0) {
                    dArray[n6] = dataSeries.sma(i3, n3, object);
                }
                if (i2 > 0) {
                    dArray[n6] = this.a(dArray, n6 - 1, n3);
                }
                ++n5;
            }
        }
        double d3 = dataSeries.highest(n2, n3, object);
        if (d3 - (d2 = dataSeries.lowest(n2, n3, object).doubleValue()) == 0.0) {
            return 0.0;
        }
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = this.a(dArray, (n4 - 1) * n3, n3);
        double d6 = 100.0 * ((d4 - d5) / (d3 - d2));
        return d6;
    }

    protected double b(DataSeries dataSeries, int n2, int n3, int n4, Object object) {
        double d2;
        int n5 = n4 * n3;
        double[] dArray = new double[n5];
        int n6 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            n6 = 0;
            for (int i3 = n2; i3 < n2 + n3; ++i3) {
                int n7 = i2 * n3 + n6;
                if (i2 == 0) {
                    dArray[n7] = dataSeries.sma(i3, n3, object);
                }
                if (i2 > 0) {
                    dArray[n7] = this.a(dArray, n7 - 1, n3);
                }
                ++n6;
            }
        }
        double d3 = dataSeries.highest(n2, n3, object);
        if (d3 - (d2 = dataSeries.lowest(n2, n3, object).doubleValue()) == 0.0) {
            return 0.0;
        }
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = this.b(dArray, (n4 - 1) * n3, n3);
        double d6 = this.c(dArray, (n4 - 1) * n3, n3);
        if (d4 > d5) {
            d5 = d4;
        }
        if (d4 < d6) {
            d6 = d4;
        }
        double d7 = 100.0 * ((d5 - d6) / (d3 - d2));
        return d7;
    }

    protected double a(double[] dArray, int n2, int n3) {
        double d2 = 0.0;
        for (int i2 = n2; i2 > n2 - n3; --i2) {
            d2 += dArray[i2];
        }
        double d3 = d2 / (double)n3;
        return d3;
    }

    protected double b(double[] dArray, int n2, int n3) {
        double d2 = 0.0;
        for (int i2 = n2; i2 > n2 - n3; --i2) {
            if (!(dArray[i2] > d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }

    protected double c(double[] dArray, int n2, int n3) {
        double d2 = dArray[n2];
        for (int i2 = n2; i2 > n2 - n3; --i2) {
            if (!(dArray[i2] < d2)) continue;
            d2 = dArray[i2];
        }
        return d2;
    }
}

