/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.ProgBandwidth$Values;
import com.motivewave.platform.study.general.n;

@StudyHeader(namespace="com.motivewave", id="ID_PBW", rb="com.motivewave.platform.study.nls.strings2", name="NAME_PROJECTION_BANDWIDTH", label="LBL_PBW", desc="DESC_PBW", helpLink="http://www.motivewave.com/studies/projection_bandwidth.htm", signals=false, overlay=false, studyOverlay=true)
public class ProgBandwidth
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_PBW", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ProgBandwidth$Values.PBW, this.get("LBL_PBW", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)ProgBandwidth$Values.PBW, "line");
        runtimeDescriptor.declareIndicator((Object)ProgBandwidth$Values.PBW, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ProgBandwidth$Values.PBW});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = n.a(dataSeries, n2, n3, Enums.BarInput.HIGH, 0)[1];
        double d3 = n.a(dataSeries, n2, n3, Enums.BarInput.LOW, 0)[1];
        int n4 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = Double.MAX_VALUE;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            double d7 = dataSeries.getDouble(i2 - 1, (Object)Enums.BarInput.HIGH, 0.0);
            double d8 = dataSeries.getDouble(i2 - 1, (Object)Enums.BarInput.LOW, 0.0);
            double d9 = d7 + d2 * (double)n4;
            double d10 = d8 + d3 * (double)n4;
            if (d9 > d5) {
                d5 = d9;
            }
            if (d10 < d6) {
                d6 = d10;
            }
            ++n4;
        }
        d4 = 200.0 * (d5 - d6) / (d5 + d6);
        dataSeries.setDouble(n2, (Object)ProgBandwidth$Values.PBW, Double.valueOf(d4));
        dataSeries.setComplete(n2);
    }
}

