/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.PhaseCalculation$Values;

@StudyHeader(namespace="com.motivewave", id="ID_PHCL", rb="com.motivewave.platform.study.nls.strings2", name="NAME_PHASE_CALCULATION", label="LBL_PHCL", desc="DESC_PHCL", helpLink="http://www.motivewave.com/studies/phase_calculation.htm", signals=false, overlay=false, studyOverlay=true)
public class PhaseCalculation
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 15, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_PHCL", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PhaseCalculation$Values.PHASE, this.get("LBL_PHCL", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)PhaseCalculation$Values.PHASE, "line");
        runtimeDescriptor.declareIndicator((Object)PhaseCalculation$Values.PHASE, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{PhaseCalculation$Values.PHASE});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            d2 = dataSeries.getDouble(i2, object, 0.0);
            d5 = Math.toRadians(360 * n4 / n3);
            d3 += Math.cos(d5) * d2;
            d4 += Math.sin(d5) * d2;
            ++n4;
        }
        d6 = Math.abs(d3) > 0.001 ? Math.toDegrees(Math.atan(d4 / d3)) : 90.0 * Math.toDegrees(Math.asin(d4));
        if (d3 < 0.0) {
            d6 += 180.0;
        }
        if ((d6 += 90.0) < 0.0) {
            d6 += 360.0;
        }
        if (d6 > 360.0) {
            d6 -= 360.0;
        }
        dataSeries.setDouble(n2, (Object)PhaseCalculation$Values.PHASE, Double.valueOf(d6));
        dataSeries.setComplete(n2);
    }
}

