/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.PPO$Values;

@StudyHeader(namespace="com.motivewave", id="PPO", rb="com.motivewave.platform.study.nls.strings", name="TITLE_PPO", label="LBL_PPO", desc="DESC_PPO", menu="MENU_GENERAL", overlay=false, studyOverlay=true, helpLink="http://www.motivewave.com/studies/percentage_price_oscillator.htm")
public class PPO
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 30, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PPO$Values.VAL, this.get("LBL_PPO", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.declarePath((Object)PPO$Values.VAL, "line");
        runtimeDescriptor.declareIndicator((Object)PPO$Values.VAL, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{PPO$Values.VAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period", 10);
        int n4 = this.getSettings().getInteger("period2", 30);
        if (n2 < Util.maxInt((int[])new int[]{n3, n4})) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMA);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        double d2 = dataSeries.ma(mAMethod, n2, n3, object);
        double d3 = dataSeries.ma(mAMethod, n2, n4, object);
        double d4 = 100.0 * (d2 - d3) / d3;
        dataSeries.setDouble(n2, (Object)PPO$Values.VAL, Double.valueOf(d4));
        dataSeries.setComplete(n2);
    }
}

