/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.OnBalVolDispInd$Signals;
import com.motivewave.platform.study.general.OnBalVolDispInd$Values;
import com.motivewave.platform.study.general.n;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_OBVDI", rb="com.motivewave.platform.study.nls.strings2", desc="DESC_OBVDI", label="LBL_OBVDI", name="NAME_ON_BALANCE_VOLUME_DISPARITY_INDICATOR", helpLink="http://www.motivewave.com/studies/onbalance_volume_disparity_indicator.htm", requiresVolume=false, overlay=false, signals=true, studyOverlay=true)
public class OnBalVolDispInd
extends Study {
    static final String a = "StdDev";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 33, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 4, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("STD_DEV", new Object[0]), 2.0, 0.1, 999.1, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_OBVDI", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MA", new Object[0]), defaults.getRed(), 1.0f, null, true, true, false)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_OBVDI", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MA", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.95, 0.0, 99.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.9, 0.0, 99.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 0.85, 0.0, 99.01, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "method", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OnBalVolDispInd$Values.OBVDI, this.get("LBL_OBVDI", new Object[0]), new String[]{"input", "period", "method", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OnBalVolDispInd$Values.AV, this.get("AV", new Object[0]), new String[]{"method", "period2", "method", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OnBalVolDispInd$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)OnBalVolDispInd$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)OnBalVolDispInd$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)OnBalVolDispInd$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)OnBalVolDispInd$Values.OBVDI, "line");
        runtimeDescriptor.declarePath((Object)OnBalVolDispInd$Values.AV, "line2");
        runtimeDescriptor.declareIndicator((Object)OnBalVolDispInd$Values.OBVDI, "ind");
        runtimeDescriptor.declareIndicator((Object)OnBalVolDispInd$Values.AV, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{OnBalVolDispInd$Values.OBVDI, OnBalVolDispInd$Values.AV});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 * 2 + n3);
    }

    protected synchronized void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n3) {
            return;
        }
        double d2 = this.getSettings().getDouble(a);
        Object object = this.getSettings().getInput("input");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getDouble(n2, object, 0.0);
        double[] dArray = n.a(dataSeries, n2, n3, d2, d2, object);
        double d4 = dArray[0] - dArray[1];
        double d5 = 0.0;
        if (d4 != 0.0) {
            d5 = (d3 - dArray[1]) / d4;
        }
        dataSeries.setDouble(n2, (Object)OnBalVolDispInd$Values.PERB, Double.valueOf(d5));
        if (n2 < n3 * 2) {
            return;
        }
        double[] dArray2 = n.a(dataSeries, n2, n3, d2, d2, (Object)OnBalVolDispInd$Values.PERB);
        d4 = dArray2[0] - dArray2[1];
        double d6 = 0.0;
        if (d4 != 0.0) {
            d6 = (d5 - dArray2[1]) / d4;
        }
        double d7 = (1.0 + d5) / (1.0 + d6);
        dataSeries.setDouble(n2, (Object)OnBalVolDispInd$Values.OBVDI, Double.valueOf(d7));
        if (n2 < n3 * 2 + n4) {
            return;
        }
        Double d8 = dataSeries.ma(mAMethod, n2, n4, (Object)OnBalVolDispInd$Values.OBVDI);
        dataSeries.setDouble(n2, (Object)OnBalVolDispInd$Values.AV, d8);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d9 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d10 = guideInfo2.getValue();
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)OnBalVolDispInd$Values.OBVDI, (Object)OnBalVolDispInd$Values.AV) && d7 > d9 && d7 > this.a;
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)OnBalVolDispInd$Values.OBVDI, (Object)OnBalVolDispInd$Values.AV) && d7 < d10 && d7 < this.b;
        dataSeries.setBoolean(n2, (Object)OnBalVolDispInd$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)OnBalVolDispInd$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d8;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_OBVDI", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)OnBalVolDispInd$Signals.SELL, string, (Object)d3);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d8;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_OBVDI", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)OnBalVolDispInd$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

