/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.MobilityOsc$Values;

@StudyHeader(namespace="com.motivewave", id="ID_MO", rb="com.motivewave.platform.study.nls.strings2", name="NAME_MOBILITY_OSCILLATOR", label="LBL_MO", desc="DESC_MO", helpLink="http://www.motivewave.com/studies/mobility_oscillator.htm", signals=false, overlay=false, studyOverlay=true)
public class MobilityOsc
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("M_PERIOD", new Object[0]), 10, 10, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LB_PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_MO", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MobilityOsc$Values.MO, this.get("LBL_MO", new Object[0]), new String[]{"period", "period2"}));
        runtimeDescriptor.declarePath((Object)MobilityOsc$Values.MO, "line");
        runtimeDescriptor.declareIndicator((Object)MobilityOsc$Values.MO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MobilityOsc$Values.MO});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("period");
        if (n2 < n4 + (n3 = this.getSettings().getInteger("period2").intValue()) + 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = -this.a(dataSeries, n2, n4, n3);
        dataSeries.setDouble(n2, (Object)MobilityOsc$Values.MO, Double.valueOf(d2));
        dataSeries.setComplete(n2);
    }

    public double a(DataSeries dataSeries, int n2, int n3, int n4) {
        double d2 = dataSeries.highest(n2, n4, (Object)Enums.BarInput.HIGH);
        double d3 = dataSeries.lowest(n2, n4, (Object)Enums.BarInput.LOW);
        double d4 = (d2 - d3) / (double)n3;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n5 = 1;
        double d10 = 0.0;
        int n6 = 0;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            d6 = d3 + (double)(n6 + 1) * d4;
            d5 = d6 - d4;
            d7 = this.a(dataSeries, i2, n6 + 1, n3, n4);
            if (n6 == 0) {
                d9 = d7;
            }
            if (d7 > d9) {
                n5 = n6 + 1;
                d9 = d7;
            }
            if (n6 == 0) {
                d8 = d7;
            }
            if ((d10 = (double)dataSeries.getClose(n2 - (n4 - 1))) > d5 && d10 <= d6) {
                d8 = d7;
            }
            ++n6;
        }
        double d11 = d3 + ((double)n5 - 0.5) * d4;
        double d12 = 100.0 * (1.0 - d8 / d9);
        if (d10 < d11) {
            d12 = -d12;
        }
        return d12;
    }

    public double a(DataSeries dataSeries, int n2, int n3, int n4, int n5) {
        double d2 = dataSeries.highest(n2, n5, (Object)Enums.BarInput.HIGH);
        double d3 = dataSeries.lowest(n2, n5, (Object)Enums.BarInput.LOW);
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = (d2 - d3) / (double)n4;
        double d8 = d3 + (double)(n3 - 1) * d7;
        double d9 = d3 + (double)n3 * d7;
        for (int i2 = n2 - n5 + 1; i2 <= n2; ++i2) {
            d4 = dataSeries.getHigh(i2);
            if (d4 <= (d5 = (double)dataSeries.getLow(i2))) continue;
            if (d4 <= d9) {
                d6 += 1.0;
            }
            if (!(d4 <= d9) && !(d5 >= d9)) {
                d6 += (d9 - d5) / (d4 - d5);
            }
            if (d4 <= d8) {
                d6 -= 1.0;
            }
            if (d4 <= d8 || d5 >= d8) continue;
            d6 -= (d8 - d5) / (d4 - d5);
        }
        return d6 / (double)n5;
    }
}

