/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.MassIndex$Signals;
import com.motivewave.platform.study.general.MassIndex$Values;

@StudyHeader(namespace="com.motivewave", id="ID_MSSI", rb="com.motivewave.platform.study.nls.strings2", label="LBL_MSSI", name="NAME_MASS_INDEX", desc="DESC_MSSI", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/mass_index.htm", signals=true, overlay=false, studyOverlay=true)
public class MassIndex
extends Study {
    static final String a = "trendMethod";
    static final String b = "trendInput";
    static final String c = "trendPeriod";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 21, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 21, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("PERIOD3", new Object[0]), 25, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(b, this.get("TREND_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(a, this.get("TREND_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("TREND_PERIOD", new Object[0]), 9, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("MASS_INDEX", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MASS_INDEX_TREND", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("MASS_INDEX", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MASS_INDEX_TREND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 27.0, 1.0, 100.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 26.5, 1.0, 100.01, 0.01, true);
        guideDescriptor2.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MassIndex$Values.MASS_INDEX, this.get("LBL_MASSI", new Object[0]), new String[]{"method", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MassIndex$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MassIndex$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)MassIndex$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MassIndex$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.getPricePlot().setLabelPrefix("MIT");
        runtimeDescriptor.getPricePlot().declarePath((Object)MassIndex$Values.TREND, "line2");
        runtimeDescriptor.declarePath((Object)MassIndex$Values.MASS_INDEX, "line");
        runtimeDescriptor.declareIndicator((Object)MassIndex$Values.MASS_INDEX, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{MassIndex$Values.MASS_INDEX});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 + n3 + n4);
    }

    public void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        boolean bl2;
        int n3 = this.getSettings().getInteger(c);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        int n4 = this.getSettings().getInteger("period");
        int n5 = this.getSettings().getInteger("period2");
        int n6 = this.getSettings().getInteger("period3");
        Object object = this.getSettings().getInput(b, (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod(a, Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = 0.0;
        if (n2 > n3) {
            d2 = dataSeries.ma(mAMethod2, n2, n3, object);
            dataSeries.setDouble(n2, (Object)MassIndex$Values.TREND, d2);
        }
        double d3 = dataSeries.getHigh(n2);
        double d4 = dataSeries.getLow(n2);
        dataSeries.setDouble(n2, (Object)MassIndex$Values.HIGH_LOW, Double.valueOf(d3 - d4));
        if (n2 < n4) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod, n2, n4, (Object)MassIndex$Values.HIGH_LOW);
        dataSeries.setDouble(n2, (Object)MassIndex$Values.FIRST_EMA, d5);
        if (n2 < n4 + n5) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n5, (Object)MassIndex$Values.FIRST_EMA);
        dataSeries.setDouble(n2, (Object)MassIndex$Values.SECOND_EMA, d6);
        dataSeries.setDouble(n2, (Object)MassIndex$Values.RATIO, Double.valueOf(d6 / d5));
        dataSeries.setBoolean(n2, (Object)MassIndex$Signals.ALERT, Boolean.valueOf(false));
        if (n2 < n4 + n5 + n6) {
            return;
        }
        Double d7 = dataSeries.sum(n2, n6, (Object)MassIndex$Values.RATIO);
        dataSeries.setDouble(n2, (Object)MassIndex$Values.MASS_INDEX, d7);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d8 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d9 = guideInfo2.getValue();
        double d10 = dataSeries.getDouble(n2 - 1, (Object)MassIndex$Values.TREND, 0.0);
        boolean bl3 = d10 < d2;
        boolean bl4 = bl2 = d10 > d2;
        if (d7 > d8) {
            dataSeries.setBoolean(n2, (Object)MassIndex$Signals.ALERT, Boolean.valueOf(true));
        }
        boolean bl5 = dataSeries.getBoolean(n2 - 1, (Object)MassIndex$Signals.ALERT);
        if (d7 > d9 && bl5) {
            dataSeries.setBoolean(n2, (Object)MassIndex$Signals.ALERT, Boolean.valueOf(true));
        }
        boolean bl6 = d7 <= d9 && bl5 && bl3;
        boolean bl7 = d7 <= d9 && bl5 && bl2;
        dataSeries.setBoolean(n2, (Object)MassIndex$Signals.SELL, Boolean.valueOf(bl6));
        dataSeries.setBoolean(n2, (Object)MassIndex$Signals.BUY, Boolean.valueOf(bl7));
        if (bl6) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_HIGH_MASS_INDEX", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MassIndex$Signals.SELL, string, (Object)d3);
        }
        if (bl7) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_MASS_INDEX", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MassIndex$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

