/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.KST$Signals;
import com.motivewave.platform.study.general.KST$Values;

@StudyHeader(namespace="com.motivewave", id="KST", rb="com.motivewave.platform.study.nls.strings", name="TITLE_KST", label="LBL_KST", desc="DESC_KST", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/know_sur_thing.htm")
public class KST
extends Study {
    static final String a = "ma1";
    static final String b = "ma2";
    static final String c = "ma3";
    static final String d = "ma4";
    static final String e = "r1";
    static final String f = "r2";
    static final String g = "r3";
    static final String h = "r4";
    static final String i = "w1";
    static final String j = "w2";
    static final String k = "w3";
    static final String l = "w4";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_KST_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("signalMethod", this.get("LBL_SIGNAL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 8, 1, 9999, 1)});
        settingGroup = new SettingGroup(this.get("LBL_ROC", new Object[0]));
        settingTab.addGroup(settingGroup);
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_MA1", new Object[0]), 10, 1, 9999, 1), new IntegerDescriptor(e, this.get("LBL_R1", new Object[0]), 10, 0, 9999, 1), new IntegerDescriptor(i, this.get("LBL_W1", new Object[0]), 1, 0, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_MA2", new Object[0]), 10, 1, 9999, 1), new IntegerDescriptor(f, this.get("LBL_R2", new Object[0]), 15, 0, 9999, 1), new IntegerDescriptor(j, this.get("LBL_W2", new Object[0]), 2, 0, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("LBL_MA3", new Object[0]), 10, 1, 9999, 1), new IntegerDescriptor(g, this.get("LBL_R3", new Object[0]), 20, 0, 9999, 1), new IntegerDescriptor(k, this.get("LBL_W3", new Object[0]), 3, 0, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(d, this.get("LBL_MA4", new Object[0]), 15, 1, 9999, 1), new IntegerDescriptor(h, this.get("LBL_R4", new Object[0]), 30, 0, 9999, 1), new IntegerDescriptor(l, this.get("LBL_W4", new Object[0]), 4, 0, 9999, 1)});
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_KST_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, false)});
        settingGroup2 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingGroup2 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), null, null, false, false, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KST$Values.KST, this.get("VAL_KST", new Object[0]), new String[]{"input", "method"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)KST$Values.SIGNAL, this.get("VAL_KST_SIGNAL", new Object[0]), new String[]{"input", "signalMethod"}));
        runtimeDescriptor.declarePath((Object)KST$Values.KST, "line");
        runtimeDescriptor.declarePath((Object)KST$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declareIndicator((Object)KST$Values.KST, "ind");
        runtimeDescriptor.declareIndicator((Object)KST$Values.SIGNAL, "signalInd");
        runtimeDescriptor.declareSignal((Object)KST$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)KST$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{KST$Values.KST, KST$Values.SIGNAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, null));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Object object = this.getSettings().getInput("input");
        int n3 = this.getSettings().getInteger(e);
        int n4 = this.getSettings().getInteger(f);
        int n5 = this.getSettings().getInteger(g);
        int n6 = this.getSettings().getInteger(h);
        int n7 = Util.maxInt((int[])new int[]{n3, n4, n5, n6});
        if (n2 < n7) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        dataSeries.setDouble(n2, (Object)KST$Values.ROC1, Double.valueOf(dataSeries.roc(n2, n3, object) * 100.0));
        dataSeries.setDouble(n2, (Object)KST$Values.ROC2, Double.valueOf(dataSeries.roc(n2, n4, object) * 100.0));
        dataSeries.setDouble(n2, (Object)KST$Values.ROC3, Double.valueOf(dataSeries.roc(n2, n5, object) * 100.0));
        dataSeries.setDouble(n2, (Object)KST$Values.ROC4, Double.valueOf(dataSeries.roc(n2, n6, object) * 100.0));
        int n8 = this.getSettings().getInteger(a);
        int n9 = this.getSettings().getInteger(b);
        int n10 = this.getSettings().getInteger(c);
        int n11 = this.getSettings().getInteger(d);
        int n12 = Util.maxInt((int[])new int[]{n8, n9, n10, n11});
        if (n2 < n7 + n12) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        int n13 = this.getSettings().getInteger(i);
        int n14 = this.getSettings().getInteger(j);
        int n15 = this.getSettings().getInteger(k);
        int n16 = this.getSettings().getInteger(l);
        double d2 = dataSeries.ma(mAMethod, n2, n8, (Object)KST$Values.ROC1) * (double)n13 + dataSeries.ma(mAMethod, n2, n9, (Object)KST$Values.ROC2) * (double)n14 + dataSeries.ma(mAMethod, n2, n10, (Object)KST$Values.ROC3) * (double)n15 + dataSeries.ma(mAMethod, n2, n11, (Object)KST$Values.ROC4) * (double)n16;
        dataSeries.setDouble(n2, (Object)KST$Values.KST, Double.valueOf(d2));
        int n17 = this.getSettings().getInteger("signalPeriod");
        if (n2 < n7 + n12 + n17) {
            return;
        }
        Double d3 = dataSeries.ma(this.getSettings().getMAMethod("signalMethod"), n2, n17, (Object)KST$Values.KST);
        dataSeries.setDouble(n2, (Object)KST$Values.SIGNAL, d3);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        if (d3 != null) {
            Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d3.doubleValue());
            if (this.crossedAbove(dataSeries, n2, (Object)KST$Values.KST, (Object)KST$Values.SIGNAL)) {
                MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
                String string = this.get("SIGNAL_KST_CROSS_ABOVE", new Object[]{d2, d3});
                if (markerInfo.isEnabled()) {
                    this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
                }
                dataContext.signal(n2, (Object)KST$Signals.CROSS_ABOVE, string, (Object)d3);
            } else if (this.crossedBelow(dataSeries, n2, (Object)KST$Values.KST, (Object)KST$Values.SIGNAL)) {
                MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
                String string = this.get("SIGNAL_KST_CROSS_BELOW", new Object[]{d2, d3});
                if (markerInfo.isEnabled()) {
                    this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
                }
                dataContext.signal(n2, (Object)KST$Signals.CROSS_BELOW, string, (Object)d3);
            }
        }
        dataSeries.setComplete(n2);
    }
}

