/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.NVP;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BarSizeDescriptor;
import com.motivewave.platform.sdk.common.desc.DiscreteDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.HistoricalVolatility$Values;
import java.util.ArrayList;
import java.util.List;

@StudyHeader(namespace="com.motivewave", id="ID_HV", rb="com.motivewave.platform.study.nls.strings", label="LBL_HV", name="NAME_HISTORICAL_VOLATILITY", desc="DESC_HV", helpLink="http://www.motivewave.com/studies/historical_volatility.htm", signals=false, overlay=false)
public class HistoricalVolatility
extends Study {
    final String a = "CLOSE";
    final String b = "CLOSE_LN";
    final String c = "HIGH_LOW";
    final String d = "TRUE_RANGE";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingsDescriptor.addInvisibleSetting((SettingDescriptor)new BarSizeDescriptor("barSize", this.get("LBL_TIMEFRAME", new Object[0]), BarSize.getBarSize((Enums.BarSizeType)Enums.BarSizeType.LINEAR, (int)1440)));
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        ArrayList<NVP> arrayList = new ArrayList<NVP>();
        arrayList.add(new NVP(this.get("LBL_CLOSE_TO_CLOSE", new Object[0]), "CLOSE"));
        arrayList.add(new NVP(this.get("LBL_CLOSE_TO_CLOSE_LN", new Object[0]), "CLOSE_LN"));
        arrayList.add(new NVP(this.get("LBL_HIGH_LOW_RANGE", new Object[0]), "HIGH_LOW"));
        arrayList.add(new NVP(this.get("LBL_TRUE_RANGE", new Object[0]), "TRUE_RANGE"));
        settingGroup.addRow(new SettingDescriptor[]{new DiscreteDescriptor("method", this.get("LBL_METHOD", new Object[0]), "CLOSE", arrayList)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_ANNUAL", new Object[0]), 254, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_HV", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShadeType(Enums.ShadeType.BELOW);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)HistoricalVolatility$Values.HV, this.get("LBL_HV", new Object[0]), new String[]{"method", "period", "period2"}));
        runtimeDescriptor.declarePath((Object)HistoricalVolatility$Values.HV, "line");
        runtimeDescriptor.declareIndicator((Object)HistoricalVolatility$Values.HV, "ind");
        runtimeDescriptor.setValueSeries((Object)HistoricalVolatility$Values.HV, (Object)"barSize");
        runtimeDescriptor.setRangeKeys(new Object[]{HistoricalVolatility$Values.HV});
        runtimeDescriptor.setMinTick(Double.valueOf(1.0E-4));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public int getMinBars() {
        return this.getSettings().getInteger("period", 20) + 1;
    }

    protected void calculateValues(DataContext dataContext) {
        DataSeries dataSeries;
        BarSize barSize;
        if (dataContext == null) {
            return;
        }
        List list = this.getBarSizes();
        if (!Util.isEmpty((Object)list)) {
            barSize = list.iterator();
            while (barSize.hasNext()) {
                dataSeries = (BarSize)barSize.next();
                DataSeries dataSeries2 = dataContext.getDataSeries((BarSize)dataSeries);
                if (dataSeries2 != null && dataSeries2.hasData()) continue;
                return;
            }
        }
        if ((dataSeries = dataContext.getDataSeries(barSize = this.getSettings().getBarSize("barSize"))) == null) {
            return;
        }
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        String string = this.getSettings().getString("method", "CLOSE");
        StudyHeader studyHeader = this.getHeader();
        boolean bl2 = this.getSettings().isBarUpdates() || studyHeader != null && studyHeader.requiresBarUpdates();
        for (int i2 = 1; i2 < dataSeries.size(); ++i2) {
            float f2;
            if (dataSeries.isComplete(i2) || !bl2 && !dataSeries.isBarComplete(i2)) continue;
            double d2 = 0.0;
            if (Util.compare((Object)string, (Object)"CLOSE")) {
                float f3 = dataSeries.getClose(i2);
                f2 = dataSeries.getClose(i2 - 1);
                d2 = (f3 - f2) / f2;
            } else if (Util.compare((Object)string, (Object)"CLOSE_LN")) {
                float f4 = dataSeries.getClose(i2);
                f2 = dataSeries.getClose(i2 - 1);
                d2 = Math.log(f4 / f2);
            } else if (Util.compare((Object)string, (Object)"HIGH_LOW")) {
                float f5 = dataSeries.getHigh(i2);
                f2 = dataSeries.getLow(i2);
                d2 = f5 / f2;
            } else if (Util.compare((Object)string, (Object)"TRUE_RANGE")) {
                float f6 = dataSeries.getClose(i2 - 1);
                f2 = Util.maxFloat((float[])new float[]{dataSeries.getHigh(i2), f6});
                float f7 = Util.minFloat((float[])new float[]{dataSeries.getLow(i2), f6});
                d2 = f2 / f7;
            }
            dataSeries.setDouble(i2, (Object)HistoricalVolatility$Values.PERCENT_MOVE, Double.valueOf(d2));
            if (i2 < n2 + 1) continue;
            double d3 = 100.0 * dataSeries.std(i2, n2, (Object)HistoricalVolatility$Values.PERCENT_MOVE) * Math.sqrt(n3);
            dataSeries.setDouble(i2, (Object)HistoricalVolatility$Values.HV, Double.valueOf(d3));
            dataSeries.setComplete(i2, dataSeries.isBarComplete(i2));
        }
    }
}

