/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.FisherTransform$Signals;
import com.motivewave.platform.study.general.FisherTransform$Values;

@StudyHeader(namespace="com.motivewave", id="ID_FISH_TRAN", rb="com.motivewave.platform.study.nls.strings2", name="NAME_FISHER_TRANSFORM", label="LBL_FISH", desc="DESC_FISH", menu="MENU_OSCILLATORS", helpLink="http://www.motivewave.com/studies/fisher_transform.htm", signals=true, overlay=false, studyOverlay=true)
public class FisherTransform
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("FISHER_PERIOD", new Object[0]), 10, 10, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SIGNAL_PERIOD", new Object[0]), 2, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_FISH", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_FISH", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.5, 0.0, 9.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -9.01, 9.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -0.5, -9.01, 0.0, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup5);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FisherTransform$Values.FISHER, this.get("LBL_FISH", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FisherTransform$Values.SIGNAL, this.get("FSIG", new Object[0]), new String[]{"input", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FisherTransform$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)FisherTransform$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)FisherTransform$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)FisherTransform$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)FisherTransform$Values.FISHER, "line");
        runtimeDescriptor.declarePath((Object)FisherTransform$Values.SIGNAL, "line2");
        runtimeDescriptor.declareIndicator((Object)FisherTransform$Values.FISHER, "ind");
        runtimeDescriptor.declareIndicator((Object)FisherTransform$Values.SIGNAL, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{FisherTransform$Values.FISHER, FisherTransform$Values.SIGNAL});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(Math.max(n2, n3));
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        double d2;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        int n5 = Math.max(n3, n4);
        if (n2 < n5) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getHigh(n2);
        double d4 = dataSeries.getLow(n2);
        double d5 = dataSeries.getDouble(n2, object, 0.0);
        double d6 = dataSeries.lowest(n2, n3, object);
        double d7 = dataSeries.highest(n2, n3, object);
        double d8 = dataSeries.getDouble(n2 - 1, (Object)FisherTransform$Values.VALUE, 0.0);
        double d9 = dataSeries.getDouble(n2 - 1, (Object)FisherTransform$Values.FISHER, 0.0);
        double d10 = dataSeries.getDouble(n2 - n4, (Object)FisherTransform$Values.FISHER, 0.0);
        double d11 = (d5 - d6) / (d7 - d6);
        if (d7 == d6) {
            d11 = 0.0;
        }
        if ((d2 = 1.0 * (d11 - 0.5) + 0.5 * d8) > 0.9999) {
            d2 = 0.9999;
        }
        if (d2 < -0.9999) {
            d2 = -0.9999;
        }
        dataSeries.setDouble(n2, (Object)FisherTransform$Values.VALUE, Double.valueOf(d2));
        d11 = (1.0 + d2) / (1.0 - d2);
        double d12 = 0.25 * Math.log(d11) + 0.5 * d9;
        dataSeries.setDouble(n2, (Object)FisherTransform$Values.FISHER, Double.valueOf(d12));
        dataSeries.setDouble(n2, (Object)FisherTransform$Values.SIGNAL, Double.valueOf(d10));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d13 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d14 = guideInfo2.getValue();
        boolean bl2 = d12 > d13 && this.crossedBelow(dataSeries, n2, (Object)FisherTransform$Values.FISHER, (Object)FisherTransform$Values.SIGNAL) && d12 > this.a;
        boolean bl3 = d12 < d14 && this.crossedAbove(dataSeries, n2, (Object)FisherTransform$Values.FISHER, (Object)FisherTransform$Values.SIGNAL) && d12 < this.b;
        dataSeries.setBoolean(n2, (Object)FisherTransform$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)FisherTransform$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_FISHER_TRANSFORM_HIGH_FISHER", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)FisherTransform$Signals.SELL, string, (Object)d3);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d12;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d12);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_FISHER_TRANSFORM_LOW_FISHER", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d12, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)FisherTransform$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

