/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.ErgodicTsiTwo$Values;

@StudyHeader(namespace="com.motivewave", id="ID_ETSI2", rb="com.motivewave.platform.study.nls.strings2", name="NAME_ERGODIC_TSI2", desc="DESC_ETSI2", menu="MENU_WILLIAM_BLAU", label="LBL_ETSI2", helpLink="http://www.motivewave.com/studies/ergodic_tsi2.htm", signals=false, overlay=false, studyOverlay=true)
public class ErgodicTsiTwo
extends Study {
    static final String a = "Period5";
    static final String b = "Period6";
    static final String c = "Period7";
    static final String d = "Ind3";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 21, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("PERIOD3", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("PERIOD4", new Object[0]), 17, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("PERIOD5", new Object[0]), 6, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("PERIOD6", new Object[0]), 2, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("SMOOTH_PERIOD", new Object[0]), 2, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_ETSI2", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LBL_ETSI", new Object[0]), defaults.getGreen(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_ETSI2", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("LBL_ETSI", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(d, this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -999.1, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "period4", a, b, c, "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ErgodicTsiTwo$Values.ETSI2, this.get("LBL_ETSI2", new Object[0]), new String[]{"input", "period", "period2", "period3", "period4", a, b, c, "method"}));
        runtimeDescriptor.declarePath((Object)ErgodicTsiTwo$Values.ETSI2, "line");
        runtimeDescriptor.declarePath((Object)ErgodicTsiTwo$Values.ETSI, "line2");
        runtimeDescriptor.declarePath((Object)ErgodicTsiTwo$Values.SIG, "line3");
        runtimeDescriptor.declareIndicator((Object)ErgodicTsiTwo$Values.ETSI2, "ind");
        runtimeDescriptor.declareIndicator((Object)ErgodicTsiTwo$Values.ETSI, "ind2");
        runtimeDescriptor.declareIndicator((Object)ErgodicTsiTwo$Values.SIG, d);
        runtimeDescriptor.setRangeKeys(new Object[]{ErgodicTsiTwo$Values.ETSI2, ErgodicTsiTwo$Values.ETSI, ErgodicTsiTwo$Values.SIG});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        int n6 = this.getSettings().getInteger(a);
        int n7 = this.getSettings().getInteger(b);
        int n8 = this.getSettings().getInteger(c);
        int n9 = Math.max(n2, n5);
        int n10 = Math.max(n3, n6);
        int n11 = Math.max(n4, n7);
        this.setMinBars(n9 + n10 + n11 + n8 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        int n7 = this.getSettings().getInteger(a);
        int n8 = this.getSettings().getInteger(b);
        int n9 = this.getSettings().getInteger(c);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        int n10 = Math.max(n3, n6);
        int n11 = Math.max(n4, n7);
        int n12 = Math.max(n5, n8);
        Double d2 = 0.0;
        Double d3 = 0.0;
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d6 = d4 - d5;
        double d7 = Math.abs(d4 - d5);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.PRICE_D, Double.valueOf(d6));
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.ABS_PRICE_D, Double.valueOf(d7));
        if (n2 < n10 + 1) {
            return;
        }
        Double d8 = dataSeries.ma(mAMethod, n2, n3, (Object)ErgodicTsiTwo$Values.PRICE_D);
        Double d9 = dataSeries.ma(mAMethod, n2, n3, (Object)ErgodicTsiTwo$Values.ABS_PRICE_D);
        Double d10 = dataSeries.ma(mAMethod, n2, n6, (Object)ErgodicTsiTwo$Values.PRICE_D);
        Double d11 = dataSeries.ma(mAMethod, n2, n6, (Object)ErgodicTsiTwo$Values.ABS_PRICE_D);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.MA1, d8);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.AMA1, d9);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.MA4, d10);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.AMA4, d11);
        if (n2 < n10 + n11 + 1) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n4, (Object)ErgodicTsiTwo$Values.MA1);
        Double d13 = dataSeries.ma(mAMethod, n2, n4, (Object)ErgodicTsiTwo$Values.AMA1);
        Double d14 = dataSeries.ma(mAMethod, n2, n7, (Object)ErgodicTsiTwo$Values.MA4);
        Double d15 = dataSeries.ma(mAMethod, n2, n7, (Object)ErgodicTsiTwo$Values.AMA4);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.MA2, d12);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.AMA2, d13);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.MA5, d14);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.AMA5, d15);
        if (n2 < n10 + n11 + n12 + 1) {
            return;
        }
        Double d16 = dataSeries.ma(mAMethod, n2, n5, (Object)ErgodicTsiTwo$Values.MA2);
        Double d17 = dataSeries.ma(mAMethod, n2, n5, (Object)ErgodicTsiTwo$Values.AMA2);
        Double d18 = dataSeries.ma(mAMethod, n2, n8, (Object)ErgodicTsiTwo$Values.MA5);
        Double d19 = dataSeries.ma(mAMethod, n2, n8, (Object)ErgodicTsiTwo$Values.AMA5);
        if (d16 == null || d17 == null || d18 == null || d19 == null) {
            return;
        }
        if (d17 != 0.0) {
            d2 = 100.0 * d16 / d17;
            dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.ETSI, d2);
        }
        if (d19 != 0.0) {
            d3 = 100.0 * d18 / d19;
            dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.ETSI2, d3);
        }
        if (n2 < n10 + n11 + n12 + n9 + 1) {
            return;
        }
        Double d20 = dataSeries.ma(mAMethod, n2, n9, (Object)ErgodicTsiTwo$Values.ETSI);
        dataSeries.setDouble(n2, (Object)ErgodicTsiTwo$Values.SIG, d20);
        dataSeries.setComplete(n2);
    }
}

