/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.DynamicMomentumIndex$Signals;
import com.motivewave.platform.study.general.DynamicMomentumIndex$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_DMI", rb="com.motivewave.platform.study.nls.strings2", desc="DESC_DMI", name="NAME_DYNAMIC_MOMENTUM_INDEX", label="LBL_DMI", menu="MENU_TUSHAR_CHANDE", helpLink="http://www.motivewave.com/studies/dynamic_momentum_index.htm", signals=true, overlay=false, studyOverlay=true)
public class DynamicMomentumIndex
extends Study {
    static final String a = "Period5";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("STANDARD_DEVIATION_PERIOD", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("STDANDARD_DEVIATION_AVERAGE_PERIOD", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("RSI_PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("UPPER_LIMIT", new Object[0]), 30, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LOWER_LIMIT", new Object[0]), 5, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_DMI", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 60.0, 0.0, 100.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 100.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 40.0, 0.0, 100.01, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3", "period4", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DynamicMomentumIndex$Values.DMI, this.get("LBL_DMI", new Object[0]), new String[]{"input", "period", "period2", "period3", "period4", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DynamicMomentumIndex$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DynamicMomentumIndex$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)DynamicMomentumIndex$Values.DMI, "line");
        runtimeDescriptor.declareIndicator((Object)DynamicMomentumIndex$Values.DMI, "ind");
        runtimeDescriptor.declareSignal((Object)DynamicMomentumIndex$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DynamicMomentumIndex$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{DynamicMomentumIndex$Values.DMI});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        int n6 = this.getSettings().getInteger(a);
        this.setMinBars(n2 + n3 + Math.max(Math.max(n4, n5), n6));
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        int n7 = this.getSettings().getInteger(a);
        if (n2 < n3) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.std(n2, n3, object);
        dataSeries.setDouble(n2, (Object)DynamicMomentumIndex$Values.STD_DEV, Double.valueOf(d3));
        if (n2 < n3 + n4 + Math.max(Math.max(n5, n6), n7)) {
            return;
        }
        Double d4 = dataSeries.sma(n2, n4, (Object)DynamicMomentumIndex$Values.STD_DEV);
        if (d4 == null) {
            return;
        }
        int n8 = (int)Math.round((double)n5 / (d4 / d3));
        int n9 = Math.max(Math.min(n8, n6), n7);
        double d5 = dataSeries.getDouble(n2, object) - dataSeries.getDouble(n2 - 1, object);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d5 > 0.0) {
            d6 = d5;
        } else {
            d7 = d5;
        }
        dataSeries.setDouble(n2, (Object)DynamicMomentumIndex$Values.UP, Double.valueOf(d6));
        dataSeries.setDouble(n2, (Object)DynamicMomentumIndex$Values.DOWN, Double.valueOf(Math.abs(d7)));
        if (n2 < n9 + n3 + n4 + Math.max(Math.max(n5, n6), n7)) {
            return;
        }
        Double d8 = dataSeries.ma(Enums.MAMethod.EMA, n2, n9, (Object)DynamicMomentumIndex$Values.UP);
        if (d8 == null) {
            return;
        }
        Double d9 = dataSeries.ma(Enums.MAMethod.EMA, n2, n9, (Object)DynamicMomentumIndex$Values.DOWN);
        if (d9 == null) {
            return;
        }
        double d10 = d8 / d9;
        double d11 = 100.0 - 100.0 / (1.0 + d10);
        dataSeries.setDouble(n2, (Object)DynamicMomentumIndex$Values.DMI, Double.valueOf(d11));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d12 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d13 = guideInfo2.getValue();
        double d14 = dataSeries.getDouble(n2 - 1, (Object)DynamicMomentumIndex$Values.DMI, 0.0);
        boolean bl2 = d11 > d12 && d14 > d11 && d11 > this.a;
        boolean bl3 = d11 < d13 && d14 < d11 && d11 < this.b;
        dataSeries.setBoolean(n2, (Object)DynamicMomentumIndex$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)DynamicMomentumIndex$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d11;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_DMI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d11, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DynamicMomentumIndex$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d11;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_DMI", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d11, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DynamicMomentumIndex$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

