/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.Demarker$Signals;
import com.motivewave.platform.study.general.Demarker$Values;

@StudyHeader(namespace="com.motivewave", id="DEMARKER", rb="com.motivewave.platform.study.nls.strings", name="TITLE_DEMARKER", desc="DESC_DEMARKER", menu="MENU_GENERAL", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/demarker.htm")
public class Demarker
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 70.0, 1.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 30.0, 1.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)Demarker$Values.DM, this.get("LBL_DM", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)Demarker$Values.DM, "line");
        runtimeDescriptor.declareIndicator((Object)Demarker$Values.DM, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{Demarker$Values.DM});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(15));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(85));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        runtimeDescriptor.declareSignal((Object)Demarker$Signals.DM_TOP, this.get("LBL_DM_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)Demarker$Signals.DM_BOTTOM, this.get("LBL_DM_BOTTOM", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period", 14);
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        if (dataSeries.getHigh(n2) > dataSeries.getHigh(n2 - 1)) {
            d2 = dataSeries.getHigh(n2) - dataSeries.getHigh(n2 - 1);
        }
        if (dataSeries.getLow(n2) < dataSeries.getLow(n2 - 1)) {
            d3 = dataSeries.getLow(n2 - 1) - dataSeries.getLow(n2);
        }
        dataSeries.setDouble(n2, (Object)Demarker$Values.DMAX, Double.valueOf(d2));
        dataSeries.setDouble(n2, (Object)Demarker$Values.DMIN, Double.valueOf(d3));
        if (n2 < n3 + 1) {
            return;
        }
        double d4 = dataSeries.sma(n2, n3, (Object)Demarker$Values.DMAX);
        double d5 = dataSeries.sma(n2, n3, (Object)Demarker$Values.DMIN);
        double d6 = d4 / (d4 + d5) * 100.0;
        dataSeries.setDouble(n2, (Object)Demarker$Values.DM, Double.valueOf(d6));
        dataSeries.setComplete(n2);
        if (!dataSeries.isBarComplete(n2)) {
            return;
        }
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        d6 = this.round(d6);
        if (this.crossedAbove(dataSeries, n2, (Object)Demarker$Values.DM, guideInfo.getValue())) {
            dataContext.signal(n2, (Object)Demarker$Signals.DM_TOP, this.get("SIGNAL_DM_TOP", new Object[]{d6, guideInfo.getValue()}), (Object)d6);
        } else if (this.crossedBelow(dataSeries, n2, (Object)Demarker$Values.DM, guideInfo2.getValue())) {
            dataContext.signal(n2, (Object)Demarker$Signals.DM_BOTTOM, this.get("SIGNAL_DM_BOTTOM", new Object[]{d6, guideInfo2.getValue()}), (Object)d6);
        }
    }
}

