/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.DThreeTenOsc$Signals;
import com.motivewave.platform.study.general.DThreeTenOsc$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_D3TO", rb="com.motivewave.platform.study.nls.strings2", desc="DESC_D3TO", name="NAME_D_THREE_TEN_OSC", label="LBL_D3TO", menu="MENU_BILL_MARS", helpLink="http://www.motivewave.com/studies/d_three_ten_oscillator.htm", signals=true, overlay=false, studyOverlay=true)
public class DThreeTenOsc
extends Study {
    static final String a = "Filter";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("PERIOD3", new Object[0]), 16, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("FAST", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SLOW", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("FAST", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SLOW", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 0.005, 0.0, 999.001, 0.001, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -99.001, 99.001, 0.001, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -0.005, -999.001, 0.0, 0.001, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DThreeTenOsc$Values.V1, this.get("V1", new Object[0]), new String[]{"method", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DThreeTenOsc$Values.V2, this.get("V2", new Object[0]), new String[]{"method", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DThreeTenOsc$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DThreeTenOsc$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)DThreeTenOsc$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DThreeTenOsc$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)DThreeTenOsc$Values.V1, "line");
        runtimeDescriptor.declarePath((Object)DThreeTenOsc$Values.V2, "line2");
        runtimeDescriptor.declareIndicator((Object)DThreeTenOsc$Values.V1, "ind");
        runtimeDescriptor.declareIndicator((Object)DThreeTenOsc$Values.V2, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{DThreeTenOsc$Values.V1, DThreeTenOsc$Values.V2});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(Math.max(Math.max(n2, n3), n4) * 4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = Math.max(Math.max(n3, n4), n5);
        if (n2 < n6) {
            return;
        }
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, (Object)Enums.BarInput.HIGH, 0.0);
        double d3 = dataSeries.getDouble(n2, (Object)Enums.BarInput.LOW, 0.0);
        Double d4 = dataSeries.ma(mAMethod, n2, n3, object);
        dataSeries.setDouble(n2, (Object)DThreeTenOsc$Values.MA3DAY, d4);
        if (n2 < n6 * 2) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod, n2, n4, (Object)DThreeTenOsc$Values.MA3DAY);
        dataSeries.setDouble(n2, (Object)DThreeTenOsc$Values.MA10DAY, d5);
        if (n2 < n6 * 3) {
            return;
        }
        if (d4 == null || d5 == null) {
            return;
        }
        double d6 = d4 - d5;
        dataSeries.setDouble(n2, (Object)DThreeTenOsc$Values.V1, Double.valueOf(d6));
        if (n2 < n6 * 4) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n5, (Object)DThreeTenOsc$Values.V1);
        dataSeries.setDouble(n2, (Object)DThreeTenOsc$Values.V2, d7);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d8 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d9 = guideInfo2.getValue();
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)DThreeTenOsc$Values.V1, (Object)DThreeTenOsc$Values.V2) && d6 > d8 && d6 > this.a;
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)DThreeTenOsc$Values.V1, (Object)DThreeTenOsc$Values.V2) && d6 < d9 && d6 < this.b;
        dataSeries.setBoolean(n2, (Object)DThreeTenOsc$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)DThreeTenOsc$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d6;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_HIGH_D3TO", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DThreeTenOsc$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d6;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d6);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_LOW_D3TO", new Object[]{Util.round((double)d3, (int)2), Util.round((double)d6, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DThreeTenOsc$Signals.BUY, string, (Object)d3);
        }
        dataSeries.setComplete(n2);
    }
}

