/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.DSSStoch$Signals;
import com.motivewave.platform.study.general.DSSStoch$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_DSSTD", rb="com.motivewave.platform.study.nls.strings2", label="LBL_DSSTD", name="NAME_DOUBLE_SMOOTH_STOCHASTIC", desc="DESC_DSSTD", menu="MENU_WILLIAM_BLAU", helpLink="http://www.motivewave.com/studies/double_smooth_stochastic.htm", signals=true, overlay=false, studyOverlay=true)
public class DSSStoch
extends Study {
    static final String a = "HighLow";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("K_PERIOD", new Object[0]), 2, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("SINGLE_SMOOTH_PERIOD", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("DOUBLE_SMOOTH_PERIOD", new Object[0]), 15, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("SMOOTHED_DS_PERIOD", new Object[0]), 3, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(a, this.get("HIGH_LOW", new Object[0]), Boolean.valueOf(true))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_DSSTD", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_DSSTD", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "period3", "period4", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DSSStoch$Values.DSS, this.get("LBL_DSSTD", new Object[0]), new String[]{"input", "method", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DSSStoch$Values.SDSS, this.get("SDSS", new Object[0]), new String[]{"method", "period4"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DSSStoch$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DSSStoch$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)DSSStoch$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DSSStoch$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)DSSStoch$Values.DSS, "line");
        runtimeDescriptor.declarePath((Object)DSSStoch$Values.SDSS, "line2");
        runtimeDescriptor.declareIndicator((Object)DSSStoch$Values.DSS, "ind");
        runtimeDescriptor.declareIndicator((Object)DSSStoch$Values.SDSS, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{DSSStoch$Values.DSS, DSSStoch$Values.SDSS});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        this.setMinBars(n2 + n3 + n4 + n5);
    }

    protected void precalculate(DataContext dataContext) {
        super.precalculate(dataContext);
        this.a = Double.NEGATIVE_INFINITY;
        this.b = Double.MAX_VALUE;
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        boolean bl2 = this.getSettings().getBoolean(a);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        if (bl2) {
            d2 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
            d3 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        } else {
            d2 = dataSeries.lowest(n2, n3, object);
            d3 = dataSeries.highest(n2, n3, object);
        }
        double d5 = d4 - d2;
        double d6 = d3 - d2;
        dataSeries.setDouble(n2, (Object)DSSStoch$Values.NUM, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)DSSStoch$Values.DEN, Double.valueOf(d6));
        if (n2 < n3 + n4) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n4, (Object)DSSStoch$Values.NUM);
        Double d8 = dataSeries.ma(mAMethod, n2, n4, (Object)DSSStoch$Values.DEN);
        dataSeries.setDouble(n2, (Object)DSSStoch$Values.SSNUM, d7);
        dataSeries.setDouble(n2, (Object)DSSStoch$Values.SSDEN, d8);
        if (n2 < n3 + n4 + n5) {
            return;
        }
        Double d9 = dataSeries.ma(mAMethod, n2, n5, (Object)DSSStoch$Values.SSNUM);
        Double d10 = dataSeries.ma(mAMethod, n2, n5, (Object)DSSStoch$Values.SSDEN);
        if (d9 == null || d10 == null) {
            return;
        }
        if (d10 == 0.0) {
            return;
        }
        double d11 = 100.0 * d9 / d10;
        dataSeries.setDouble(n2, (Object)DSSStoch$Values.DSS, Double.valueOf(d11));
        if (n2 < n3 + n4 + n5 + n6) {
            return;
        }
        Double d12 = dataSeries.ma(mAMethod, n2, n6, (Object)DSSStoch$Values.DSS);
        dataSeries.setDouble(n2, (Object)DSSStoch$Values.SDSS, d12);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d13 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d14 = guideInfo2.getValue();
        boolean bl3 = this.crossedBelow(dataSeries, n2, (Object)DSSStoch$Values.DSS, (Object)DSSStoch$Values.SDSS) && d11 > d13 && d11 > this.a;
        boolean bl4 = this.crossedAbove(dataSeries, n2, (Object)DSSStoch$Values.DSS, (Object)DSSStoch$Values.SDSS) && d11 < d14 && d11 < this.b;
        dataSeries.setBoolean(n2, (Object)DSSStoch$Signals.BUY, Boolean.valueOf(bl4));
        dataSeries.setBoolean(n2, (Object)DSSStoch$Signals.SELL, Boolean.valueOf(bl3));
        if (bl3) {
            this.a = d11;
            this.b = Double.MAX_VALUE;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_DSSTD", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d11, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DSSStoch$Signals.SELL, string, (Object)d4);
        }
        if (bl4) {
            this.b = d11;
            this.a = Double.NEGATIVE_INFINITY;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d11);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_DSSTD", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d11, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DSSStoch$Signals.BUY, string, (Object)d4);
        }
        if (d11 < d13) {
            this.a = Double.NEGATIVE_INFINITY;
        }
        if (d11 > d14) {
            this.b = Double.MAX_VALUE;
        }
        dataSeries.setComplete(n2);
    }
}

