/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.DBAFilter$Signals;
import com.motivewave.platform.study.general.DBAFilter$Values;

@StudyHeader(namespace="com.motivewave", id="ID_DVBAF", rb="com.motivewave.platform.study.nls.strings2", name="NAME_DIVERGENT_BARS_ALLIGATOR_FILTER", label="LBL_DVBAF", desc="DESC_DVBAF", menu="MENU_BILL_WILLIAMS", helpLink="http://www.motivewave.com/studies/divergent_bars_alligator_filter.htm", signals=true, overlay=true, studyOverlay=true)
public class DBAFilter
extends Study {
    static final String a = "jawShift";
    static final String b = "jawInd";
    static final String c = "teethShift";
    static final String d = "teethInd";
    static final String e = "lipsShift";
    static final String f = "lipsInd";
    static final String g = "ubInd";
    static final String h = "lbInd";
    static final String i = "Factor";
    static final String j = "Path5";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.MIDPOINT)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("JAW_PERIOD", new Object[0]), 13, 1, 999, 1), new IntegerDescriptor(a, this.get("SHIFT", new Object[0]), 8, 0, 99, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("TEETH_PERIOD", new Object[0]), 8, 1, 999, 1), new IntegerDescriptor(c, this.get("SHIFT", new Object[0]), 5, 0, 99, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("LIPS_PERIOD", new Object[0]), 5, 1, 999, 1), new IntegerDescriptor(e, this.get("SHIFT", new Object[0]), 3, 0, 99, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(i, this.get("%FACTOR", new Object[0]), 1.0, -100.01, 100.01, 0.01)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("JAW", new Object[0]), defaults.getBlue(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("TEETH", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("LIPS", new Object[0]), defaults.getGreen(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line4", this.get("FILTER_UPPER", new Object[0]), defaults.getLineColor(), 0.025f, new float[]{5.0f, 5.0f}, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(j, this.get("FILTER_LOWER", new Object[0]), defaults.getLineColor(), 0.025f, new float[]{5.0f, 5.0f}, true, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("JAW", new Object[0]), defaults.getBlue(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(d, this.get("TEETH", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("LIPS", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(g, this.get("FILTER_UPPER", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(h, this.get("FILTER_LOWER", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DBAFilter$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DBAFilter$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)DBAFilter$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)DBAFilter$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", a, "period2", c, "period3", e, i});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DBAFilter$Values.JAW, this.get("JAW", new Object[0]), new String[]{"input", "method", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DBAFilter$Values.TEETH, this.get("TEETH", new Object[0]), new String[]{"input", "method", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DBAFilter$Values.LIPS, this.get("LIPS", new Object[0]), new String[]{"input", "method", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DBAFilter$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DBAFilter$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declarePath((Object)DBAFilter$Values.JAW, "line");
        runtimeDescriptor.declarePath((Object)DBAFilter$Values.TEETH, "line2");
        runtimeDescriptor.declarePath((Object)DBAFilter$Values.LIPS, "line3");
        runtimeDescriptor.declarePath((Object)DBAFilter$Values.UB, "line4");
        runtimeDescriptor.declarePath((Object)DBAFilter$Values.LB, j);
        runtimeDescriptor.declareIndicator((Object)DBAFilter$Values.JAW, b);
        runtimeDescriptor.declareIndicator((Object)DBAFilter$Values.TEETH, d);
        runtimeDescriptor.declareIndicator((Object)DBAFilter$Values.LIPS, f);
        runtimeDescriptor.declareIndicator((Object)DBAFilter$Values.UB, g);
        runtimeDescriptor.declareIndicator((Object)DBAFilter$Values.LB, h);
        runtimeDescriptor.setRangeKeys(new Object[]{DBAFilter$Values.UB, DBAFilter$Values.LB, DBAFilter$Values.JAW, DBAFilter$Values.TEETH, DBAFilter$Values.LIPS});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(Math.max(Math.max(n2, n3), n4));
    }

    protected synchronized void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        double d2;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        if (n2 < n4) {
            return;
        }
        int n5 = this.getSettings().getInteger("period3");
        if (n2 < n5) {
            return;
        }
        int n6 = this.getSettings().getInteger(a);
        int n7 = this.getSettings().getInteger(c);
        int n8 = this.getSettings().getInteger(e);
        double d3 = this.getSettings().getDouble(i);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.MIDPOINT);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMMA);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d4 = dataSeries.getLow(n2);
        double d5 = dataSeries.getHigh(n2);
        float f2 = dataSeries.getClose(n2);
        double d6 = dataSeries.getLow(n2 - 1);
        double d7 = dataSeries.getHigh(n2 - 1);
        double d8 = (d5 + d4) / 2.0;
        Double d9 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d9 == null) {
            return;
        }
        dataSeries.setDouble(n2 + n6, (Object)DBAFilter$Values.JAW, d9);
        double d10 = dataSeries.getDouble(n2, (Object)DBAFilter$Values.JAW, d9.doubleValue());
        Double d11 = dataSeries.ma(mAMethod, n2, n4, object);
        if (d11 == null) {
            return;
        }
        dataSeries.setDouble(n2 + n7, (Object)DBAFilter$Values.TEETH, d11);
        double d12 = dataSeries.getDouble(n2, (Object)DBAFilter$Values.TEETH, d11.doubleValue());
        Double d13 = dataSeries.ma(mAMethod, n2, n5, object);
        if (d13 == null) {
            return;
        }
        dataSeries.setDouble(n2 + n8, (Object)DBAFilter$Values.LIPS, d13);
        double d14 = dataSeries.getDouble(n2, (Object)DBAFilter$Values.LIPS, d13.doubleValue());
        double d15 = Math.min(Math.min(d10, d12), d14);
        double d16 = Math.max(Math.max(d10, d12), d14);
        double d17 = (d16 + d15) * 0.5;
        double d18 = d15 - d3 * d15 / 100.0;
        if (d18 > d17) {
            d18 = d17;
        }
        if ((d2 = d16 + d3 * d16 / 100.0) < d17) {
            d2 = d17;
        }
        dataSeries.setDouble(n2, (Object)DBAFilter$Values.UB, Double.valueOf(d2));
        dataSeries.setDouble(n2, (Object)DBAFilter$Values.LB, Double.valueOf(d18));
        boolean bl2 = d4 < d6 && (double)f2 > d8 && d4 < d18;
        boolean bl3 = d5 > d7 && (double)f2 < d8 && d5 > d2;
        dataSeries.setBoolean(n2, (Object)DBAFilter$Signals.SELL, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)DBAFilter$Signals.BUY, Boolean.valueOf(bl2));
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d5);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_DVBAF_CLOSE", new Object[]{Float.valueOf(Util.round((float)f2, (int)2))});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DBAFilter$Signals.SELL, string, (Object)Float.valueOf(f2));
        }
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d4);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_DVBAF_CLOSE", new Object[]{Float.valueOf(Util.round((float)f2, (int)2))});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)DBAFilter$Signals.BUY, string, (Object)Float.valueOf(f2));
        }
        dataSeries.setComplete(n2);
    }
}

