/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.ContractHiLow$Values;

@StudyHeader(namespace="com.motivewave", id="ID_CTHL", rb="com.motivewave.platform.study.nls.strings2", name="NAME_CONTRACT_HI_LOW", label="LBL_CTHL", desc="DESC_CTHL", helpLink="http://www.motivewave.com/studies/contract_hi_low.htm", signals=false, overlay=false, studyOverlay=true)
public class ContractHiLow
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("HIGH", new Object[0]), defaults.getRed(), 1.0f, null, true, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("LOW", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingTab.addGroup(settingGroup);
        settingGroup = new SettingGroup(this.get("INDICATORS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("HIGH", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("LOW", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[0]);
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ContractHiLow$Values.CONHI, this.get("HIGH", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ContractHiLow$Values.CONLOW, this.get("LOW", new Object[0]), new String[0]));
        runtimeDescriptor.declarePath((Object)ContractHiLow$Values.CONHI, "line");
        runtimeDescriptor.declarePath((Object)ContractHiLow$Values.CONLOW, "line2");
        runtimeDescriptor.declareIndicator((Object)ContractHiLow$Values.CONHI, "ind");
        runtimeDescriptor.declareIndicator((Object)ContractHiLow$Values.CONLOW, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{ContractHiLow$Values.CONHI, ContractHiLow$Values.CONLOW});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        this.setMinBars(20);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, (Object)Enums.BarInput.HIGH, 0.0);
        double d3 = dataSeries.getDouble(n2, (Object)Enums.BarInput.LOW, 0.0);
        double d4 = dataSeries.getDouble(n2 - 1, (Object)ContractHiLow$Values.CONHI, d2);
        double d5 = dataSeries.getDouble(n2 - 1, (Object)ContractHiLow$Values.CONLOW, d3);
        if (d2 > d4) {
            d4 = d2;
        }
        if (d3 < d5) {
            d5 = d3;
        }
        dataSeries.setDouble(n2, (Object)ContractHiLow$Values.CONHI, Double.valueOf(d4));
        dataSeries.setDouble(n2, (Object)ContractHiLow$Values.CONLOW, Double.valueOf(d5));
        dataSeries.setComplete(n2);
    }
}

