/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BarDescriptor;
import com.motivewave.platform.sdk.common.desc.BarSizeDescriptor;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.EnabledDependency;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDependency;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.Plot;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.CompositeSample$Signals;
import com.motivewave.platform.study.general.CompositeSample$Values;

@StudyHeader(namespace="com.motivewave", id="COMP_SAMPLE", rb="com.motivewave.platform.study.nls.strings", name="TITLE_COMP_SAMPLE", desc="DESC_COMP_SAMPLE", overlay=false, signals=true)
public class CompositeSample
extends Study {
    static final String a = "maPeriod";
    static final String b = "maInput";
    static final String c = "maMethod";
    static final String d = "macdInput";
    static final String e = "macdMethod";
    static final String f = "macdPeriod1";
    static final String g = "macdPeriod2";
    static final String h = "rsiPeriod";
    static final String i = "rsiInput";
    static final String j = "rsiMethod";
    static final String k = "macdLine";
    static final String l = "macdInd";
    static final String m = "histInd";
    static final String n = "rsiLine";
    static final String o = "rsiInd";
    static final String p = "RSIPlot";
    protected String q = "";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_MA", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new BarSizeDescriptor("barSize", this.get("LBL_BAR_SIZE", new Object[0]), BarSize.getBarSize((int)5))});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(b, this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1), new IntegerDescriptor("shift", this.get("LBL_SHIFT", new Object[0]), 0, -999, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor("fillForward", this.get("LBL_FILL_FORWARD", new Object[0]), Boolean.valueOf(true))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), null, 1.0f, null, true, true, false)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_BAR_COLOR", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new BooleanDescriptor("enableBarColor", this.get("LBL_ENABLE_BAR_COLOR", new Object[0]), Boolean.valueOf(false))});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreenLine())});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("LBL_NEUTRAL_COLOR", new Object[0]), defaults.getLineColor())});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRedLine())});
        settingTab.addGroup(settingGroup3);
        settingsDescriptor.addDependency((InputDependency)new EnabledDependency("enableBarColor", new String[]{"upColor", "neutralColor", "downColor"}));
        settingTab = new SettingTab(this.get("TAB_MACD", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(d, this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(e, this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("signalMethod", this.get("LBL_SIGNAL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(f, this.get("LBL_PERIOD1", new Object[0]), 12, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(g, this.get("LBL_PERIOD2", new Object[0]), 26, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_DISPLAY", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new PathDescriptor(k, this.get("LBL_MACD_LINE", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new BarDescriptor("bar", this.get("LBL_BAR_COLOR", new Object[0]), defaults.getBarColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), false, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), false, true)});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new IndicatorDescriptor(l, this.get("LBL_MACD_IND", new Object[0]), null, null, false, true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new IndicatorDescriptor(m, this.get("LBL_MACD_HIST_IND", new Object[0]), defaults.getBarColor(), null, false, false, true)});
        settingTab.addGroup(settingGroup5);
        settingTab = new SettingTab(this.get("TAB_RSI", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor(i, this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor(j, this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(h, this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        settingGroup4 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new PathDescriptor(n, this.get("LBL_RSI_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", n, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", n, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new IndicatorDescriptor(o, this.get("LBL_RSI_IND", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup6 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup6.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 70.0, 1.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup6.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup6.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 30.0, 1.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup6);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        this.setRuntimeDescriptor(runtimeDescriptor);
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CompositeSample$Values.MA, this.q, new String[]{"input", "period", "shift", "barSize"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CompositeSample$Values.RSI, this.get("LBL_RSI", new Object[0]), new String[]{"input", "period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CompositeSample$Values.MACD, this.get("LBL_MACD", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CompositeSample$Values.SIGNAL, this.get("LBL_MACD_SIGNAL", new Object[0]), new String[]{"signalPeriod"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CompositeSample$Values.HIST, this.get("LBL_MACD_HIST", new Object[0]), new String[]{"period", "period2", "signalPeriod"}));
        runtimeDescriptor.declareSignal((Object)CompositeSample$Signals.CROSS_ABOVE, this.get("LBL_CROSS_ABOVE_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)CompositeSample$Signals.CROSS_BELOW, this.get("LBL_CROSS_BELOW_SIGNAL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)CompositeSample$Signals.RSI_TOP, this.get("RSI_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)CompositeSample$Signals.RSI_BOTTOM, this.get("RSI_BOTTOM", new Object[0]));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{b, a, "shift", "barSize"});
        runtimeDescriptor.getPricePlot().setLabelPrefix("MA");
        runtimeDescriptor.getPricePlot().declarePath((Object)CompositeSample$Values.MA, "line");
        runtimeDescriptor.getPricePlot().declareIndicator((Object)CompositeSample$Values.MA, "ind");
        runtimeDescriptor.setValueSeries((Object)CompositeSample$Values.MA, (Object)"barSize");
        runtimeDescriptor.setLabelSettings(new String[]{d, e, f, g, "signalPeriod"});
        runtimeDescriptor.setLabelPrefix("MACD");
        runtimeDescriptor.setTabName("MACD");
        runtimeDescriptor.declarePath((Object)CompositeSample$Values.MACD, k);
        runtimeDescriptor.declarePath((Object)CompositeSample$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declareBars((Object)CompositeSample$Values.HIST, "bar");
        runtimeDescriptor.declareIndicator((Object)CompositeSample$Values.MACD, l);
        runtimeDescriptor.declareIndicator((Object)CompositeSample$Values.SIGNAL, "signalInd");
        runtimeDescriptor.declareIndicator((Object)CompositeSample$Values.HIST, m);
        runtimeDescriptor.setRangeKeys(new Object[]{CompositeSample$Values.MACD, CompositeSample$Values.SIGNAL, CompositeSample$Values.HIST});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        Plot plot = new Plot();
        runtimeDescriptor.addPlot(p, plot);
        plot.setLabelSettings(new String[]{i, h});
        plot.setLabelPrefix("RSI");
        plot.setTabName("RSI");
        plot.declarePath((Object)CompositeSample$Values.RSI, n);
        plot.declareIndicator((Object)CompositeSample$Values.RSI, o);
        plot.declareGuide("topGuide");
        plot.declareGuide("middleGuide");
        plot.declareGuide("bottomGuide");
        plot.setMaxBottomValue(Integer.valueOf(15));
        plot.setMinTopValue(Integer.valueOf(85));
        plot.setRangeKeys(new Object[]{CompositeSample$Values.RSI});
        plot.setMinTick(Double.valueOf(0.1));
    }

    protected void calculateValues(DataContext dataContext) {
        int n2 = this.getSettings().getInteger(a);
        Object object = this.getSettings().getInput(b, (Object)Enums.BarInput.CLOSE);
        BarSize barSize = this.getSettings().getBarSize("barSize");
        DataSeries dataSeries = dataContext.getDataSeries(barSize);
        StudyHeader studyHeader = this.getHeader();
        boolean bl2 = this.getSettings().isBarUpdates() || studyHeader != null && studyHeader.requiresBarUpdates();
        for (int i2 = 1; i2 < dataSeries.size(); ++i2) {
            if (dataSeries.isComplete(i2) || !bl2 && !dataSeries.isBarComplete(i2)) continue;
            Double d2 = dataSeries.ma(Enums.MAMethod.SMA, i2, n2, object);
            dataSeries.setDouble(i2, (Object)CompositeSample$Values.MA, d2);
        }
        super.calculateValues(dataContext);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Object object;
        double d2;
        Object object2;
        DataSeries dataSeries = dataContext.getDataSeries();
        boolean bl2 = true;
        int n3 = this.getSettings().getInteger(f, 12);
        int n4 = this.getSettings().getInteger(g, 26);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod(e, Enums.MAMethod.EMA);
        Object object3 = this.getSettings().getInput(d, (Object)Enums.BarInput.CLOSE);
        if (n2 >= Util.max((int)n3, (int)n4)) {
            Double d3 = null;
            object2 = null;
            d3 = dataSeries.ma(mAMethod, n2, n3, object3);
            object2 = dataSeries.ma(mAMethod, n2, n4, object3);
            d2 = d3 - (Double)object2;
            dataSeries.setDouble(n2, (Object)CompositeSample$Values.MACD, Double.valueOf(d2));
            int n5 = this.getSettings().getInteger("signalPeriod", 9);
            Double d4 = dataSeries.ma(this.getSettings().getMAMethod("signalMethod", Enums.MAMethod.SMA), n2, n5, (Object)CompositeSample$Values.MACD);
            dataSeries.setDouble(n2, (Object)CompositeSample$Values.SIGNAL, d4);
            if (d4 != null) {
                dataSeries.setDouble(n2, (Object)CompositeSample$Values.HIST, Double.valueOf(d2 - d4));
            }
            if (dataSeries.isBarComplete(n2)) {
                Coordinate coordinate = new Coordinate(dataSeries.getStartTime(n2), d4.doubleValue());
                if (this.crossedAbove(dataSeries, n2, (Object)CompositeSample$Values.MACD, (Object)CompositeSample$Values.SIGNAL)) {
                    MarkerInfo markerInfo = this.getSettings().getMarker("upMarker");
                    object = this.get("SIGNAL_MACD_CROSS_ABOVE", new Object[]{d2, d4});
                    if (markerInfo.isEnabled()) {
                        this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, (String)object));
                    }
                    dataContext.signal(n2, (Object)CompositeSample$Signals.CROSS_ABOVE, (String)object, (Object)d4);
                } else if (this.crossedBelow(dataSeries, n2, (Object)CompositeSample$Values.MACD, (Object)CompositeSample$Values.SIGNAL)) {
                    MarkerInfo markerInfo = this.getSettings().getMarker("downMarker");
                    object = this.get("SIGNAL_MACD_CROSS_BELOW", new Object[]{d2, d4});
                    if (markerInfo.isEnabled()) {
                        this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, (String)object));
                    }
                    dataContext.signal(n2, (Object)CompositeSample$Signals.CROSS_BELOW, (String)object, (Object)d4);
                }
            }
        } else {
            bl2 = false;
        }
        int n6 = this.getSettings().getInteger(h);
        object2 = this.getSettings().getInput(i);
        if (n2 < 1) {
            return;
        }
        d2 = dataSeries.getDouble(n2, object2) - dataSeries.getDouble(n2 - 1, object2);
        double d5 = 0.0;
        double d6 = 0.0;
        if (d2 > 0.0) {
            d5 = d2;
        } else {
            d6 = d2;
        }
        dataSeries.setDouble(n2, (Object)CompositeSample$Values.UP, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)CompositeSample$Values.DOWN, Double.valueOf(Math.abs(d6)));
        if (n2 <= n6 + 1) {
            return;
        }
        object = this.getSettings().getMAMethod(j);
        double d7 = dataSeries.ma(object, n2, n6, (Object)CompositeSample$Values.UP);
        double d8 = dataSeries.ma(object, n2, n6, (Object)CompositeSample$Values.DOWN);
        double d9 = d7 / d8;
        double d10 = 100.0 - 100.0 / (1.0 + d9);
        dataSeries.setDouble(n2, (Object)CompositeSample$Values.RSI, Double.valueOf(d10));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        if (this.crossedAbove(dataSeries, n2, (Object)CompositeSample$Values.RSI, guideInfo.getValue())) {
            dataSeries.setBoolean(n2, (Object)CompositeSample$Signals.RSI_TOP, Boolean.valueOf(true));
            dataContext.signal(n2, (Object)CompositeSample$Signals.RSI_TOP, this.get("SIGNAL_RSI_TOP", new Object[]{guideInfo.getValue(), this.round(d10)}), (Object)this.round(d10));
        } else if (this.crossedBelow(dataSeries, n2, (Object)CompositeSample$Values.RSI, guideInfo2.getValue())) {
            dataSeries.setBoolean(n2, (Object)CompositeSample$Signals.RSI_BOTTOM, Boolean.valueOf(true));
            dataContext.signal(n2, (Object)CompositeSample$Signals.RSI_BOTTOM, this.get("SIGNAL_RSI_BOTTOM", new Object[]{guideInfo2.getValue(), this.round(d10)}), (Object)this.round(d10));
        }
        dataSeries.setComplete(n2, bl2);
    }
}

