/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.CmoFilt$Signals;
import com.motivewave.platform.study.general.CmoFilt$Values;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_CMOF", rb="com.motivewave.platform.study.nls.strings2", desc="DESC_CMOF", name="NAME_CMO_FILTER", label="LBL_CMOF", menu="MENU_TUSHAR_CHANDE", helpLink="http://www.motivewave.com/studies/cmo_filter.htm", signals=true, overlay=false, studyOverlay=true)
public class CmoFilt
extends Study {
    static final String a = "Filter";
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("FILTER", new Object[0]), 3.0, 0.1, 999.1, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_CMOF", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 100.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, -10.01, 10.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), -70.0, -100.01, 0.0, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup4.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup4);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CmoFilt$Values.CMOF, this.get("CMOF", new Object[0]), new String[]{"input", "period", a}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CmoFilt$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CmoFilt$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)CmoFilt$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)CmoFilt$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)CmoFilt$Values.CMOF, "line");
        runtimeDescriptor.declareIndicator((Object)CmoFilt$Values.CMOF, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{CmoFilt$Values.CMOF});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        this.setMinBars(n2 * 2);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        double d2;
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        double d3 = this.getSettings().getDouble(a);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d4 = dataSeries.getDouble(n2, object, 0.0);
        double d5 = d4 - (d2 = dataSeries.getDouble(n2 - 1, object, 0.0));
        double d6 = Math.abs(d5);
        if (d6 > d3) {
            d5 = 0.0;
            d6 = 0.0;
        }
        dataSeries.setDouble(n2, (Object)CmoFilt$Values.DIFF_V, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)CmoFilt$Values.ABS_V, Double.valueOf(d6));
        if (n2 < n3 * 2) {
            return;
        }
        double d7 = dataSeries.sum(n2, n3, (Object)CmoFilt$Values.DIFF_V);
        double d8 = dataSeries.sum(n2, n3, (Object)CmoFilt$Values.ABS_V);
        double d9 = 100.0 * d7 / d8;
        dataSeries.setDouble(n2, (Object)CmoFilt$Values.CMOF, Double.valueOf(d9));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d10 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d11 = guideInfo2.getValue();
        double d12 = dataSeries.getDouble(n2 - 1, (Object)CmoFilt$Values.CMOF, 0.0);
        boolean bl2 = d9 > d10 && d12 > d9 && d9 > this.a;
        boolean bl3 = d9 < d11 && d12 < d9 && d9 < this.b;
        dataSeries.setBoolean(n2, (Object)CmoFilt$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)CmoFilt$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d9;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d9);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_CMOF", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d9, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)CmoFilt$Signals.SELL, string, (Object)d4);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d9;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d9);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_CMOF", new Object[]{Util.round((double)d4, (int)2), Util.round((double)d9, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)CmoFilt$Signals.BUY, string, (Object)d4);
        }
        dataSeries.setComplete(n2);
    }
}

