/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.CmoAbsAv$Signals;
import com.motivewave.platform.study.general.CmoAbsAv$Values;

@StudyHeader(namespace="com.motivewave", id="ID_CMOABSAV", rb="com.motivewave.platform.study.nls.strings2", name="NAME_CMO_ABS_AV", label="LBL_CMOABSAV", desc="DESC_CMOABSAV", menu="MENU_TUSHAR_CHANDE", helpLink="http://www.motivewave.com/studies/cmo_abs_average.htm", overlay=false, signals=true, studyOverlay=true)
public class CmoAbsAv
extends Study {
    double a = Double.NEGATIVE_INFINITY;
    double b = Double.MAX_VALUE;

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        this.setSettingsDescriptor(settingsDescriptor);
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 5, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 10, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("PERIOD3", new Object[0]), 20, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        settingGroup = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_CMOABSAV", new Object[0]), defaults.getLineColor(), 1.0f, null, true, true, true)});
        settingGroup.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.01, 0.01, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.01, 0.01, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.01, 0.01, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", "period3"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CmoAbsAv$Values.CMO_ABS_AV, this.get("LBL_CMOABSAV", new Object[0]), new String[]{"input", "period", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CmoAbsAv$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)CmoAbsAv$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)CmoAbsAv$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)CmoAbsAv$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declarePath((Object)CmoAbsAv$Values.CMO_ABS_AV, "line");
        runtimeDescriptor.declareIndicator((Object)CmoAbsAv$Values.CMO_ABS_AV, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{CmoAbsAv$Values.CMO_ABS_AV});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(Math.max(Math.max(n2, n3), n4) + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = Math.max(Math.max(n3, n4), n5);
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2 - 1, object, 0.0);
        double d4 = d2 - d3;
        double d5 = Math.abs(d4);
        dataSeries.setDouble(n2, (Object)CmoAbsAv$Values.DIFF, Double.valueOf(d4));
        dataSeries.setDouble(n2, (Object)CmoAbsAv$Values.ABS_DIFF, Double.valueOf(d5));
        if (n2 < n6 + 1) {
            return;
        }
        double d6 = dataSeries.sum(n2, n3, (Object)CmoAbsAv$Values.DIFF);
        double d7 = dataSeries.sum(n2, n3, (Object)CmoAbsAv$Values.ABS_DIFF);
        double d8 = dataSeries.sum(n2, n4, (Object)CmoAbsAv$Values.DIFF);
        double d9 = dataSeries.sum(n2, n4, (Object)CmoAbsAv$Values.ABS_DIFF);
        double d10 = dataSeries.sum(n2, n5, (Object)CmoAbsAv$Values.DIFF);
        double d11 = dataSeries.sum(n2, n5, (Object)CmoAbsAv$Values.ABS_DIFF);
        double d12 = d6 / d7;
        double d13 = d8 / d9;
        double d14 = d10 / d11;
        double d15 = Math.abs(100.0 * (d12 + d13 + d14) / 3.0);
        dataSeries.setDouble(n2, (Object)CmoAbsAv$Values.CMO_ABS_AV, Double.valueOf(d15));
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d16 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d17 = guideInfo2.getValue();
        double d18 = dataSeries.getDouble(n2 - 1, (Object)CmoAbsAv$Values.CMO_ABS_AV, 0.0);
        boolean bl2 = d15 > d16 && d18 > d15 && d15 > this.a;
        boolean bl3 = d15 < d17 && d18 < d15 && d15 < this.b;
        dataSeries.setBoolean(n2, (Object)CmoAbsAv$Signals.SELL, Boolean.valueOf(bl2));
        dataSeries.setBoolean(n2, (Object)CmoAbsAv$Signals.BUY, Boolean.valueOf(bl3));
        if (bl2) {
            this.b = Double.MAX_VALUE;
            this.a = d15;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d15);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_CMOABSAV", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d15, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)CmoAbsAv$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            this.a = Double.NEGATIVE_INFINITY;
            this.b = d15;
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d15);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_CMOABSAV", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d15, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)CmoAbsAv$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

