/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.general;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.general.BarTimeHistogram$Values;

@StudyHeader(namespace="com.motivewave", id="BAR_TIME_HISTOGRAM", rb="com.motivewave.platform.study.nls.strings", name="TITLE_BAR_TIME_HISTOGRAM", label="LBL_BAR_TIME_HISTOGRAM", desc="DESC_BAR_TIME_HISTOGRAM", menu="MENU_GENERAL", overlay=false)
public class BarTimeHistogram
extends Study {
    static final String a = "maPath";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 20, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_SETTINGS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("LBL_BAR_COLOR", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setColorPolicies(Enums.ColorPolicy.values());
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), defaults.getBarColor(), null, false, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor(a, this.get("LBL_MA_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("LBL_MA_IND", new Object[0]), defaults.getLineColor(), null, false, false, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"method", "period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BarTimeHistogram$Values.BAR_TIME, this.get("LBL_BAR_TIME", new Object[0]), new String[0]));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)BarTimeHistogram$Values.MA, this.get("LBL_MA", new Object[0]), new String[]{"method", "period"}));
        runtimeDescriptor.declarePath((Object)BarTimeHistogram$Values.BAR_TIME, "bar");
        runtimeDescriptor.declarePath((Object)BarTimeHistogram$Values.MA, a);
        runtimeDescriptor.declareIndicator((Object)BarTimeHistogram$Values.BAR_TIME, "ind");
        runtimeDescriptor.declareIndicator((Object)BarTimeHistogram$Values.MA, "ind2");
        runtimeDescriptor.setRangeKeys(new Object[]{BarTimeHistogram$Values.BAR_TIME});
        runtimeDescriptor.setFixedBottomValue(Integer.valueOf(0));
        runtimeDescriptor.setBottomInsetPixels(0);
        runtimeDescriptor.setMinTopValue(Integer.valueOf(10));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Enums.MAMethod mAMethod;
        Double d2;
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = (int)((dataSeries.getEndTime(n2) - dataSeries.getStartTime(n2)) / 1000L);
        dataSeries.setInt(n2, (Object)BarTimeHistogram$Values.BAR_TIME, n3);
        int n4 = this.getSettings().getInteger("period", 12);
        if (n2 > n4 && (d2 = dataSeries.ma(mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA), n2, n4, (Object)BarTimeHistogram$Values.BAR_TIME)) != null) {
            dataSeries.setInt(n2, (Object)BarTimeHistogram$Values.MA, d2.intValue());
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

