/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.custom;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.draw.ColorRange;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.custom.SwamiStochastic$Values;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@StudyHeader(namespace="com.motivewave", id="SWAMI_STOCHASTICS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_SWAMI_STOCHASTICS", desc="DESC_SWAMI_STOCHASTICS", menu="MENU_CUSTOM", overlay=false, supportsBarUpdates=false, helpLink="http://www.motivewave.com/studies/swami_stochastics.htm")
public class SwamiStochastic
extends Study {
    private Map a = Collections.synchronizedMap(new HashMap());

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_RANGE", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("minPeriod", this.get("LBL_MIN_PERIOD", new Object[0]), 12, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("maxPeriod", this.get("LBL_MAX_PERIOD", new Object[0]), 48, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"minPeriod", "maxPeriod"});
        runtimeDescriptor.setBottomInsetPixels(0);
        runtimeDescriptor.setTopInsetPixels(0);
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void clearState() {
        super.clearState();
        this.a.clear();
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3;
        int n4 = this.getSettings().getInteger("minPeriod");
        if (n4 > (n3 = this.getSettings().getInteger("maxPeriod").intValue())) {
            int n5 = n3;
            n4 = n3;
            n3 = n5;
        }
        this.getRuntimeDescriptor().setFixedBottomValue(Integer.valueOf(n4));
        this.getRuntimeDescriptor().setFixedTopValue(Integer.valueOf(n3));
        if (n2 + 1 < n4) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        int n6 = n3 - n4;
        long l2 = dataSeries.getStartTime(n2);
        ColorRange colorRange = (ColorRange)this.a.get(l2);
        if (colorRange == null) {
            colorRange = new ColorRange(l2);
            this.a.put(l2, colorRange);
            this.addFigure((Figure)colorRange);
        }
        colorRange.clearRegions();
        double[] dArray = (double[])dataSeries.getValue(n2 - 1, (Object)SwamiStochastic$Values.NUMERATOR);
        double[] dArray2 = (double[])dataSeries.getValue(n2 - 1, (Object)SwamiStochastic$Values.DENOMINATOR);
        double[] dArray3 = (double[])dataSeries.getValue(n2 - 1, (Object)SwamiStochastic$Values.STOCH);
        double[] dArray4 = new double[n6];
        double[] dArray5 = new double[n6];
        double[] dArray6 = new double[n6];
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = i2 + n4;
            Double d2 = dataSeries.highest(n2, n7, (Object)Enums.BarInput.HIGH);
            Double d3 = dataSeries.lowest(n2, n7, (Object)Enums.BarInput.LOW);
            if (d2 == null || d3 == null) break;
            dArray4[i2] = ((double)dataSeries.getClose(n2) - d3 + (dArray == null ? 0.0 : dArray[i2])) / 2.0;
            dArray5[i2] = (d2 - d3 + (dArray2 == null ? 0.0 : dArray2[i2])) / 2.0;
            if (dArray5[i2] != 0.0) {
                dArray6[i2] = 0.2 * (dArray4[i2] / dArray5[i2]) + 0.8 * (dArray3 == null ? 0.0 : dArray3[i2]);
            }
            int n8 = 255;
            int n9 = 255;
            if (dArray6[i2] > 0.5) {
                n8 = (int)(255.0 * (2.0 - 2.0 * dArray6[i2]));
            } else {
                n9 = (int)(510.0 * dArray6[i2]);
            }
            colorRange.addRegion(new Color(n8, n9, 0), (double)n7, (double)(n7 + 1));
        }
        dataSeries.setValue(n2, (Object)SwamiStochastic$Values.NUMERATOR, (Object)dArray4);
        dataSeries.setValue(n2, (Object)SwamiStochastic$Values.DENOMINATOR, (Object)dArray5);
        dataSeries.setValue(n2, (Object)SwamiStochastic$Values.STOCH, (Object)dArray6);
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

