/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.custom;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.custom.PriceCycleOscillator$Values;

@StudyHeader(namespace="com.motivewave", id="ID_PRICE_CYCLE_OSC", rb="com.motivewave.platform.study.nls.strings2", label="LBL_PCYOSC", name="NAME_PRICE_CYCLE_OSCILLATOR", desc="DESC_PCYOSC", menu="MENU_CUSTOM", helpLink="http://www.motivewave.com/studies/price_cycle_oscillator.htm", signals=true, overlay=false, studyOverlay=true)
public class PriceCycleOscillator
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT1", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("INPUT2", new Object[0]), (Object)Enums.BarInput.LOW)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("AVERAGE_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("AVERAGE_PERIOD", new Object[0]), 22, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("ATR_PERIOD", new Object[0]), 22, 1, 999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATH_INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("LBL_PCYOSC", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("IND", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("TOP_GUIDE", new Object[0]), 70.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("BOTTOM_GUIDE", new Object[0]), 30.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("TOP_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("BOTTOM_FILL", new Object[0]), "middleGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "input2", "method", "method2", "period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)PriceCycleOscillator$Values.PCO, this.get("LBL_PCYOSC", new Object[0]), new String[]{"input", "input2", "method", "method2", "period", "period2"}));
        runtimeDescriptor.declarePath((Object)PriceCycleOscillator$Values.PCO, "line");
        runtimeDescriptor.declareIndicator((Object)PriceCycleOscillator$Values.PCO, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{PriceCycleOscillator$Values.PCO});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Object object2 = this.getSettings().getInput("input2", (Object)Enums.BarInput.LOW);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = dataSeries.getDouble(n2, object2, 0.0);
        double d4 = d2 - d3;
        dataSeries.setDouble(n2, (Object)PriceCycleOscillator$Values.CL, Double.valueOf(d4));
        if (n2 < n3) {
            return;
        }
        Double d5 = dataSeries.ma(mAMethod, n2, n3, (Object)PriceCycleOscillator$Values.CL);
        if (d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)PriceCycleOscillator$Values.AVG, d5);
        if (n2 < Math.max(n3, n4)) {
            return;
        }
        double d6 = dataSeries.sma(n2, n4, (Object)Enums.BarInput.TR);
        double d7 = d5 / d6 * 100.0;
        dataSeries.setDouble(n2, (Object)PriceCycleOscillator$Values.PCO, Double.valueOf(d7));
        dataSeries.setComplete(n2);
    }
}

