/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.custom;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.custom.MACDReversing$Signals;
import com.motivewave.platform.study.custom.MACDReversing$Values;

@StudyHeader(namespace="com.motivewave", id="ID_MACDREV", rb="com.motivewave.platform.study.nls.strings2", label="LBL_MACD", name="NAME_REVERSING_MACD", desc="DESC_REVMACD", menu="MENU_OVERLAYS", helpLink="http://www.motivewave.com/studies/reversing_macd.htm", signals=true, overlay=false, studyOverlay=true)
public class MACDReversing
extends Study {
    static final String a = "Ind3";
    static final String b = "MacdPath";
    static final String c = "MacdSig";
    static final String d = "MacdInd";
    static final String e = "SignalInd";
    static final String f = "HistInd";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD1", new Object[0]), 12, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERIOD2", new Object[0]), 26, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SIGNAL_PERIOD", new Object[0]), 9, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("REVERSING_MACD_PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("MACD_EQUALS_ZERO", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("MACD_EQUALS_PREVIOUS_MACD", new Object[0]), defaults.getBlue(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line3", this.get("REVERSING_MACD_SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("REVERSING_MACD_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("MACD_EQUALS_ZERO", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("MACD_EQUALS_PREVIOUS_MACD", new Object[0]), defaults.getBlue(), defaults.getBackgroundColor(), false, true, true)});
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor(a, this.get("REVERSING_MACD_SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup3);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup4 = new SettingGroup(this.get("MACD_PATHS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new PathDescriptor(b, this.get("MACD", new Object[0]), defaults.getLineColor(), 1.5f, null, true, false, true)});
        PathDescriptor pathDescriptor = new PathDescriptor("bar", this.get("BAR_COLOR", new Object[0]), defaults.getBarColor(), 1.0f, null, true, false, true);
        pathDescriptor.setShowAsBars(true);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setColorPolicies(Enums.ColorPolicy.values());
        settingGroup4.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup4.addRow(new SettingDescriptor[]{new PathDescriptor(c, this.get("MACD_SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup4);
        SettingGroup settingGroup5 = new SettingGroup(this.get("MACD_INDICATORS", new Object[0]));
        settingGroup5.addRow(new SettingDescriptor[]{new IndicatorDescriptor(d, this.get("MACD", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new IndicatorDescriptor(f, this.get("MACD_HIST", new Object[0]), defaults.getBarColor(), null, false, true, true)});
        settingGroup5.addRow(new SettingDescriptor[]{new IndicatorDescriptor(e, this.get("MACD_SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup5);
        SettingGroup settingGroup6 = new SettingGroup(this.get("MARKERS", new Object[0]));
        settingGroup6.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup6.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup6);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        this.setRuntimeDescriptor(runtimeDescriptor);
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACDReversing$Values.PMACDEQ, this.get("PMACDEQ", new Object[0]), new String[]{"input", "method", "period", "period2"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACDReversing$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)MACDReversing$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)MACDReversing$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.declareSignal((Object)MACDReversing$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.getPricePlot().setLabelSettings(new String[]{"input", "method", "period", "period2", "period3"});
        runtimeDescriptor.getPricePlot().setLabelPrefix("RMACD");
        runtimeDescriptor.getPricePlot().declarePath((Object)MACDReversing$Values.PMACDEQ, "line");
        runtimeDescriptor.getPricePlot().declarePath((Object)MACDReversing$Values.PMACDLEVEL, "line2");
        runtimeDescriptor.getPricePlot().declarePath((Object)MACDReversing$Values.RMACD_SIGNAL, "line3");
        runtimeDescriptor.getPricePlot().declareIndicator((Object)MACDReversing$Values.PMACDEQ, "ind");
        runtimeDescriptor.getPricePlot().declareIndicator((Object)MACDReversing$Values.PMACDLEVEL, "ind2");
        runtimeDescriptor.getPricePlot().declareIndicator((Object)MACDReversing$Values.RMACD_SIGNAL, a);
        runtimeDescriptor.getPricePlot().setRangeKeys(new Object[]{MACDReversing$Values.PMACDEQ, MACDReversing$Values.PMACDLEVEL, MACDReversing$Values.RMACD_SIGNAL});
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", "period3"});
        runtimeDescriptor.setLabelPrefix("MACD");
        runtimeDescriptor.declarePath((Object)MACDReversing$Values.MACD, b);
        runtimeDescriptor.declarePath((Object)MACDReversing$Values.MACD_SIGNAL, c);
        runtimeDescriptor.declarePath((Object)MACDReversing$Values.HIST, "bar");
        runtimeDescriptor.declareIndicator((Object)MACDReversing$Values.MACD, d);
        runtimeDescriptor.declareIndicator((Object)MACDReversing$Values.MACD_SIGNAL, e);
        runtimeDescriptor.declareIndicator((Object)MACDReversing$Values.HIST, f);
        runtimeDescriptor.setRangeKeys(new Object[]{MACDReversing$Values.MACD, MACDReversing$Values.HIST, MACDReversing$Values.MACD_SIGNAL});
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        this.setMinBars(n2 + n3 + n4);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.EMA);
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = Math.max(n3, n4);
        if (n2 < n6) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        double d2 = dataSeries.getDouble(n2, object, 0.0);
        double d3 = 2.0 / (double)(1 + n3);
        double d4 = 2.0 / (double)(1 + n4);
        Double d5 = dataSeries.ma(mAMethod, n2, n3, object);
        if (d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)MACDReversing$Values.EMA1, d5);
        Double d6 = dataSeries.ma(mAMethod, n2, n4, object);
        if (d6 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)MACDReversing$Values.EMA2, d6);
        double d7 = d5 - d6;
        dataSeries.setDouble(n2, (Object)MACDReversing$Values.MACD, Double.valueOf(d7));
        if (n2 < n6 + n5) {
            return;
        }
        Double d8 = dataSeries.ma(mAMethod, n2, n5, (Object)MACDReversing$Values.MACD);
        if (d8 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)MACDReversing$Values.MACD_SIGNAL, d8);
        if (n2 < n6 * 2 + 1) {
            return;
        }
        double d9 = d7 - d8;
        dataSeries.setDouble(n2, (Object)MACDReversing$Values.HIST, Double.valueOf(d9));
        double d10 = dataSeries.getDouble(n2 - 1, (Object)MACDReversing$Values.EMA1, 0.0);
        double d11 = dataSeries.getDouble(n2 - 1, (Object)MACDReversing$Values.EMA2, 0.0);
        double d12 = dataSeries.getDouble(n2 - 1, (Object)MACDReversing$Values.MACD, 0.0);
        double d13 = 0.0;
        double d14 = (d13 + (1.0 - d4) * d11 - (1.0 - d3) * d10) / (d3 - d4);
        dataSeries.setDouble(n2, (Object)MACDReversing$Values.PMACDLEVEL, Double.valueOf(d14));
        d13 = d12;
        double d15 = (d13 + (1.0 - d4) * d11 - (1.0 - d3) * d10) / (d3 - d4);
        dataSeries.setDouble(n2, (Object)MACDReversing$Values.PMACDEQ, Double.valueOf(d15));
        if (n2 < n6 * 2 + n5 * 2 + 1) {
            return;
        }
        Double d16 = dataSeries.ma(mAMethod, n2, n5, (Object)MACDReversing$Values.PMACDEQ);
        if (d16 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)MACDReversing$Values.RMACD_SIGNAL, d16);
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)MACDReversing$Values.MACD, (Object)MACDReversing$Values.MACD_SIGNAL);
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)MACDReversing$Values.MACD, (Object)MACDReversing$Values.MACD_SIGNAL);
        dataSeries.setBoolean(n2, (Object)MACDReversing$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)MACDReversing$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7);
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_MACD2", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MACDReversing$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d7);
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_MACD2", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d7, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)MACDReversing$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

