/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.custom;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.X11Colors;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.custom.LBRPaintBar$Values;
import java.awt.Color;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@StudyHeader(namespace="com.motivewave", id="ID_LBR_PAINT_BAR", rb="com.motivewave.platform.study.nls.strings2", label="LBL_LBRPB", name="NAME_LBR_PAINT_BARS", desc="DESC_LBRPB", helpLink="http://www.motivewave.com/studies/lbr_paint_bars.htm", signals=false, overlay=true, studyOverlay=true)
public class LBRPaintBar
extends Study {
    static final String a = "Factor";
    static final String b = "Bull";
    static final String c = "Bear";
    static final String d = "PaintBars";
    static final String e = "ShowVolt";
    static final String[] a = new String[]{"And", "Or"};

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("ATR_PERIOD", new Object[0]), 9, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("HIGH_LOW_PERIOD", new Object[0]), 16, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("FACTOR", new Object[0]), 2.5, 0.1, 999.1, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(d, this.get("PAINT_BARS", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(e, this.get("SHOW_VOLATILITY_LINES", new Object[0]), Boolean.valueOf(true))});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("AND_OR", new Object[0]), (Object[])a, (Object)a[0])});
        settingTab.addGroup(settingGroup);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup2 = new SettingGroup(this.get("PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("BAND1", new Object[0]), defaults.getGreen(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("BAND2", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor(b, this.get("BULLISH", new Object[0]), X11Colors.MEDIUM_SPRING_GREEN)});
        settingGroup3.addRow(new SettingDescriptor[]{new ColorDescriptor(c, this.get("BEARISH", new Object[0]), X11Colors.INDIAN_RED)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "method", "period", "period2", a, d, e, "input2"});
        runtimeDescriptor.declarePath((Object)LBRPaintBar$Values.BAND1, "line");
        runtimeDescriptor.declarePath((Object)LBRPaintBar$Values.BAND2, "line2");
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 * 2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3) {
            return;
        }
        int n4 = this.getSettings().getInteger("period2");
        Object object = this.getSettings().getInput("input", (Object)Enums.BarInput.CLOSE);
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        boolean bl2 = this.getSettings().getBoolean(d);
        boolean bl3 = this.getSettings().getBoolean(e);
        String string = (String)this.getSettings().getInput("input2", (Object)a[0]);
        double d2 = this.getSettings().getDouble(a);
        Color color = this.getSettings().getColor(b);
        Color color2 = this.getSettings().getColor(c);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.atr(n2, n3);
        dataSeries.setDouble(n2, (Object)LBRPaintBar$Values.ATR, Double.valueOf(d3));
        if (n2 < n3 * 2) {
            return;
        }
        double d4 = d2 * dataSeries.ma(mAMethod, n2, n3, (Object)LBRPaintBar$Values.ATR);
        if (n2 < n3 * 2 + n4) {
            return;
        }
        double d5 = dataSeries.lowest(n2, n4, (Object)Enums.BarInput.LOW) + d4;
        double d6 = dataSeries.highest(n2, n4, (Object)Enums.BarInput.HIGH) - d4;
        if (bl3) {
            dataSeries.setDouble(n2, (Object)LBRPaintBar$Values.BAND1, Double.valueOf(d5));
            dataSeries.setDouble(n2, (Object)LBRPaintBar$Values.BAND2, Double.valueOf(d6));
        }
        double d7 = dataSeries.getDouble(n2, object, 0.0);
        boolean bl4 = false;
        boolean bl5 = false;
        if (string.equals("And")) {
            bl4 = d7 > d5 && d7 > d6;
            boolean bl6 = bl5 = d7 < d5 && d7 < d6;
        }
        if (string.equals("Or")) {
            bl4 = d7 >= d5 || d7 >= d6;
            boolean bl7 = bl5 = d7 <= d5 || d7 <= d6;
        }
        if (bl4 && bl2) {
            dataSeries.setPriceBarColor(n2, color);
        }
        if (bl5 && bl2) {
            dataSeries.setPriceBarColor(n2, color2);
        }
        dataSeries.setComplete(n2);
    }
}

