/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.custom;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.custom.DrunkardWalk$Values;
import com.motivewave.platform.study.general.n;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="ID_DRUNKARD_WALK", rb="com.motivewave.platform.study.nls.strings2", label="LBL_DWALK", name="NAME_DRUNKARD_WALK", desc="DESC_DWALK", helpLink="http://www.motivewave.com/studies/drunkard_walk.htm", signals=false, overlay=false, studyOverlay=true)
public class DrunkardWalk
extends Study {
    static final String a = "StdDev";
    static final String b = "Ind3";
    static final String c = "UpAbove";
    static final String d = "DnAbove";
    static final String e = "UpBelow";
    static final String f = "DnBelow";
    static final String g = "UpNeutral";
    static final String h = "DnNeutral";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("PERIOD", new Object[0]), 80, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("PERCENTB_PERIOD", new Object[0]), 14, 1, 999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(a, this.get("STD_DEV", new Object[0]), 2.0, 0.1, 999.1, 0.1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("COLORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(g, this.get("UPWALK_NEUTRAL", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(h, this.get("DNWALK_NEUTRAL", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(e, this.get("UPWALK_BELOW_BB", new Object[0]), defaults.getBlue())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(f, this.get("DNWALK_BELOW_BB", new Object[0]), defaults.getYellow())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(c, this.get("UPWALK_ABOVE_BB", new Object[0]), defaults.getPurple())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor(d, this.get("DNWALK_ABOVE_BB", new Object[0]), defaults.getGrey())});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("PERCENTB", new Object[0]), defaults.getBlue(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        settingGroup2 = new SettingGroup(this.get("INDICATOR", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("UP_WALK", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("DOWN_WALK", new Object[0]), defaults.getGreen(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor(b, this.get("PERCENTB", new Object[0]), defaults.getBlue(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup3 = new SettingGroup(this.get("GUIDE", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("middleGuide", this.get("MIDDLE_GUIDE", new Object[0]), 0.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "period2", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DrunkardWalk$Values.UPWALK, this.get("UP_WALK", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DrunkardWalk$Values.DNWALK, this.get("DOWN_WALK", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)DrunkardWalk$Values.PCB, "line");
        runtimeDescriptor.declareBars((Object)DrunkardWalk$Values.UPWALK, null);
        runtimeDescriptor.declareBars((Object)DrunkardWalk$Values.DNWALK, null);
        runtimeDescriptor.declareIndicator((Object)DrunkardWalk$Values.UPWALK, "ind");
        runtimeDescriptor.declareIndicator((Object)DrunkardWalk$Values.DNWALK, "ind2");
        runtimeDescriptor.declareIndicator((Object)DrunkardWalk$Values.PCB, b);
        runtimeDescriptor.setRangeKeys(new Object[]{DrunkardWalk$Values.DNWALK, DrunkardWalk$Values.UPWALK, DrunkardWalk$Values.PCB});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        this.setMinBars(n2 + n3);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        if (n2 <= n3) {
            return;
        }
        double d2 = this.getSettings().getDouble(a);
        Object object = this.getSettings().getInput("input");
        Color color = this.getSettings().getColor(g);
        Color color2 = this.getSettings().getColor(h);
        Color color3 = this.getSettings().getColor(e);
        Color color4 = this.getSettings().getColor(f);
        Color color5 = this.getSettings().getColor(c);
        Color color6 = this.getSettings().getColor(d);
        DataSeries dataSeries = dataContext.getDataSeries();
        double d3 = dataSeries.getDouble(n2, (Object)Enums.BarInput.LOW, 0.0);
        double d4 = dataSeries.getDouble(n2, (Object)Enums.BarInput.HIGH, 0.0);
        double[] dArray = n.d(dataSeries, n2, n3, Enums.BarInput.LOW);
        double[] dArray2 = n.c(dataSeries, n2, n3, Enums.BarInput.HIGH);
        double d5 = dArray[0];
        double d6 = dArray2[0];
        int n5 = (int)dArray2[1];
        int n6 = (int)dArray[1];
        int n7 = n2 - n5;
        int n8 = n2 - n6;
        double d7 = dataSeries.atr(n2, n8);
        double d8 = dataSeries.atr(n2, n7);
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (n7 > 0 && n8 > 0) {
            d9 = 1.0;
            if (d7 > 0.0) {
                d9 = d7;
            }
            d10 = (d4 - d5) / (Math.sqrt(n8) * d9);
            d9 = 1.0;
            if (d8 > 0.0) {
                d9 = d8;
            }
            d11 = (d6 - d3) / (Math.sqrt(n7) * d9);
        }
        double d12 = n.a(dataSeries, n4, n2, d2, object);
        dataSeries.setDouble(n2, (Object)DrunkardWalk$Values.UPWALK, Double.valueOf(d10));
        dataSeries.setDouble(n2, (Object)DrunkardWalk$Values.DNWALK, Double.valueOf(d11));
        dataSeries.setDouble(n2, (Object)DrunkardWalk$Values.PCB, Double.valueOf(d12));
        if (n2 <= n3 + n4) {
            return;
        }
        double[] dArray3 = n.a(dataSeries, n2, n4, d2, d2, (Object)DrunkardWalk$Values.UPWALK);
        double[] dArray4 = n.a(dataSeries, n2, n4, d2, d2, (Object)DrunkardWalk$Values.DNWALK);
        dataSeries.setBarColor(n2, (Object)DrunkardWalk$Values.UPWALK, color);
        dataSeries.setBarColor(n2, (Object)DrunkardWalk$Values.DNWALK, color2);
        if (d10 <= dArray3[1]) {
            dataSeries.setBarColor(n2, (Object)DrunkardWalk$Values.UPWALK, color3);
        }
        if (d11 <= dArray4[1]) {
            dataSeries.setBarColor(n2, (Object)DrunkardWalk$Values.DNWALK, color4);
        }
        if (d10 >= dArray3[0]) {
            dataSeries.setBarColor(n2, (Object)DrunkardWalk$Values.UPWALK, color5);
        }
        if (d11 >= dArray3[0]) {
            dataSeries.setBarColor(n2, (Object)DrunkardWalk$Values.DNWALK, color6);
        }
        dataSeries.setComplete(n2);
    }
}

