/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.custom;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.custom.DeltaMA$Values;

@StudyHeader(namespace="com.motivewave", id="DELTA_MA", rb="com.motivewave.platform.study.nls.strings", name="TITLE_DELTA_MA", menu="MENU_CUSTOM", desc="DESC_DELTA_MA", overlay=false, helpLink="http://www.motivewave.com/studies/delta_ma.htm")
public class DeltaMA
extends Study {
    static final String a = "deltaRange";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT1", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input2", this.get("LBL_INPUT2", new Object[0]), (Object)Enums.BarInput.OPEN)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 10, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_DELTA_RANGE", new Object[0]), 5, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("upColor", this.get("LBL_UP_COLOR", new Object[0]), defaults.getGreen())});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("downColor", this.get("LBL_DOWN_COLOR", new Object[0]), defaults.getRed())});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "input2", "method", "period", a});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)DeltaMA$Values.MA, this.get("LBL_DELTA_MA", new Object[0]), new String[]{"input", "input2", "method", "period", a}));
        runtimeDescriptor.declareBars((Object)DeltaMA$Values.MA);
        runtimeDescriptor.declareIndicator((Object)DeltaMA$Values.MA, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{DeltaMA$Values.MA});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger(a);
        if (n2 < n3) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2, this.getSettings().getInput("input"));
        Double d3 = dataSeries.getDouble(n2 - n3, this.getSettings().getInput("input2"));
        if (d2 == null || d3 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DeltaMA$Values.DELTA, Double.valueOf(d2 - d3));
        int n4 = this.getSettings().getInteger("period");
        if (n2 < n4 + n3) {
            return;
        }
        Double d4 = dataSeries.ma(this.getSettings().getMAMethod("method"), n2, n4, (Object)DeltaMA$Values.DELTA);
        if (d4 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)DeltaMA$Values.MA, d4);
        if (d4 > 0.0) {
            dataSeries.setBarColor(n2, (Object)DeltaMA$Values.MA, this.getSettings().getColor("upColor"));
        } else {
            dataSeries.setBarColor(n2, (Object)DeltaMA$Values.MA, this.getSettings().getColor("downColor"));
        }
        dataSeries.setComplete(n2);
    }
}

