/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.chande;

import com.motivewave.platform.sdk.common.Coordinate;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.MarkerInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.InputDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.MarkerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.draw.Figure;
import com.motivewave.platform.sdk.draw.Marker;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.chande.StochasticRSI$Signals;
import com.motivewave.platform.study.chande.StochasticRSI$Values;

@StudyHeader(namespace="com.motivewave", id="STO_RSI", rb="com.motivewave.platform.study.nls.strings", name="NAME_STOCHASTIC_RSI", tabName="TAB_STO_RSI", desc="DESC_STOCH_RSI", menu="MENU_TUSCHARD_CHANDE", overlay=false, studyOverlay=true, signals=true, helpLink="http://www.motivewave.com/studies/stochastic_rsi.htm")
public class StochasticRSI
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new InputDescriptor("input", this.get("LBL_INPUT", new Object[0]), (Object)Enums.BarInput.CLOSE)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("RSI_PERIOD", new Object[0]), 14, 1, 9999, 1), new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("FAST_K_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period3", this.get("SLOW_K_PERIOD", new Object[0]), 5, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period4", this.get("SIGNAL_PERIOD", new Object[0]), 3, 1, 9999, 1), new MAMethodDescriptor("method2", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMA)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_PATHS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line", this.get("STOCHASTIC_K", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new PathDescriptor("line2", this.get("SIGNAL", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true)});
        settingTab.addGroup(settingGroup2);
        settingGroup2 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("STOCHASTIC_K", new Object[0]), defaults.getLineColor(), null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind2", this.get("SIGNAL", new Object[0]), defaults.getRed(), null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_DISPLAY", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 80.0, 0.0, 999.1, 0.1, true);
        guideDescriptor.setLineColor(defaults.getRed());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 0.0, 999.1, 0.1, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        GuideDescriptor guideDescriptor3 = new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 20.0, 0.0, 999.1, 0.1, true);
        guideDescriptor3.setLineColor(defaults.getGreen());
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor3});
        settingTab.addGroup(settingGroup3);
        settingGroup2 = new SettingGroup(this.get("LBL_SHADING", new Object[0]));
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_MARKERS", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("upMarker", this.get("LBL_UP_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getGreen(), defaults.getLineColor(), true, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new MarkerDescriptor("downMarker", this.get("LBL_DOWN_MARKER", new Object[0]), Enums.MarkerType.TRIANGLE, Enums.Size.VERY_SMALL, defaults.getRed(), defaults.getLineColor(), true, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"input", "period", "method", "period2", "period3", "period4", "method2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticRSI$Values.SLOWK, this.get("STOCHASTIC_K", new Object[0]), new String[]{"input", "period", "method", "period2", "period3"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticRSI$Values.SIG, this.get("SIGNAL", new Object[0]), new String[]{"method2", "period4"}));
        runtimeDescriptor.declarePath((Object)StochasticRSI$Values.SLOWK, "line");
        runtimeDescriptor.declarePath((Object)StochasticRSI$Values.SIG, "line2");
        runtimeDescriptor.declareIndicator((Object)StochasticRSI$Values.SLOWK, "ind");
        runtimeDescriptor.declareIndicator((Object)StochasticRSI$Values.SIG, "ind2");
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticRSI$Signals.SELL, Enums.ValueType.BOOLEAN, this.get("SELL", new Object[0]), null));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticRSI$Signals.BUY, Enums.ValueType.BOOLEAN, this.get("BUY", new Object[0]), null));
        runtimeDescriptor.declareSignal((Object)StochasticRSI$Signals.SELL, this.get("SELL", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StochasticRSI$Signals.BUY, this.get("BUY", new Object[0]));
        runtimeDescriptor.setRangeKeys(new Object[]{StochasticRSI$Values.SLOWK});
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    public void onLoad(Defaults defaults) {
        int n2 = this.getSettings().getInteger("period");
        int n3 = this.getSettings().getInteger("period2");
        int n4 = this.getSettings().getInteger("period3");
        int n5 = this.getSettings().getInteger("period4");
        this.setMinBars(n2 + n3 + n4 + n5 + 1);
    }

    protected void calculate(int n2, DataContext dataContext) {
        String string;
        MarkerInfo markerInfo;
        Coordinate coordinate;
        if (n2 < 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        int n5 = this.getSettings().getInteger("period3");
        int n6 = this.getSettings().getInteger("period4");
        Object object = this.getSettings().getInput("input");
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method", Enums.MAMethod.SMMA);
        Enums.MAMethod mAMethod2 = this.getSettings().getMAMethod("method2", Enums.MAMethod.SMA);
        double d2 = dataSeries.getDouble(n2, object);
        double d3 = dataSeries.getDouble(n2 - 1, object);
        double d4 = d2 - d3;
        double d5 = 0.0;
        double d6 = 0.0;
        if (d4 > 0.0) {
            d5 = d4;
        } else {
            d6 = d4;
        }
        d6 = Math.abs(d6);
        dataSeries.setDouble(n2, (Object)StochasticRSI$Values.UP, Double.valueOf(d5));
        dataSeries.setDouble(n2, (Object)StochasticRSI$Values.DOWN, Double.valueOf(d6));
        if (n2 < n3 + 1) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n3, (Object)StochasticRSI$Values.UP);
        if (d7 == null) {
            return;
        }
        Double d8 = dataSeries.ma(mAMethod, n2, n3, (Object)StochasticRSI$Values.DOWN);
        if (d8 == null) {
            return;
        }
        double d9 = d7 + d8;
        double d10 = d7 / d9 * 100.0;
        dataSeries.setDouble(n2, (Object)StochasticRSI$Values.RSI, Double.valueOf(d10));
        if (n2 < n3 + n4 + 1) {
            return;
        }
        Double d11 = dataSeries.highest(n2, n4, (Object)StochasticRSI$Values.RSI);
        Double d12 = dataSeries.lowest(n2, n4, (Object)StochasticRSI$Values.RSI);
        if (d11 == null || d12 == null) {
            return;
        }
        double d13 = 0.0;
        d13 = d11 == d12 ? 100.0 : (d10 - d12) / (d11 - d12) * 100.0;
        dataSeries.setDouble(n2, (Object)StochasticRSI$Values.FASTK, Double.valueOf(d13));
        if (n2 < n3 + n4 + n5 + 1) {
            return;
        }
        Double d14 = dataSeries.ma(mAMethod2, n2, n5, (Object)StochasticRSI$Values.FASTK);
        if (d14 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)StochasticRSI$Values.SLOWK, d14);
        if (n2 < n3 + n4 + n5 + n6 + 1) {
            return;
        }
        Double d15 = dataSeries.ma(mAMethod2, n2, n6, (Object)StochasticRSI$Values.SLOWK);
        if (d15 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)StochasticRSI$Values.SIG, d15);
        GuideInfo guideInfo = this.getSettings().getGuide("topGuide");
        double d16 = guideInfo.getValue();
        GuideInfo guideInfo2 = this.getSettings().getGuide("bottomGuide");
        double d17 = guideInfo2.getValue();
        boolean bl2 = this.crossedBelow(dataSeries, n2, (Object)StochasticRSI$Values.SLOWK, (Object)StochasticRSI$Values.SIG) && d14 > d16;
        boolean bl3 = this.crossedAbove(dataSeries, n2, (Object)StochasticRSI$Values.SLOWK, (Object)StochasticRSI$Values.SIG) && d14 < d17;
        dataSeries.setBoolean(n2, (Object)StochasticRSI$Signals.BUY, Boolean.valueOf(bl3));
        dataSeries.setBoolean(n2, (Object)StochasticRSI$Signals.SELL, Boolean.valueOf(bl2));
        if (bl2) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d14.doubleValue());
            markerInfo = this.getSettings().getMarker("downMarker");
            string = this.get("SELL_PRICE_K", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d14, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.TOP, markerInfo, string));
            }
            dataContext.signal(n2, (Object)StochasticRSI$Signals.SELL, string, (Object)d2);
        }
        if (bl3) {
            coordinate = new Coordinate(dataSeries.getStartTime(n2), d14.doubleValue());
            markerInfo = this.getSettings().getMarker("upMarker");
            string = this.get("BUY_PRICE_K", new Object[]{Util.round((double)d2, (int)2), Util.round((double)d14, (int)3)});
            if (markerInfo.isEnabled()) {
                this.addFigure((Figure)new Marker(coordinate, Enums.Position.BOTTOM, markerInfo, string));
            }
            dataContext.signal(n2, (Object)StochasticRSI$Signals.BUY, string, (Object)d2);
        }
        dataSeries.setComplete(n2);
    }
}

