/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.chande;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.GuideInfo;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.chande.IMI$Signals;
import com.motivewave.platform.study.chande.IMI$Values;

@StudyHeader(namespace="com.motivewave", id="IMI", rb="com.motivewave.platform.study.nls.strings", name="TITLE_IMI", label="LBL_IMI", desc="DESC_IMI", menu="MENU_TUSCHARD_CHANDE", overlay=false, studyOverlay=true, signals=true)
public class IMI
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.SMMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("signalPeriod", this.get("LBL_SIGNAL_PERIOD", new Object[0]), 6, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_IMI", new Object[0]), defaults.getLineColor(), 1.0f, null);
        pathDescriptor.setSupportsShowAsBars(true);
        pathDescriptor.setBarCenter(50);
        pathDescriptor.setColorPolicies(Enums.ColorPolicy.values());
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        PathDescriptor pathDescriptor2 = new PathDescriptor("signalLine", this.get("LBL_SIGNAL_LINE", new Object[0]), defaults.getRed(), 1.0f, null, true, false, true);
        pathDescriptor2.setSupportsShowAsBars(true);
        pathDescriptor2.setBarCenter(50);
        pathDescriptor2.setColorPolicies(Enums.ColorPolicy.values());
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor2});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("signalInd", this.get("LBL_SIGNAL_IND", new Object[0]), defaults.getRed(), null, false, false, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 70.0, 1.0, 100.0, 1.0, true)});
        GuideDescriptor guideDescriptor = new GuideDescriptor("topGuide2", this.get("LBL_TOP_GUIDE2", new Object[0]), 60.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setEnabled(false);
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        GuideDescriptor guideDescriptor2 = new GuideDescriptor("middleGuide", this.get("LBL_MIDDLE_GUIDE", new Object[0]), 50.0, 1.0, 100.0, 1.0, true);
        guideDescriptor2.setDash(new float[]{3.0f, 3.0f});
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor2});
        guideDescriptor = new GuideDescriptor("bottomGuide2", this.get("LBL_BOTTOM_GUIDE2", new Object[0]), 40.0, 1.0, 100.0, 1.0, true);
        guideDescriptor.setEnabled(false);
        settingGroup3.addRow(new SettingDescriptor[]{guideDescriptor});
        settingGroup3.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), 30.0, 1.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup3);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "signalPeriod", "method"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)IMI$Values.IMI, this.get("LBL_IMI", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)IMI$Values.SIGNAL, this.get("LBL_IMI_SIGNAL", new Object[0]), new String[]{"period", "signalPeriod", "method"}));
        runtimeDescriptor.declarePath((Object)IMI$Values.IMI, "line");
        runtimeDescriptor.declareIndicator((Object)IMI$Values.IMI, "ind");
        runtimeDescriptor.declarePath((Object)IMI$Values.SIGNAL, "signalLine");
        runtimeDescriptor.declareIndicator((Object)IMI$Values.SIGNAL, "signalInd");
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(15));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(85));
        runtimeDescriptor.setRangeKeys(new Object[]{IMI$Values.IMI});
        runtimeDescriptor.declareSignal((Object)IMI$Signals.IMI_TOP, this.get("IMI_TOP", new Object[0]));
        runtimeDescriptor.declareSignal((Object)IMI$Signals.IMI_BOTTOM, this.get("IMI_BOTTOM", new Object[0]));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        Object object;
        Double d2;
        int n3 = this.getSettings().getInteger("period");
        DataSeries dataSeries = dataContext.getDataSeries();
        float f2 = dataSeries.getOpen(n2);
        float f3 = dataSeries.getClose(n2);
        double d3 = 0.0;
        double d4 = 0.0;
        if (f3 > f2) {
            d3 = f3 - f2;
            d2 = dataSeries.getDouble(n2 - 1, (Object)IMI$Values.GAIN);
            if (d2 != null) {
                d3 += d2.doubleValue();
            }
        } else if (f3 < f2) {
            d4 = f2 - f3;
            d2 = dataSeries.getDouble(n2 - 1, (Object)IMI$Values.LOSS);
            if (d2 != null) {
                d4 += d2.doubleValue();
            }
        }
        dataSeries.setDouble(n2, (Object)IMI$Values.GAIN, Double.valueOf(d3));
        dataSeries.setDouble(n2, (Object)IMI$Values.LOSS, Double.valueOf(d4));
        double d5 = dataSeries.sum(n2, n3, (Object)IMI$Values.GAIN);
        double d6 = dataSeries.sum(n2, n3, (Object)IMI$Values.LOSS);
        double d7 = 100.0 * (d5 / (d5 + d6));
        dataSeries.setDouble(n2, (Object)IMI$Values.IMI, Double.valueOf(d7));
        int n4 = this.getSettings().getInteger("signalPeriod", 6);
        if (n2 >= n4) {
            object = dataSeries.ma(this.getSettings().getMAMethod("method", Enums.MAMethod.EMA), n2, n4, (Object)IMI$Values.IMI);
            dataSeries.setDouble(n2, (Object)IMI$Values.SIGNAL, (Double)object);
        }
        object = this.getSettings().getGuide("topGuide");
        GuideInfo guideInfo = this.getSettings().getGuide("bottomGuide");
        if (this.crossedAbove(dataSeries, n2, (Object)IMI$Values.IMI, object.getValue())) {
            dataSeries.setBoolean(n2, (Object)IMI$Signals.IMI_TOP, Boolean.valueOf(true));
            dataContext.signal(n2, (Object)IMI$Signals.IMI_TOP, this.get("SIGNAL_IMI_TOP", new Object[]{object.getValue(), this.round(d7)}), (Object)this.round(d7));
        } else if (this.crossedBelow(dataSeries, n2, (Object)IMI$Values.IMI, guideInfo.getValue())) {
            dataSeries.setBoolean(n2, (Object)IMI$Signals.IMI_BOTTOM, Boolean.valueOf(true));
            dataContext.signal(n2, (Object)IMI$Signals.IMI_BOTTOM, this.get("SIGNAL_IMI_BOTTOM", new Object[]{guideInfo.getValue(), this.round(d7)}), (Object)this.round(d7));
        }
        dataSeries.setComplete(n2, dataSeries.isBarComplete(n2));
    }
}

