/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.chande;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.desc.GuideDescriptor;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.chande.AroonOsc$Values;

@StudyHeader(namespace="com.motivewave", id="AROON_OSC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_AROON_OSC", label="LBL_AROON_OSC", desc="DESC_AROON_OSC", menu="MENU_TUSCHARD_CHANDE", overlay=false, studyOverlay=true, helpLink="http://www.motivewave.com/studies/aroon_oscillator.htm")
public class AroonOsc
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 25, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_LINES", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "topGuide", "line", Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "bottomGuide", "line", Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingTab.addGroup(settingGroup2);
        settingTab = new SettingTab(this.get("TAB_ADVANCED", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        SettingGroup settingGroup3 = new SettingGroup(this.get("LBL_INDICATORS", new Object[0]));
        settingGroup3.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup3);
        SettingGroup settingGroup4 = new SettingGroup(this.get("LBL_GUIDES", new Object[0]));
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("topGuide", this.get("LBL_TOP_GUIDE", new Object[0]), 50.0, -100.0, 100.0, 1.0, true)});
        settingGroup4.addRow(new SettingDescriptor[]{new GuideDescriptor("bottomGuide", this.get("LBL_BOTTOM_GUIDE", new Object[0]), -50.0, -100.0, 100.0, 1.0, true)});
        settingTab.addGroup(settingGroup4);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)AroonOsc$Values.VAL, this.get("LBL_AROON_OSC", new Object[0]), new String[]{"period"}));
        runtimeDescriptor.declarePath((Object)AroonOsc$Values.VAL, "line");
        runtimeDescriptor.declareIndicator((Object)AroonOsc$Values.VAL, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{AroonOsc$Values.VAL});
        runtimeDescriptor.setMaxBottomValue(Integer.valueOf(-90));
        runtimeDescriptor.setMinTopValue(Integer.valueOf(90));
        runtimeDescriptor.setMinTick(Double.valueOf(0.1));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger("period");
        if (n2 < n3 - 1) {
            return;
        }
        DataSeries dataSeries = dataContext.getDataSeries();
        int n4 = 0;
        int n5 = 0;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        int n6 = n3;
        for (int i2 = n2 - n3 + 1; i2 <= n2; ++i2) {
            double d4 = dataSeries.getHigh(i2);
            double d5 = dataSeries.getLow(i2);
            if (d4 >= d2) {
                d2 = d4;
                n4 = n6;
            }
            if (d5 <= d3) {
                d3 = d5;
                n5 = n6;
            }
            --n6;
        }
        double d6 = ((double)n3 - (double)(--n4)) / (double)n3 * 100.0;
        double d7 = ((double)n3 - (double)(--n5)) / (double)n3 * 100.0;
        dataSeries.setDouble(n2, (Object)AroonOsc$Values.VAL, Double.valueOf(d6 - d7));
        dataSeries.setComplete(n2);
    }
}

