/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.chaikin;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.LineInfo;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.IndicatorDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.PathDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ShadeDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.chaikin.ChaikinOscillator$Values;

@StudyHeader(namespace="com.motivewave", id="CKN_OSC", rb="com.motivewave.platform.study.nls.strings", name="TITLE_CKN_OSC", label="LBL_CKN_OSC", tabName="TAB_CKN_OSC", desc="DESC_CKN_OSC", menu="MENU_MARC_CHAIKIN", overlay=false, requiresVolume=true, studyOverlay=true, helpLink="http://www.motivewave.com/studies/chaikin_oscillator.htm")
public class ChaikinOscillator
extends Study {
    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period", this.get("LBL_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor("period2", this.get("LBL_PERIOD2", new Object[0]), 10, 1, 9999, 1)});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        PathDescriptor pathDescriptor = new PathDescriptor("line", this.get("LBL_LINE", new Object[0]), defaults.getLineColor(), 1.0f, null, true, false, false);
        pathDescriptor.setSupportsShowAsBars(true);
        settingGroup2.addRow(new SettingDescriptor[]{pathDescriptor});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("topFill", this.get("LBL_TOP_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.ABOVE, defaults.getTopFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ShadeDescriptor("bottomFill", this.get("LBL_BOTTOM_FILL", new Object[0]), "line", 0.0, Enums.ShadeType.BELOW, defaults.getBottomFillColor(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new IndicatorDescriptor("ind", this.get("LBL_INDICATOR", new Object[0]), null, null, false, true, true)});
        settingTab.addGroup(settingGroup2);
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{"period", "period2"});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)ChaikinOscillator$Values.VAL, this.get("TAB_CKN_OSC", new Object[0]), new String[]{"period", "period2"}));
        runtimeDescriptor.declarePath((Object)ChaikinOscillator$Values.VAL, "line");
        runtimeDescriptor.declareIndicator((Object)ChaikinOscillator$Values.VAL, "ind");
        runtimeDescriptor.setRangeKeys(new Object[]{ChaikinOscillator$Values.VAL});
        runtimeDescriptor.addHorizontalLine(new LineInfo(0.0, null, 1.0f, new float[]{3.0f, 3.0f}));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        if (n2 < 1) {
            return;
        }
        int n3 = this.getSettings().getInteger("period");
        int n4 = this.getSettings().getInteger("period2");
        DataSeries dataSeries = dataContext.getDataSeries();
        Double d2 = dataSeries.getDouble(n2 - 1, (Object)ChaikinOscillator$Values.ADL);
        if (d2 == null) {
            d2 = 0.0;
        }
        double d3 = d2 + (double)((float)dataSeries.getVolume(n2) * dataSeries.mfm(n2));
        dataSeries.setDouble(n2, (Object)ChaikinOscillator$Values.ADL, Double.valueOf(d3));
        if (n2 < Util.maxInt((int[])new int[]{n3, n4}) - 1) {
            return;
        }
        Double d4 = dataSeries.ema(n2, n3, (Object)ChaikinOscillator$Values.ADL);
        Double d5 = dataSeries.ema(n2, n4, (Object)ChaikinOscillator$Values.ADL);
        if (d4 == null || d5 == null) {
            return;
        }
        dataSeries.setDouble(n2, (Object)ChaikinOscillator$Values.VAL, Double.valueOf(d4 - d5));
        dataSeries.setComplete(n2);
    }
}

