/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.study.bar_pattern;

import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.Defaults;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Util;
import com.motivewave.platform.sdk.common.desc.BooleanDescriptor;
import com.motivewave.platform.sdk.common.desc.ColorDescriptor;
import com.motivewave.platform.sdk.common.desc.DoubleDescriptor;
import com.motivewave.platform.sdk.common.desc.IntegerDescriptor;
import com.motivewave.platform.sdk.common.desc.MAMethodDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingDescriptor;
import com.motivewave.platform.sdk.common.desc.SettingGroup;
import com.motivewave.platform.sdk.common.desc.SettingTab;
import com.motivewave.platform.sdk.common.desc.SettingsDescriptor;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.RuntimeDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.sdk.study.StudyHeader;
import com.motivewave.platform.study.bar_pattern.StochasticBarPattern$Signals;
import com.motivewave.platform.study.bar_pattern.StochasticBarPattern$Values;
import java.awt.Color;

@StudyHeader(namespace="com.motivewave", id="STO_BARS", rb="com.motivewave.platform.study.nls.strings", name="TITLE_STO_BARS", desc="DESC_STO_BARS", menu="MENU_BAR_PATTERNS", overlay=true, signals=true, helpLink="http://www.motivewave.com/studies/stochastic_bars.htm")
public class StochasticBarPattern
extends Study {
    static final String a = "kPeriod";
    static final String b = "kFullPeriod";
    static final String c = "dFullPeriod";
    static final String d = "STOTop";
    static final String e = "STOBottom";
    static final String f = "useDPeriod";

    public void initialize(Defaults defaults) {
        SettingsDescriptor settingsDescriptor = new SettingsDescriptor();
        SettingTab settingTab = new SettingTab(this.get("TAB_GENERAL", new Object[0]));
        settingsDescriptor.addTab(settingTab);
        this.setSettingsDescriptor(settingsDescriptor);
        SettingGroup settingGroup = new SettingGroup(this.get("LBL_INPUTS", new Object[0]));
        settingGroup.addRow(new SettingDescriptor[]{new MAMethodDescriptor("method", this.get("LBL_METHOD", new Object[0]), Enums.MAMethod.EMA)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(a, this.get("LBL_K_PERIOD", new Object[0]), 14, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(b, this.get("LBL_K_FULL_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new IntegerDescriptor(c, this.get("LBL_D_FULL_PERIOD", new Object[0]), 3, 1, 9999, 1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(d, this.get("LBL_STO_TOP", new Object[0]), 80.0, 1.0, 99.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new DoubleDescriptor(e, this.get("LBL_STO_BOTTOM", new Object[0]), 20.0, 1.0, 99.0, 0.1)});
        settingGroup.addRow(new SettingDescriptor[]{new BooleanDescriptor(f, this.get("LBL_USE_D_PERIOD", new Object[0]), Boolean.valueOf(false))});
        settingTab.addGroup(settingGroup);
        SettingGroup settingGroup2 = new SettingGroup(this.get("LBL_COLORS", new Object[0]));
        settingTab.addGroup(settingGroup2);
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("topColor", this.get("LBL_TOP_COLOR", new Object[0]), defaults.getGreen(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("neutralColor", this.get("LBL_NEUTRAL_COLOR", new Object[0]), defaults.getBlue(), true, true)});
        settingGroup2.addRow(new SettingDescriptor[]{new ColorDescriptor("bottomColor", this.get("LBL_BOTTOM_COLOR", new Object[0]), defaults.getRed(), true, true)});
        RuntimeDescriptor runtimeDescriptor = new RuntimeDescriptor();
        runtimeDescriptor.setLabelSettings(new String[]{a, b, c});
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticBarPattern$Values.P_K, this.get("LBL_K_FULL", new Object[0]), new String[]{a, b}));
        runtimeDescriptor.exportValue(new ValueDescriptor((Object)StochasticBarPattern$Values.P_D, this.get("LBL_D_FULL", new Object[0]), new String[]{a, b, c}));
        runtimeDescriptor.declareSignal((Object)StochasticBarPattern$Signals.TOP_BAR, this.get("LBL_STO_TOP_BAR", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StochasticBarPattern$Signals.BOTTOM_BAR, this.get("LBL_STO_BOTTOM_BAR", new Object[0]));
        runtimeDescriptor.declareSignal((Object)StochasticBarPattern$Signals.NEUTRAL_BAR, this.get("LBL_STO_NEUTRAL_BAR", new Object[0]));
        this.setRuntimeDescriptor(runtimeDescriptor);
    }

    protected void calculate(int n2, DataContext dataContext) {
        int n3 = this.getSettings().getInteger(a);
        int n4 = this.getSettings().getInteger(b);
        int n5 = this.getSettings().getInteger(c);
        if (n2 < n3) {
            return;
        }
        Enums.MAMethod mAMethod = this.getSettings().getMAMethod("method");
        DataSeries dataSeries = dataContext.getDataSeries();
        boolean bl2 = dataSeries.isBarComplete(n2);
        double d2 = dataSeries.highest(n2, n3, (Object)Enums.BarInput.HIGH);
        double d3 = dataSeries.lowest(n2, n3, (Object)Enums.BarInput.LOW);
        double d4 = d2 - d3;
        double d5 = 0.0;
        if (d4 > 0.0) {
            d5 = 100.0 * (((double)dataSeries.getClose(n2) - d3) / d4);
        }
        if (d5 > 100.0) {
            this.error("StochasticBarPattern::calculateBaseValues() K > 100: " + d5);
            d5 = 100.0;
        }
        dataSeries.setDouble(n2, (Object)StochasticBarPattern$Values.K, Double.valueOf(d5));
        if (n2 < n3 + n4) {
            return;
        }
        Double d6 = dataSeries.ma(mAMethod, n2, n4, (Object)StochasticBarPattern$Values.K);
        dataSeries.setDouble(n2, (Object)StochasticBarPattern$Values.P_K, d6);
        if (d6 == null) {
            return;
        }
        if (n2 < n3 + n4 + n5) {
            return;
        }
        Double d7 = dataSeries.ma(mAMethod, n2, n5, (Object)StochasticBarPattern$Values.P_K);
        dataSeries.setDouble(n2, (Object)StochasticBarPattern$Values.P_D, d7);
        if (d7 == null) {
            return;
        }
        double d8 = this.getSettings().getDouble(d);
        double d9 = this.getSettings().getDouble(e);
        Color color = this.getSettings().getColor("topColor");
        Color color2 = this.getSettings().getColor("bottomColor");
        Color color3 = this.getSettings().getColor("neutralColor");
        Instrument instrument = dataContext.getInstrument();
        Color color4 = dataSeries.getPriceBarColor(n2 - 1);
        double d10 = d6;
        if (this.getSettings().getBoolean(f).booleanValue()) {
            d10 = d7;
        }
        String string = "" + Util.round((double)d10, (double)0.01);
        String string2 = instrument.format(dataSeries.getClose(n2));
        if (d10 >= d8) {
            dataSeries.setPriceBarColor(n2, color);
            if (bl2 && !Util.compare((Object)color4, (Object)color)) {
                dataContext.signal(n2, (Object)StochasticBarPattern$Signals.TOP_BAR, this.get("SIGNAL_STO_TOP_BAR", new Object[]{string, string2}), (Object)string);
            }
        } else if (d10 <= d9) {
            dataSeries.setPriceBarColor(n2, color2);
            if (bl2 && !Util.compare((Object)color4, (Object)color2)) {
                dataContext.signal(n2, (Object)StochasticBarPattern$Signals.BOTTOM_BAR, this.get("SIGNAL_STO_BOTTOM_BAR", new Object[]{string, string2}), (Object)string);
            }
        } else {
            dataSeries.setPriceBarColor(n2, color3);
            if (bl2 && !Util.compare((Object)color4, (Object)color3)) {
                dataContext.signal(n2, (Object)StochasticBarPattern$Signals.NEUTRAL_BAR, this.get("SIGNAL_STO_NEUTRAL_BAR", new Object[]{string, string2}), (Object)string);
            }
        }
        dataSeries.setComplete(n2, bl2);
    }
}

