/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.command.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.Enums$WSLocation;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.d;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.AnalysisSource;
import com.motivewave.platform.databean.DirectoryListener;
import com.motivewave.platform.databean.ServiceInfo;
import com.motivewave.platform.databean.au;
import com.motivewave.platform.databean.av;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.ui.component.n;
import cs.j;
import cs.m;
import i.c;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import k.af;
import k.f;
import k.g;
import k.q;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Workspace
extends a.b {
    private String name;
    private String dbName;
    private Enums$ServiceType service;
    private Enums$WSLocation location = Enums$WSLocation.LOCAL;
    private String wsBucket;
    private List instances = new ArrayList();
    private Map settingsMap = new HashMap();
    private boolean useDatabase = true;
    private File directory;
    private boolean includePreferences = true;
    private boolean includeWindows = true;
    private boolean includeWatchLists = true;
    private boolean includeScans = true;
    private boolean includeTemplates = true;
    private boolean includeAlerts = true;
    private boolean overrideRepository = true;
    private f analysisSources = new f();
    private static File workspacesDir;
    private static f workspaces;
    private static Map name2Workspace;
    private static File workingDir;
    private static String SYNC;
    private static f listeners;

    public Workspace(String string, Enums$ServiceType enums$ServiceType) {
        this.name = string;
        if (h.b((Object)enums$ServiceType)) {
            enums$ServiceType = Enums$ServiceType.IB;
        }
        this.service = enums$ServiceType;
    }

    public File getConfigDir() {
        return this.getConfigDir(true);
    }

    public File getAnalysisDir() {
        if (!this.isUseDatabase() && this.directory != null && this.directory.exists()) {
            return new File(this.directory, "analysis");
        }
        return new File(Workspace.getWorkspaceDir(), "analysis");
    }

    public File getConfigDir(boolean bl2) {
        if (ae.a() == this && !this.isUseDatabase() && bl2) {
            return new File(this.directory, "config");
        }
        File file = new File(this.getDir(), "cfg");
        if (file.exists()) {
            return file;
        }
        return new File(this.getDir(), "config");
    }

    public boolean isVersion4() {
        if (!this.getDir().exists()) {
            return false;
        }
        File file = this.getConfigDir();
        return !file.exists();
    }

    public boolean isDBExists() {
        if (!h.g(this.dbName) && !h.a((Object)this.dbName, (Object)this.name) && this.isDBExists(this.dbName)) {
            return true;
        }
        if (this.isDBExists(this.name)) {
            this.dbName = null;
            return true;
        }
        return false;
    }

    private boolean isDBExists(String string) {
        File file = new File(Workspace.getWorkspacesDir(), string);
        File file2 = new File(file, "service.properties");
        if (file2.exists()) {
            return true;
        }
        file2 = new File(file, "README_DO_NOT_TOUCH_FILES.txt");
        if (file2.exists()) {
            return true;
        }
        file2 = new File(file, "seg0");
        if (file2.exists()) {
            return true;
        }
        file2 = new File(file, "log");
        return file2.exists();
    }

    public void read() {
        if (!h.a((Collection)this.instances)) {
            return;
        }
        File file = new File(this.getConfigDir(false), "workspace.json");
        if (!file.exists() && this.isDBExists()) {
            h.a.info("Workspace::read() migrating settings from the database");
            d.a(this.getDBName());
            b b2 = CommandFactory.createCmd("GET_SETTING");
            b2.a("NAME", "connection");
            b2.a(this.getDBName());
            String string = (String)b2.a();
            String string2 = this.getName();
            if (q.a(string)) {
                this.b(string);
            } else {
                this.readXML(string);
            }
            this.setName(string2);
            b2.a("NAME", "repository");
            this.settingsMap.put("repository", (String)b2.a());
            b2.a("NAME", "simulated_account");
            this.settingsMap.put("simulated_account", (String)b2.a());
            b2.a("NAME", "mid");
            this.settingsMap.put("mid", (String)b2.a());
            b2.a("NAME", "trialExpires");
            this.settingsMap.put("trialExpires", (String)b2.a());
            b2.a("NAME", "trialExpired");
            this.settingsMap.put("trialExpired", (String)b2.a());
            b2.a("NAME", "leaseExpires");
            this.settingsMap.put("leaseExpires", (String)b2.a());
            b2.a("NAME", "lastOrderId");
            this.settingsMap.put("lastOrderId", (String)b2.a());
            b2.a("NAME", "clientOrders");
            this.settingsMap.put("clientOrders", (String)b2.a());
            b2.a("NAME", "console");
            this.settingsMap.put("console", (String)b2.a());
        } else {
            String string = h.a(file);
            if (!this.isJSON(string)) {
                String string3 = s.h(string);
                if (!this.isJSON(string3)) {
                    string3 = s.d(string);
                }
                string = string3;
            }
            try {
                this.b(string);
            }
            catch (Exception exception) {
                System.err.println("error reading workspace: " + string);
            }
        }
    }

    private boolean isJSON(String string) {
        try {
            new JSONObject(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void save() {
        File file = this.getConfigDir(false);
        file.mkdirs();
        h.c(new File(file, "workspace.json"), s.g(this.c_()));
        Workspace.notifyUpdated(this);
    }

    public String getSetting(String string) {
        return (String)this.settingsMap.get(string);
    }

    public void setSetting(String string, String string2) {
        this.settingsMap.put(string, string2);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.firePropertyChange("name", string2, string);
    }

    public boolean isLocal() {
        return this.location == null || this.location == Enums$WSLocation.LOCAL;
    }

    public boolean isRemote() {
        return !this.isLocal();
    }

    public Enums$WSLocation getLocation() {
        return this.location;
    }

    public void setLocation(Enums$WSLocation enums$WSLocation) {
        Enums$WSLocation enums$WSLocation2 = this.location;
        this.location = enums$WSLocation;
        this.firePropertyChange("location", (Object)enums$WSLocation2, (Object)this.location);
    }

    public String getWsBucket() {
        return this.wsBucket;
    }

    public void setWsBucket(String string) {
        String string2 = this.wsBucket;
        this.wsBucket = string;
        this.firePropertyChange("wsBucket", string2, this.wsBucket);
    }

    public String getDBName() {
        return h.g(this.dbName) ? this.name : this.dbName;
    }

    public void resetDBName() {
        this.dbName = null;
    }

    public Enums$ServiceType getService() {
        if (h.a((Collection)this.instances)) {
            return this.service;
        }
        ServiceInfo serviceInfo = this.getPrimaryService();
        if (serviceInfo == null || serviceInfo.getPrimaryInfo() == null) {
            return this.service;
        }
        return serviceInfo.getPrimaryInfo().getType();
    }

    @Override
    public List getNVPs() {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : this.settingsMap.keySet()) {
            Object object3;
            if (h.a((String)object2, "lastOrderId", "clientOrders", "console", "repository") || h.g((String)(object3 = (String)this.settingsMap.get(object2)))) continue;
            arrayList.add(this.a_((String)object2, (String)object3));
        }
        List list = h.b(new String[]{this.a("useDatabase", this.useDatabase), this.a("includePreferences", this.includePreferences), this.a("includeWindows", this.includeWindows), this.a("includeWatchLists", this.includeWatchLists), this.a("includeScans", this.includeScans), this.a("includeTemplates", this.includeTemplates), this.a("includeAlerts", this.includeAlerts), this.a("directory", this.directory), this.a("overrideRepository", this.overrideRepository)});
        object2 = h.b(new String[0]);
        for (AnalysisSource analysisSource : this.analysisSources.a()) {
            File file;
            if (analysisSource == null || (file = analysisSource.getDirectory()) == null || !file.exists() || !file.isDirectory()) continue;
            object2.add(this.a(this.b("name", analysisSource.getName()), this.a("readOnly", analysisSource.isReadOnly()), this.a("dir", file)));
        }
        list.add(this.a("sources", (Collection)object2));
        return h.b(new String[]{this.b("name", this.name), this.a("location", (Object)this.location), this.a_("wsBucket", this.wsBucket), this.a("instances", this.instances), this.a_("repository", this.a(list)), this.a_("settings", this.a(arrayList))});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        Object object2;
        this.name = jSONObject.str("name");
        if (jSONObject.has("location")) {
            try {
                this.location = Enums$WSLocation.valueOf(jSONObject.str("location"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.wsBucket = jSONObject.str("wsBucket");
        this.instances = new ArrayList();
        for (Object object2 : jSONObject.getObjList("instances")) {
            this.instances.add(new ServiceInfo((JSONObject)object2));
        }
        Object object3 = jSONObject.obj("repository");
        if (object3 == null && !h.g((String)(object2 = Workspace.get("repository")))) {
            if (q.a((String)object2)) {
                try {
                    object3 = new JSONObject((String)object2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.readRepository((String)object2);
            }
        }
        if (object3 != null) {
            this.includePreferences = ((JSONObject)object3).is("includePreferences");
            this.includeWindows = ((JSONObject)object3).is("includeWindows");
            this.includeWatchLists = ((JSONObject)object3).is("includeWatchLists");
            this.includeScans = ((JSONObject)object3).is("includeScans");
            this.includeTemplates = ((JSONObject)object3).is("includeTemplates");
            this.includeAlerts = ((JSONObject)object3).is("includeAlerts");
            this.overrideRepository = ((JSONObject)object3).is("overrideRepository");
            this.useDatabase = true;
            this.directory = null;
            if (((JSONObject)object3).has("directory")) {
                object2 = ((JSONObject)object3).getFile("directory");
                if (object2 == null || !((File)object2).exists()) {
                    h.a.warning("RepositorySettings::fromJSON() directory not found: " + ((JSONObject)object3).str("directory"));
                } else {
                    this.useDatabase = ((JSONObject)object3).is("useDatabase");
                    this.directory = object2;
                }
            }
            this.analysisSources.b();
            for (Object object4 : ((JSONObject)object3).getObjList("sources")) {
                Object object5 = ((JSONObject)object4).getFile("dir");
                if (object5 == null || !((File)object5).exists()) {
                    h.a.warning("RepositorySettings::fromJSON() source directory not found: " + ((JSONObject)object4).str("dir"));
                    continue;
                }
                AnalysisSource analysisSource = new AnalysisSource(((JSONObject)object4).str("name"), (File)object5, ((JSONObject)object4).is("readOnly"));
                if (this.analysisSources.b(analysisSource)) continue;
                this.analysisSources.a(analysisSource);
            }
        }
        this.settingsMap.clear();
        if (!jSONObject.has("settings")) {
            return;
        }
        object2 = jSONObject.obj("settings");
        for (Object object5 : ((JSONObject)object2).keySet()) {
            this.settingsMap.put(object5, ((JSONObject)object2).str((String)object5));
        }
        this.settingsMap.remove("repository");
    }

    private void readRepository(String string) {
        Object object;
        if (h.g(string)) {
            return;
        }
        Element element = g.a(string);
        String string2 = element.getAttribute("useDatabase");
        if (!h.g(string2)) {
            this.useDatabase = h.a((Object)string2);
        }
        if (!h.g(string2 = element.getAttribute("includePreferences"))) {
            this.includePreferences = h.a((Object)string2);
        }
        if (!h.g(string2 = element.getAttribute("includeWindows"))) {
            this.includeWindows = h.a((Object)string2);
        }
        if (!h.g(string2 = element.getAttribute("includeWatchLists"))) {
            this.includeWatchLists = h.a((Object)string2);
        }
        if (!h.g(string2 = element.getAttribute("includeScans"))) {
            this.includeScans = h.a((Object)string2);
        }
        if (!h.g(string2 = element.getAttribute("includeTemplates"))) {
            this.includeTemplates = h.a((Object)string2);
        }
        if (!h.g(string2 = element.getAttribute("includeAlerts"))) {
            this.includeAlerts = h.a((Object)string2);
        }
        if (!h.g(string2 = element.getAttribute("directory"))) {
            object = new File(string2);
            if (!((File)object).exists()) {
                h.a.warning("RepositorySettings::read() directory not found: " + string2);
                this.useDatabase = true;
            } else {
                this.directory = object;
            }
        }
        if (!h.g(string2 = element.getAttribute("overrideRepository"))) {
            this.overrideRepository = h.a((Object)string2);
        }
        if ((object = g.b("sources", element)) != null) {
            for (Element element2 : g.c("source", (Node)object)) {
                AnalysisSource analysisSource;
                String string3 = element2.getAttribute("name");
                if (h.g(string3) || h.g(string2 = element2.getAttribute("dir"))) continue;
                File file = new File(string2);
                if (!file.exists()) {
                    h.a.warning("RepositorySettings::read() source directory not found: " + string2);
                    continue;
                }
                boolean bl2 = true;
                string2 = element2.getAttribute("readOnly");
                if (!h.g(string2)) {
                    bl2 = h.a((Object)string2);
                }
                if (this.analysisSources.b(analysisSource = new AnalysisSource(string3, file, bl2))) continue;
                this.analysisSources.a(analysisSource);
            }
        }
    }

    private void readXML(String string) {
        this.instances = new ArrayList();
        Element element = g.a(string);
        if (element.getTagName().equals("service_instance")) {
            ServiceInfo serviceInfo = new ServiceInfo();
            if (serviceInfo.read(element)) {
                this.instances.add(serviceInfo);
            }
        } else {
            Iterator iterator = g.c("service_instance", element).iterator();
            while (iterator.hasNext()) {
                ServiceInfo serviceInfo = new ServiceInfo();
                Element element2 = (Element)iterator.next();
                if (!serviceInfo.read(element2)) continue;
                this.instances.add(serviceInfo);
            }
        }
    }

    public ServiceInfo getPrimaryService() {
        if (h.a((Collection)this.instances)) {
            return null;
        }
        return (ServiceInfo)this.instances.get(0);
    }

    public List getServiceTypes() {
        ArrayList<Enums$ServiceType> arrayList = new ArrayList<Enums$ServiceType>();
        for (ServiceInfo serviceInfo : this.instances) {
            if (arrayList.contains((Object)serviceInfo.getPrimaryInfo().getType())) continue;
            arrayList.add(serviceInfo.getPrimaryInfo().getType());
        }
        return arrayList;
    }

    public List getInstances() {
        return this.instances;
    }

    public void setInstances(List list) {
        this.instances = new ArrayList(list);
        this.service = this.getService();
    }

    public boolean isUseDatabase() {
        return this.useDatabase || this.directory == null || !this.directory.exists();
    }

    public void setUseDatabase(boolean bl2) {
        this.useDatabase = bl2;
    }

    public File getRepoDir() {
        return this.directory;
    }

    public void setRepoDir(File file) {
        this.directory = file;
    }

    public boolean supportsExternalSave() {
        for (AnalysisSource analysisSource : this.analysisSources.a()) {
            if (analysisSource.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public boolean isIncludePreferences() {
        return this.includePreferences;
    }

    public void setIncludePreferences(boolean bl2) {
        this.includePreferences = bl2;
    }

    public boolean isIncludeWindows() {
        return this.includeWindows;
    }

    public void setIncludeWindows(boolean bl2) {
        this.includeWindows = bl2;
    }

    public boolean isIncludeWatchLists() {
        return this.includeWatchLists;
    }

    public void setIncludeWatchLists(boolean bl2) {
        this.includeWatchLists = bl2;
    }

    public boolean isIncludeScans() {
        return this.includeScans;
    }

    public void setIncludeScans(boolean bl2) {
        this.includeScans = bl2;
    }

    public boolean isIncludeTemplates() {
        return this.includeTemplates;
    }

    public void setIncludeTemplates(boolean bl2) {
        this.includeTemplates = bl2;
    }

    public boolean isIncludeAlerts() {
        return this.includeAlerts;
    }

    public void setIncludeAlerts(boolean bl2) {
        this.includeAlerts = bl2;
    }

    public boolean isOverrideRepository() {
        return this.overrideRepository;
    }

    public void setOverrideRepository(boolean bl2) {
        this.overrideRepository = bl2;
    }

    public List getAnalysisSources() {
        return this.analysisSources.a();
    }

    public void setAnalysisSources(List list) {
        this.analysisSources.d(list);
    }

    private boolean isCheckRepository(String string) {
        String string2 = string;
        if (string2.indexOf(46) >= 0) {
            string2 = string2.substring(0, string2.indexOf(46));
        }
        switch (string2 = string2.toLowerCase()) {
            case "config": 
            case "journal": 
            case "account": 
            case "defaults": 
            case "commissions": 
            case "components": 
            case "keymap": 
            case "order_presets": 
            case "orders": 
            case "trading_hours": 
            case "ofa": 
            case "hurst": 
            case "trade_history": 
            case "instruments": 
            case "currencies": 
            case "exchanges": 
            case "custom_columns": 
            case "gauges": 
            case "gauge_panels": {
                return this.isIncludePreferences();
            }
            case "desktops": 
            case "windows": {
                return this.isIncludeWindows();
            }
            case "alerts": 
            case "alert_history": {
                return this.isIncludeAlerts();
            }
            case "scans": 
            case "strategy_analysis": {
                return this.isIncludeScans();
            }
            case "watchlists": {
                return this.isIncludeWatchLists();
            }
            case "templates": {
                return this.isIncludeTemplates();
            }
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public File getDir() {
        File file = new File(Workspace.getWorkspacesDir(), this.getDBName());
        if (file.exists()) {
            return file;
        }
        return new File(Workspace.getWorkspacesDir(), this.getName());
    }

    public static void addListener(DirectoryListener directoryListener) {
        listeners.a(directoryListener);
    }

    public static void removeListener(DirectoryListener directoryListener) {
        listeners.a(directoryListener);
    }

    private static void notifyCreated(Workspace workspace) {
        for (DirectoryListener directoryListener : listeners.a()) {
            directoryListener.created(workspace);
        }
    }

    private static void notifyUpdated(Workspace workspace) {
        for (DirectoryListener directoryListener : listeners.a()) {
            directoryListener.updated(workspace);
        }
    }

    private static void notifyDeleted(Workspace workspace) {
        for (DirectoryListener directoryListener : listeners.a()) {
            directoryListener.deleted(workspace);
        }
    }

    private static void notifyUpdated() {
        for (DirectoryListener directoryListener : listeners.a()) {
            directoryListener.updated();
        }
    }

    public static File findDir(String string) {
        Workspace workspace = ae.a();
        if (workspace == null) {
            return null;
        }
        return workspace.getConfigDir(workspace.isCheckRepository(string));
    }

    public static File findFile(String string) {
        return Workspace.findFile(ae.a(), string);
    }

    public static File findFile(Workspace workspace, String string) {
        File file;
        if (workspace == null) {
            return null;
        }
        boolean bl2 = workspace.isCheckRepository(string);
        if (string.indexOf(46) < 0) {
            File file2;
            if (bl2 && !workspace.isUseDatabase() && workspace.directory != null && workspace.directory.exists()) {
                file2 = new File(workspace.directory, "config");
                File file3 = new File(file2, string + ".json");
                if (file3.exists()) {
                    return file3;
                }
                file3 = new File(file2, string + ".xml");
                if (file3.exists()) {
                    return file3;
                }
                file3 = new File(file2, string + ".csv");
                if (file3.exists()) {
                    return file3;
                }
            }
            if ((file2 = new File(workspace.getConfigDir(false), string + ".json")).exists()) {
                return file2;
            }
            file2 = new File(workspace.getConfigDir(false), string + ".csv");
            return file2.exists() ? file2 : null;
        }
        if (bl2 && !workspace.isUseDatabase() && workspace.directory != null && workspace.directory.exists() && (file = new File(new File(workspace.directory, "config"), string)).exists()) {
            return file;
        }
        file = new File(workspace.getConfigDir(false), string);
        return file.exists() ? file : null;
    }

    public static boolean hasDB() {
        Workspace workspace = ae.a();
        if (workspace == null) {
            return false;
        }
        return workspace.isDBExists();
    }

    public static String get(String string) {
        Workspace workspace = ae.a();
        if (workspace == null) {
            return null;
        }
        return workspace.getSetting(string);
    }

    public static void set(String string, String string2) {
        Workspace workspace = ae.a();
        if (workspace == null) {
            return;
        }
        workspace.setSetting(string, string2);
    }

    public static File getWorkspaceDir() {
        Workspace workspace = ae.a();
        if (workspace == null) {
            return null;
        }
        return workspace.getDir();
    }

    public static File getWorkspacesDir() {
        if (workspacesDir == null && !(workspacesDir = new File(Workspace.getWorkingDir(), "workspaces")).exists()) {
            workspacesDir.mkdir();
        }
        return workspacesDir;
    }

    public static File getMediaDir() {
        File file;
        if (h.c()) {
            File file2 = new File("/System/Library/Sounds");
            return file2.exists() ? file2 : null;
        }
        String string = System.getenv("SystemRoot");
        if (h.g(string)) {
            string = System.getenv("windir");
        }
        if (h.g(string)) {
            string = "c:/Windows";
        }
        if (!(file = new File(string)).exists()) {
            h.a.severe("Config::getMediaDir()::unable to locate system root!");
            return null;
        }
        File file3 = new File(file, "Media");
        if (!file3.exists()) {
            h.a.severe("Config::getMediaDir()::unable to locate media directory!");
            return null;
        }
        return file3;
    }

    public static File getLogDir() {
        File file = new File(Workspace.getWorkingDir(), "output");
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }

    public static File getWorkingDir() {
        if (workingDir == null) {
            File file;
            File file2 = new File("./dev.txt");
            if (file2.exists()) {
                workingDir = new File("..");
                return workingDir;
            }
            if (h.c()) {
                String string = System.getProperty("user.home");
                String string2 = string + "/Library/MotiveWave";
                File file3 = new File(string2);
                if (!file3.exists()) {
                    file3.mkdirs();
                }
                workingDir = file3;
                return workingDir;
            }
            File file4 = new File(FileSystemView.getFileSystemView().getHomeDirectory().getParent(), ".motivewave");
            if (file4.exists()) {
                workingDir = file4;
                return workingDir;
            }
            String string = System.getenv("APPDATA");
            if (!h.g(string) && (file = new File(string)).exists()) {
                File file5 = new File(file, "MotiveWave");
                if (!file5.exists()) {
                    file5.mkdir();
                }
                workingDir = file5;
                return workingDir;
            }
            file4.mkdir();
            workingDir = file4;
        }
        return workingDir;
    }

    public static File getInstallDir() {
        File file = new File("./dev.txt");
        if (file.exists()) {
            return new File(".");
        }
        if (h.c()) {
            String string = System.getProperty("appDir");
            if (!h.g(string)) {
                File file2 = new File(string + "/Contents");
                if (!file2.exists()) {
                    h.a.severe("App Directory not found! " + string);
                } else {
                    return file2;
                }
            }
            return new File("..");
        }
        String string = af.a(-2147483646, "SOFTWARE\\MotiveWave Software\\MotiveWave", "InstallLocation");
        if (h.g(string)) {
            File file3 = new File("c:/Program Files/MotiveWave");
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("c:/Program Files (x86)/MotiveWave");
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("d:/Program Files/MotiveWave");
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("d:/Program Files (x86)/MotiveWave");
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("c:/MotiveWave");
            if (file3.exists()) {
                return file3;
            }
            file3 = new File("d:/MotiveWave");
            if (file3.exists()) {
                return file3;
            }
            return new File(".");
        }
        return new File(string);
    }

    public static File getDownloadDir() {
        return Workspace.getWorkingDir() == null ? null : new File(Workspace.getWorkingDir(), "download");
    }

    public static File getDesktopDir() {
        return FileSystemView.getFileSystemView().getHomeDirectory();
    }

    public static File getLibDir() {
        return new File(Workspace.getInstallDir(), "lib");
    }

    public static List getWorkspaces() {
        return workspaces.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSupportedWorkspaces() {
        List list = ae.x();
        ArrayList<Workspace> arrayList = new ArrayList<Workspace>();
        String string = SYNC;
        synchronized (string) {
            for (Workspace workspace : workspaces.a()) {
                if (!list.contains((Object)workspace.getService())) {
                    h.a.warning("Config::getSupportedWorkspaces() skipping unsupported service: " + workspace.getService() + " edition: " + m.a());
                    continue;
                }
                arrayList.add(workspace);
            }
        }
        return arrayList;
    }

    public static Workspace getWorkspace(String string) {
        for (Workspace workspace : Workspace.getWorkspaces()) {
            if (!h.b((Object)string, (Object)workspace.getName())) continue;
            return workspace;
        }
        return null;
    }

    public static void create(Workspace workspace, n n2) {
        File file = new File(Workspace.getWorkspacesDir(), workspace.getName());
        if (file.exists()) {
            throw new MWException(com.motivewave.platform.common.h.E_CREATE_WORKSPACE, ai.a("MSG_WORKSPACE_EXISTS", workspace.getName()));
        }
        n2.a(40.0);
        n2.a(ai.a("MSG_REGISTER_WORKSPACE", new Object[0]), 10.0);
        file.mkdirs();
        workspace.save();
        ArrayList<ServiceInfo> arrayList = new ArrayList<ServiceInfo>();
        block0: for (Enums$ServiceType enums$ServiceType : workspace.getServiceTypes()) {
            for (ServiceInfo serviceInfo : workspace.getInstances()) {
                if (serviceInfo.getType() != enums$ServiceType) continue;
                arrayList.add(serviceInfo);
                continue block0;
            }
        }
        if (!h.a(arrayList)) {
            ae.a(workspace, arrayList, n2);
        }
        c.c(() -> {
            String string = SYNC;
            synchronized (string) {
                if (name2Workspace.containsKey(workspace.getName())) {
                    workspaces.a((Workspace)name2Workspace.get(workspace.getName()));
                    name2Workspace.remove(workspace.getName());
                }
                name2Workspace.put(workspace.getName(), workspace);
                workspaces.a(0, workspace);
            }
            Workspace.notifyCreated(workspace);
        });
        Workspace.saveAll();
        if (workspace.isRemote()) {
            j.c();
            n2.b(ai.a("TITLE_SYNCHRONIZING", new Object[0]));
            n2.a(ai.a("MSG_SYNCHRONIZING_WORKSPACE", new Object[0]), 0.0);
            Workspace.writeRemoteWorkspaces();
            j.b(workspace);
        }
        n2.b(5.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRemoteWorkspaces() {
        Object object22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : workspaces.a()) {
            if (((Workspace)object22).getLocation() != Enums$WSLocation.MWCLOUD || !h.a((Object)((Workspace)object22).getWsBucket(), (Object)j.a())) continue;
            arrayList.add(object22);
        }
        au au2 = new au();
        object22 = h.b(new String[0]);
        String string = SYNC;
        synchronized (string) {
            for (Workspace workspace : arrayList) {
                object22.add(au2.a(au2.b("name", workspace.getName()), au2.a("service", (Object)workspace.getService())));
            }
        }
        j.a("workspaces.json", au2.b((Collection)object22));
    }

    public static int getRemoteWorkspaceCount() {
        int n2 = 0;
        for (Workspace workspace : workspaces.a()) {
            if (workspace.getLocation() != Enums$WSLocation.MWCLOUD || !h.a((Object)workspace.getWsBucket(), (Object)j.a())) continue;
            ++n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWorkspace(Workspace workspace) {
        try {
            String string = SYNC;
            synchronized (string) {
                if (name2Workspace.containsKey(workspace.getName())) {
                    name2Workspace.remove(workspace.getName());
                    workspaces.a(workspace);
                }
            }
            Workspace.notifyDeleted(workspace);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWorkspaceName(Workspace workspace, String string) {
        File file;
        if (h.a((Object)string, (Object)workspace.getName())) {
            return;
        }
        File file2 = workspace.getDir();
        if (!file2.renameTo(file = new File(Workspace.getWorkspacesDir(), string))) {
            throw new MWException(com.motivewave.platform.common.h.E_RENAME_WORKSPACE_DIR, string);
        }
        String string2 = SYNC;
        synchronized (string2) {
            if (name2Workspace.containsKey(workspace.getName())) {
                name2Workspace.remove(workspace.getName());
            }
            workspace.dbName = null;
            workspace.setName(string);
            name2Workspace.put(workspace.getName(), workspace);
            workspace.save();
        }
        Workspace.saveAll();
    }

    public static void loadFromCloud() {
        LinkedHashMap<String, Workspace> linkedHashMap = new LinkedHashMap<String, Workspace>();
        try {
            String string = j.a("workspaces.json");
            if (!h.g(string)) {
                for (Workspace workspace : Workspace.readWorkspaces(string, true)) {
                    workspace.setLocation(Enums$WSLocation.MWCLOUD);
                    workspace.setWsBucket(j.a());
                    linkedHashMap.put(workspace.getName(), workspace);
                }
            }
            c.a(() -> {
                String string = SYNC;
                synchronized (string) {
                    Workspace workspace;
                    for (String string2 : linkedHashMap.keySet()) {
                        workspace = (Workspace)linkedHashMap.get(string2);
                        int n2 = -1;
                        if (name2Workspace.containsKey(string2)) {
                            Workspace workspace2 = (Workspace)name2Workspace.remove(string2);
                            n2 = workspaces.a(workspace2);
                            workspaces.a(workspace2);
                        }
                        if (n2 >= 0) {
                            workspaces.a(n2, workspace);
                        } else {
                            workspaces.a(workspace);
                        }
                        name2Workspace.put(workspace.getName(), workspace);
                    }
                    for (String string2 : new ArrayList(name2Workspace.keySet())) {
                        workspace = (Workspace)name2Workspace.get(string2);
                        if (workspace.isLocal() || linkedHashMap.containsKey(string2) && h.a((Object)workspace.getWsBucket(), (Object)j.a())) continue;
                        h.a.warning("Workspace::loadFromCloud() removing remote workspace: " + string2 + " wsBucket: " + workspace.getWsBucket());
                        name2Workspace.remove(string2);
                        workspaces.a(workspace);
                    }
                    Workspace.notifyUpdated();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            h.a.warning("Workspace::load() error loading remote workspaces " + exception.getMessage());
            linkedHashMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        String string;
        File file = new File(Workspace.getWorkspacesDir(), "workspaces.json");
        if (!file.exists()) {
            file = new File(Workspace.getWorkspacesDir(), ".workspaces");
        }
        if (h.g(string = h.a(file))) {
            return;
        }
        String string2 = SYNC;
        synchronized (string2) {
            workspaces.b();
            name2Workspace.clear();
            try {
                for (Workspace workspace : Workspace.readWorkspaces(string, false)) {
                    workspaces.a(workspace);
                    name2Workspace.put(workspace.getName(), workspace);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Workspace.notifyUpdated();
        }
    }

    private static List readWorkspaces(String string, boolean bl2) {
        ArrayList<Workspace> arrayList = new ArrayList<Workspace>();
        try {
            if (q.a(string)) {
                for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                    Enums$ServiceType enums$ServiceType = null;
                    try {
                        enums$ServiceType = Enums$ServiceType.read(jSONObject.str("service"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (enums$ServiceType == null) {
                        h.a.warning("Workspace::readWorkspaces() unrecognized service type: " + jSONObject.str("service"));
                        continue;
                    }
                    Workspace workspace = new Workspace(jSONObject.str("name"), enums$ServiceType);
                    if (jSONObject.has("database")) {
                        workspace.dbName = jSONObject.str("database");
                    }
                    if (jSONObject.has("location")) {
                        try {
                            workspace.location = Enums$WSLocation.valueOf(jSONObject.str("location"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (jSONObject.has("wsBucket")) {
                        workspace.wsBucket = jSONObject.str("wsBucket");
                    }
                    if (!workspace.getDir().exists() && !bl2 && workspace.isLocal()) {
                        h.a.warning("Workspace::load() skipping workspace: " + workspace.getName() + " since the directory does not exist");
                        continue;
                    }
                    arrayList.add(workspace);
                }
                return arrayList;
            }
            for (Element element : g.b("//workspace", g.a(string))) {
                String string2 = element.getAttribute("provider");
                if (h.g(string2)) {
                    string2 = element.getAttribute("service");
                }
                Enums$ServiceType enums$ServiceType = null;
                try {
                    enums$ServiceType = Enums$ServiceType.read(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (enums$ServiceType == null) {
                    h.a.warning("Config::readWorkspaces() unrecognized service type: " + string2);
                    continue;
                }
                Workspace workspace = new Workspace(element.getAttribute("name"), enums$ServiceType);
                workspace.dbName = element.getAttribute("database");
                if (!workspace.getDir().exists() && !bl2) {
                    h.a.warning("Workspace::load() skipping workspace: " + workspace.getName() + " since the directory does not exist");
                    continue;
                }
                arrayList.add(workspace);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAll() {
        av av2 = new av();
        List list = h.b(new String[0]);
        String string = SYNC;
        synchronized (string) {
            for (Workspace workspace : workspaces.a()) {
                list.add(av2.a(av2.b("name", workspace.getName()), av2.b("database", workspace.dbName), av2.a("service", (Object)workspace.getService()), av2.a("location", (Object)workspace.getLocation()), av2.a_("wsBucket", workspace.getLocation() == Enums$WSLocation.MWCLOUD ? workspace.getWsBucket() : null)));
            }
        }
        h.a(new File(Workspace.getWorkspacesDir(), "workspaces.json"), av2.b(list));
    }

    static {
        workspaces = new f();
        name2Workspace = new HashMap();
        SYNC = new String(h.a());
        listeners = new f();
    }
}

