/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.c;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.command.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.an;
import com.motivewave.platform.databean.WatchList;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.as;
import com.motivewave.platform.databean.at;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.cx;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import k.f;
import k.g;
import k.q;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import q.k;

public class WatchListDirectory {
    private static f allWatchlists = new f();
    private static f listeners = new f();

    public static void register(WatchList watchList) {
        if (watchList == null || allWatchlists.b(watchList)) {
            return;
        }
        allWatchlists.a(watchList);
        c.a(() -> {
            for (k k2 : listeners.a()) {
                try {
                    k2.a(watchList);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public static void replace(WatchList watchList) {
        if (watchList == null) {
            return;
        }
        allWatchlists.b(watchList);
        c.a(() -> {
            for (k k2 : listeners.a()) {
                try {
                    k2.a(watchList);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public static void create(cx cx2) {
        for (WatchList watchList : allWatchlists.a()) {
            if (!h.a((Object)watchList.getName(), (Object)cx2.a())) continue;
            return;
        }
        try {
            WatchList watchList = new WatchList(new JSONObject(cx2.c_()));
            allWatchlists.a(watchList);
            c.a(() -> {
                for (k k2 : listeners.a()) {
                    try {
                        k2.a(watchList);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void update(WatchList watchList) {
        if (watchList == null) {
            return;
        }
        allWatchlists.b(watchList);
        c.a(() -> {
            for (k k2 : listeners.a()) {
                try {
                    k2.c(watchList);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public static void updateInline(WatchList watchList) {
        if (watchList == null) {
            return;
        }
        allWatchlists.b(watchList);
        for (k k2 : listeners.a()) {
            try {
                k2.c(watchList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void remove(WatchList watchList) {
        if (watchList == null || !allWatchlists.b(watchList)) {
            return;
        }
        allWatchlists.a(watchList);
        c.a(() -> {
            for (k k2 : listeners.a()) {
                try {
                    k2.b(watchList);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            watchList.destroy();
        });
    }

    public static void save() {
        h.c(new File(Workspace.findDir("watchlists"), "watchlists.json"), new as().b(WatchListDirectory.getAll()));
    }

    public static void write(File file) {
        h.a(new File(file, "watchlists.json"), new at().b(WatchListDirectory.getAll()));
    }

    public static void read() {
        allWatchlists.b();
        for (WatchList watchList : WatchListDirectory.read(ae.a())) {
            WatchListDirectory.register(watchList);
        }
    }

    public static List read(Workspace workspace) {
        File file = Workspace.findFile(workspace, "watchlists");
        if (file == null || !file.exists()) {
            if (workspace.isDBExists()) {
                try {
                    b b2 = CommandFactory.createCmd("LOAD_WATCH_LISTS");
                    b2.a(workspace.getDBName());
                    return (List)b2.a();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return Collections.EMPTY_LIST;
        }
        List<WatchList> list = new ArrayList();
        try {
            String string = h.a(file);
            try {
                if (q.a(string)) {
                    if (!h.g(string)) {
                        for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                            list.add(new WatchList(jSONObject));
                        }
                    }
                } else {
                    list = WatchListDirectory.readWatchLists(g.a(string));
                }
            }
            catch (Exception exception) {
                h.a.warning("WatchListDirectory::read(File) error loading watch lists: " + exception.getMessage());
                h.a.warning(string);
            }
            if (an.ag()) {
                WatchListDirectory.moveToFront(list, "Indices");
                WatchListDirectory.moveToFront(list, "TSU Top 10");
                WatchListDirectory.moveToFront(list, "TSU Top 50");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return list;
    }

    private static void moveToFront(List list, String string) {
        WatchList watchList = null;
        for (WatchList watchList2 : list) {
            if (!h.a((Object)watchList2.getName(), (Object)string)) continue;
            watchList = watchList2;
            break;
        }
        if (watchList != null) {
            list.remove(watchList);
            list.add(0, watchList);
        }
    }

    public static List readWatchLists(Element element) {
        ArrayList<WatchList> arrayList = new ArrayList<WatchList>();
        List list = g.c("wl_wrapper", element);
        if (h.a((Collection)list)) {
            return arrayList;
        }
        for (Element element2 : list) {
            try {
                Node node = g.b("watchlist", element2);
                if (node == null && (node = g.b("folder", element2)) == null) continue;
                String string = element2.getAttribute("name");
                WatchList watchList = new WatchList(-1);
                watchList.setName(string);
                watchList.setConfig(g.a(node));
                arrayList.add(watchList);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    public static void addListener(k k2) {
        listeners.a(k2);
    }

    public static void removeListener(k k2) {
        listeners.a(k2);
    }

    public static WatchList get(String string) {
        for (WatchList watchList : allWatchlists.a()) {
            if (!h.a((Object)watchList.getName(), (Object)string)) continue;
            return watchList;
        }
        return null;
    }

    public static WatchList get(int n2) {
        for (WatchList watchList : allWatchlists.a()) {
            if (watchList.getId() != n2) continue;
            return watchList;
        }
        return null;
    }

    public static List getAll() {
        return allWatchlists.a();
    }

    public static List getAllByName() {
        ArrayList arrayList = new ArrayList(WatchListDirectory.getAll());
        arrayList.sort((watchList, watchList2) -> watchList.getName().compareTo(watchList2.getName()));
        return arrayList;
    }

    public static List getNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WatchList watchList : allWatchlists.a()) {
            if (watchList == null) continue;
            arrayList.add(watchList.getName());
        }
        return arrayList;
    }

    public static void clear() {
        allWatchlists.b();
    }

    public static List getQuoteSheets() {
        ArrayList<WatchList> arrayList = new ArrayList<WatchList>();
        for (WatchList watchList : allWatchlists.a()) {
            if (!watchList.isQuoteSheet()) continue;
            arrayList.add(watchList);
        }
        return arrayList;
    }

    public static List getWatchLists() {
        ArrayList<WatchList> arrayList = new ArrayList<WatchList>();
        for (WatchList watchList : allWatchlists.a()) {
            if (!watchList.isWatchList()) continue;
            arrayList.add(watchList);
        }
        return arrayList;
    }
}

