/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import a.b;
import ck.ag;
import ck.ak;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ChartLink;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.an;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.GroupInfo;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.OptionInfo;
import com.motivewave.platform.databean.RowFormat;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.service.ad;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import com.motivewave.platform.service.aw;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import k.f;
import k.g;
import k.z;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WatchList
extends b
implements o,
Comparable,
z {
    private int iId;
    private String name;
    private String type = "W";
    private List columns = new ArrayList();
    private f tickers = new f();
    private f groups = new f();
    private Enums$ServiceType serviceType;
    private Map formatMap = new HashMap();

    public WatchList(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public WatchList() {
        this(-1);
    }

    public WatchList(int n2) {
        this.iId = n2;
        ad ad2 = ae.a(null);
        if (ad2 != null) {
            ak[] akArray;
            for (ak ak2 : akArray = ad2.r()) {
                this.columns.add(ak2.a());
            }
        }
    }

    @Override
    public String format(String string) {
        if (h.g(string)) {
            return "";
        }
        if (string.equals("name")) {
            return this.getName();
        }
        return super.format(string);
    }

    public int getId() {
        return this.iId;
    }

    public void setId(int n2) {
        this.iId = n2;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List getTickers() {
        return this.tickers.a();
    }

    public void setTickers(List list) {
        this.tickers.d(list);
    }

    public List getActiveTickers() {
        ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>();
        if (this.isWatchList()) {
            for (LiveTicker liveTicker : this.tickers.a()) {
                if (liveTicker == null || arrayList.contains(liveTicker)) continue;
                arrayList.add(liveTicker);
            }
        } else {
            for (GroupInfo groupInfo : this.groups.a()) {
                for (LiveTicker liveTicker : groupInfo.getTickers()) {
                    if (liveTicker == null || arrayList.contains(liveTicker)) continue;
                    arrayList.add(liveTicker);
                }
            }
        }
        return arrayList;
    }

    public int size() {
        return this.tickers == null ? 0 : this.tickers.a();
    }

    public List getGroups() {
        return this.groups.a();
    }

    public void setGroups(List list) {
        this.groups.d(list);
    }

    public List getGroupNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GroupInfo groupInfo : this.groups.a()) {
            arrayList.add(groupInfo.getName());
        }
        return arrayList;
    }

    public GroupInfo getGroup(String string) {
        for (GroupInfo groupInfo : this.groups.a()) {
            if (!h.a((Object)groupInfo.getName(), (Object)string)) continue;
            return groupInfo;
        }
        return null;
    }

    public void addTickers(List list) {
        this.tickers.a(list);
    }

    public void addTicker(int n2, LiveTicker liveTicker) {
        if (liveTicker == null) {
            return;
        }
        this.tickers.a(n2, liveTicker);
        ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>(this.tickers.a());
        arrayList.remove(liveTicker);
        arrayList.add(n2, liveTicker);
        this.tickers.d(arrayList);
    }

    public void removeTicker(LiveTicker liveTicker) {
        this.tickers.a(liveTicker);
    }

    public boolean removeTickers(List list) {
        boolean bl2 = false;
        for (LiveTicker liveTicker : list) {
            if (!this.tickers.a(liveTicker)) continue;
            bl2 = true;
        }
        return bl2;
    }

    public void removeGroup(GroupInfo groupInfo) {
        this.groups.a(groupInfo);
    }

    public void addGroup(GroupInfo groupInfo) {
        this.groups.a(groupInfo);
    }

    @Override
    public List getNVPs() {
        List list = h.b(new String[]{this.b("name", this.name), this.b("type", this.type), this.a("srvc", (Object)this.serviceType)});
        List list2 = h.b(new String[0]);
        for (ak ak2 : this.columns) {
            list2.add(this.a(this.b("id", ak2.a()), this.a("visible", ak2.a()), this.a("width", ak2.a())));
        }
        list.add(this.a("columns", (Collection)list2));
        if (this.isQuoteSheet()) {
            list.add(this.a("groups", (Object)this.groups));
        } else {
            list.add(this.a_("instruments", this.a(this.tickers.a())));
        }
        if (!h.a(this.formatMap)) {
            list.add(this.a("formats", this.formatMap.values()));
        }
        return list;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        z z2;
        this.name = jSONObject.str("name");
        this.type = jSONObject.str("type");
        try {
            this.serviceType = Enums$ServiceType.read(jSONObject.str("srvc"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.columns = new ArrayList();
        for (Object object : jSONObject.getObjList("columns")) {
            z2 = ak.a(((JSONObject)object).str("id"));
            if (z2 == null) continue;
            ((ak)z2).a(((JSONObject)object).getInt("width"));
            ((ak)z2).a(((JSONObject)object).is("visible"));
            this.columns.add(z2);
        }
        if (this.columns.isEmpty()) {
            this.loadDefaultColumns();
        }
        this.groups.b();
        for (Object object : jSONObject.getObjList("groups")) {
            this.groups.a(new GroupInfo((JSONObject)object));
        }
        this.tickers.b();
        for (Object object : jSONObject.getStringList("instruments")) {
            z2 = MWInstrument.resolveExpiredContract(this.a((String)object));
            if (z2 == null) continue;
            this.tickers.a(LiveTicker.get((MWInstrument)z2));
        }
        if (jSONObject.has("formats")) {
            for (Object object : jSONObject.getObjList("formats")) {
                z2 = new RowFormat((JSONObject)object);
                this.formatMap.put(((RowFormat)z2).getKey(), z2);
            }
        }
    }

    public boolean isWatchList() {
        return h.g(this.type) || h.a((Object)this.type, (Object)"W");
    }

    public boolean isQuoteSheet() {
        return h.a((Object)this.type, (Object)"Q");
    }

    public Enums$ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(Enums$ServiceType enums$ServiceType) {
        this.serviceType = enums$ServiceType;
    }

    public void updateColumns(List list) {
        ArrayList<ak> arrayList = new ArrayList<ak>();
        for (ak ak2 : list) {
            arrayList.add(ak2.a());
        }
        this.columns = arrayList;
    }

    public List getColumns() {
        return this.columns;
    }

    public RowFormat getFormat(Ticker ticker) {
        if (ticker == null) {
            return null;
        }
        Object object = ticker.getSymbol();
        if (!h.g(ticker.getExchangeSymbol())) {
            object = (String)object + ":" + ticker.getExchangeSymbol();
        }
        return (RowFormat)this.formatMap.get(object);
    }

    public void setFormat(Ticker ticker, RowFormat rowFormat) {
        Object object = ticker.getSymbol();
        if (!h.g(ticker.getExchangeSymbol())) {
            object = (String)object + ":" + ticker.getExchangeSymbol();
        }
        if (rowFormat == null) {
            this.formatMap.remove(object);
        } else {
            this.formatMap.put(object, rowFormat);
        }
    }

    @Override
    public WatchList clone() {
        try {
            WatchList watchList = (WatchList)super.clone();
            watchList.tickers = this.tickers.a();
            watchList.columns = new ArrayList();
            if (!h.a((Collection)this.columns)) {
                for (z z2 : this.columns) {
                    watchList.columns.add(((ak)z2).a());
                }
            }
            watchList.groups = new f();
            if (!h.b((Object)this.groups)) {
                for (z z2 : this.groups.a()) {
                    watchList.groups.a(((GroupInfo)z2).clone());
                }
            }
            watchList.formatMap = new HashMap();
            if (!h.a(this.formatMap)) {
                for (z z2 : this.formatMap.values()) {
                    watchList.formatMap.put(((RowFormat)z2).getKey(), ((RowFormat)z2).clone());
                }
            }
            return watchList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(WatchList watchList) {
        if (watchList == null || watchList.getName() == null) {
            return 1;
        }
        if (this.getName() == null) {
            return -1;
        }
        return this.getName().compareTo(watchList.getName());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            WatchList watchList = (WatchList)object;
            return h.a((Object)watchList.getName(), (Object)this.getName());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private List readTickers(Element element) {
        ArrayList<LiveTicker> arrayList = new ArrayList<LiveTicker>();
        Node node = g.b("instruments", element);
        List list = g.c("instrument", node);
        if (h.a((Collection)list)) {
            list = g.c("instr", node);
        }
        for (Element element2 : list) {
            MWInstrument mWInstrument = MWInstrument.resolveExpiredContract(this.readInstrument(element2));
            if (mWInstrument == null) continue;
            arrayList.add(LiveTicker.get(mWInstrument));
        }
        return arrayList;
    }

    private void loadDefaultColumns() {
        ArrayList<ak> arrayList = new ArrayList<ak>();
        LinkedHashMap<String, ak> linkedHashMap = new LinkedHashMap<String, ak>();
        ad ad2 = ae.a(this.serviceType);
        boolean bl2 = ad2 != null;
        LinkedHashMap<String, ak> linkedHashMap2 = new LinkedHashMap<String, ak>();
        List list = ae.m();
        for (ak ak2 : list) {
            if (ak2 == null) continue;
            linkedHashMap2.put(ak2.a(), ak2);
        }
        if (an.ag() || !bl2) {
            this.addColumn(ck.o.SYMBOL, linkedHashMap2, linkedHashMap);
            this.addColumn(ck.o.DESCRIPTION, linkedHashMap2, linkedHashMap);
            this.addColumn(ag.CHANGE, linkedHashMap2, linkedHashMap);
            this.addColumn(ag.CHANGE_PER, linkedHashMap2, linkedHashMap);
            this.addColumn(ag.BID_PRICE, linkedHashMap2, linkedHashMap);
            this.addColumn(ag.ASK_PRICE, linkedHashMap2, linkedHashMap);
            this.addColumn(ag.LAST_PRICE, linkedHashMap2, linkedHashMap);
            this.addColumn(ag.VOLUME, linkedHashMap2, linkedHashMap);
            return;
        }
        for (ak ak3 : ad2.r()) {
            arrayList.add(ak3.a());
            linkedHashMap.put(ak3.a(), ak3);
        }
        for (ak ak4 : list) {
            if (linkedHashMap.containsKey(ak4.a())) continue;
            ak4 = ak4.a();
            ak4.a(false);
            arrayList.add(ak4);
        }
        this.columns = arrayList;
    }

    private void addColumn(ak ak2, Map map, Map map2) {
        if (!h.a(map) && !map.containsKey(ak2.a())) {
            return;
        }
        ak2 = ak2.a();
        ak2.a(true);
        ArrayList<ak> arrayList = new ArrayList<ak>(this.columns);
        arrayList.add(ak2);
        this.columns = arrayList;
        map2.put(ak2.a(), ak2);
    }

    public void setConfig(String string) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList;
        List list;
        this.type = "W";
        this.tickers.b();
        if (h.g(string)) {
            this.loadDefaultColumns();
            return;
        }
        Element element = g.a(string);
        String string2 = element.getAttribute("type");
        if (!h.g(string2)) {
            this.type = string2;
        }
        if (!h.g(string2 = element.getAttribute("srvc"))) {
            this.serviceType = Enums$ServiceType.read(string2);
        }
        if (h.a((Collection)(list = g.c("column", g.b("columns", element))))) {
            try {
                this.loadDefaultColumns();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            arrayList = new ArrayList<Object>();
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Object object3 : list) {
                object2 = object3.getAttribute("id");
                if (h.a(object2, (Object)"symbol")) {
                    object2 = "symbolDisplay";
                }
                if ((object = ak.a((String)object2)) == null) continue;
                string2 = object3.getAttribute("width");
                if (!h.g(string2)) {
                    ((ak)object).a(h.b(string2));
                }
                ((ak)object).a(true);
                string2 = object3.getAttribute("visible");
                if (!h.g(string2)) {
                    ((ak)object).a(h.a((Object)string2));
                }
                arrayList.add(object);
                linkedHashMap.put(((ak)object).a(), object);
            }
            if (this.isWatchList()) {
                for (Object object3 : ae.m()) {
                    if (linkedHashMap.containsKey(((ak)object3).a())) continue;
                    object3 = ((ak)object3).a();
                    ((ak)object3).a(false);
                    arrayList.add(object3);
                }
            }
            this.columns = arrayList;
        }
        if (this.isQuoteSheet()) {
            arrayList = new ArrayList();
            for (Object object4 : g.c("group", element)) {
                Node node;
                Object object3;
                object3 = object4.getAttribute("name");
                object2 = new GroupInfo((String)object3, this.readTickers((Element)object4));
                object = object4.getAttribute("link");
                if (!h.g((String)object)) {
                    ((GroupInfo)object2).setLink(Enums$ChartLink.valueOf((String)object));
                }
                if ((node = g.b("foreground", (Node)object4)) != null) {
                    ((GroupInfo)object2).setForeground(h.a((Element)node));
                }
                if ((node = g.b("background", (Node)object4)) != null) {
                    ((GroupInfo)object2).setBackground(h.a((Element)node));
                }
                arrayList.add(object2);
            }
            this.groups.d(arrayList);
        } else {
            this.tickers.d(this.readTickers(element));
        }
    }

    private MWInstrument readInstrument(Element element) {
        MWInstrument mWInstrument;
        Object object3;
        MWInstrument mWInstrument2;
        String string;
        String string2 = element.getAttribute("id");
        String string3 = element.getAttribute("sym");
        if (h.g(string3)) {
            string3 = element.getAttribute("symbol");
        }
        if (h.g(string = element.getAttribute("e"))) {
            string = element.getAttribute("exchange");
        }
        if (h.g(string)) {
            string = element.getAttribute("exch");
        }
        if (h.g(string2) && h.g(string3)) {
            h.a.warning("WatchList::readInstrument() bad instrument, missing id and/or symbol");
            return null;
        }
        if (!h.g(string2) && (mWInstrument2 = MWInstrument.get(h.b(string2))) != null && h.a((Object)string3, (Object)mWInstrument2.getSymbol())) {
            return mWInstrument2;
        }
        mWInstrument2 = MWInstrument.get(string3, string);
        if (mWInstrument2 != null) {
            return mWInstrument2;
        }
        Enums$ServiceType enums$ServiceType = this.serviceType;
        if (!h.g(element.getAttribute("s"))) {
            try {
                enums$ServiceType = Enums$ServiceType.read(element.getAttribute("s"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((mWInstrument2 = MWInstrument.get(string3, enums$ServiceType)) != null) {
            return mWInstrument2;
        }
        if (h.g(element.getAttribute("t"))) {
            h.a.warning("WatchList::readInstrument() instrument not found: " + string3 + ":" + string);
            return null;
        }
        String string4 = element.getAttribute("u");
        if (h.g(string4)) {
            string4 = string3;
        }
        Enums$InstrumentType enums$InstrumentType = Enums$InstrumentType.STOCK;
        if (!h.g(element.getAttribute("t"))) {
            try {
                enums$InstrumentType = Enums$InstrumentType.valueOf(element.getAttribute("t"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double d2 = 0.01;
        if (!h.g(element.getAttribute("mt"))) {
            d2 = h.a(element.getAttribute("mt"));
        }
        Date date = null;
        if (!h.g(element.getAttribute("exp"))) {
            try {
                date = h.a(element.getAttribute("exp"), "yyyy-MM-dd");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string5 = "USD";
        if (!h.g(element.getAttribute("c"))) {
            string5 = element.getAttribute("c");
        }
        double d3 = 1.0;
        if (!h.g(element.getAttribute("pm"))) {
            d3 = h.a(element.getAttribute("pm"));
        }
        double d4 = 1.0;
        if (!h.g(element.getAttribute("pld"))) {
            d4 = h.a(element.getAttribute("pld"));
        }
        String string6 = string;
        if (!h.g(element.getAttribute("pe"))) {
            string6 = element.getAttribute("pe");
        }
        Object object2 = null;
        for (Object object3 : ae.v()) {
            if (object3.a().a().a() != enums$ServiceType) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            for (Object object3 : ae.v()) {
                if (!object3.a().a().a(enums$InstrumentType)) continue;
                object2 = object3;
                break;
            }
        }
        if (object2 == null) {
            return null;
        }
        Object object4 = enums$ServiceType;
        object3 = ((as)object2).a().a();
        if (object4 != object3 && (mWInstrument2 = MWInstrument.get(string3 = aw.a(string4, string3, enums$InstrumentType, date, (Enums$ServiceType)((Object)object4), (Enums$ServiceType)((Object)object3)), string = aw.a(string, string6, enums$InstrumentType, (Enums$ServiceType)((Object)object4), (Enums$ServiceType)((Object)object3)))) != null) {
            return mWInstrument2;
        }
        if (object3 == Enums$ServiceType.METASTOCK) {
            string3 = string3.toUpperCase();
            try {
                mWInstrument = ((as)object2).a().a(string3, enums$InstrumentType, string5, string);
                if (mWInstrument != null) {
                    return mWInstrument;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        mWInstrument = new MWInstrument(string3, enums$InstrumentType, string, string5);
        mWInstrument.setSource(((as)object2).a().getConnectionID());
        if (object3 == Enums$ServiceType.IB && !h.g(string6) && !h.a((Object)string, (Object)string6)) {
            mWInstrument.setPrimaryExchange(string6);
        }
        mWInstrument.setMinTick(d2);
        if (date != null) {
            mWInstrument.setExpiryDate(date);
        }
        mWInstrument.setUnderlying(string4);
        if (mWInstrument.isCash()) {
            mWInstrument.setPointSize(aw.b(string3));
        }
        if (mWInstrument.isFuture()) {
            mWInstrument.setPointSize(1.0);
            mWInstrument.setPointValue(aw.f(string4));
        }
        mWInstrument.setPriceMagnifier(d3);
        mWInstrument.setPLDivisor(d4);
        if (enums$InstrumentType == Enums$InstrumentType.OPTION) {
            OptionInfo optionInfo = s.a(string3, enums$ServiceType);
            mWInstrument.setStrikePrice(optionInfo.strikePrice);
            mWInstrument.setOptionType(optionInfo.putCall);
        }
        try {
            mWInstrument = MWInstrument.create(mWInstrument);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return mWInstrument;
    }
}

