/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.Enums$DayOfWeek;
import com.motivewave.common.MWException;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.command.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.o;
import com.motivewave.platform.databean.DailyHours;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.ar;
import com.motivewave.platform.service.ae;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import k.g;
import k.q;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TradingHours
extends a.b
implements o {
    public static String FXCM = "FXCM";
    public static String CRYPTO = "CRYPTO";
    public static String FOREX = "FOREX";
    public static String NYSE = "NYSE";
    public static String OTC = "OTC";
    public static String NASDAQ = "NASDAQ";
    public static String TSX = "TSX";
    public static String PFG_FOREX = "PFG_FOREX";
    public static String IB_FOREX = "IB_FOREX";
    public static String TS_FOREX = "TS_FOREX";
    public static String MB_FOREX = "MB_FOREX";
    public static String OANDA = "OANDA";
    public static String CHX = "CHX";
    public static String XETRA = "XETRA";
    public static String ASX = "ASX";
    public static String NSE = "NSE";
    public static String MCX = "MCX";
    public static String CME_ENERGY = "CME_ENERGY";
    public static String CME_CURRENCY = "CME_CURRENCY";
    public static String CME_METALS = "CME_METALS";
    public static String CME_WEATHER = "CME_WEATHER";
    public static String CME_EQUITY = "CME_EQUITY";
    public static String CME_INTEREST = "CME_INTEREST";
    public static String CME_AGRICULTURE = "CME_AGRICULTURE";
    public static String CME_WHEAT = "CME_WHEAT";
    public static String ICE_SUGAR11 = "ICE_SUGAR11";
    public static String ICE_SUGAR16 = "ICE_SUGAR16";
    public static String ICE_COTTON2 = "ICE_COTTON2";
    public static String ICE_COFFEE = "ICE_COFFEE";
    public static String ICE_COCOA = "ICE_COCOA";
    public static String ICE_FCOJ_A = "ICE_FCOJ_A";
    public static String ICE_GRAINS = "ICE_GRAINS";
    public static String ICE_RUSSELL = "ICE_RUSSELL";
    public static String ICE_CURRENCY = "ICE_CURRENCY";
    public static String ICE_METALS = "ICE_METALS";
    public static String ICE_ENERGY = "ICE_ENERGY";
    public static String ICE_CREDIT = "ICE_CREDIT";
    public static String JPX_TSE = "JPX_TSE";
    public static String JPX_EQUITY_INDEX_FUTURES = "JPX_EQUITY_INDEX_FUTURES";
    public static String JPX_NIKKEI_FUTURES = "JPX_NIKKEI_FUTURES";
    public static String JPX_TAIEX_FUTURES = "JPX_TAIEX_FUTURES";
    public static String JPX_JGB_FUTURES = "JPX_JGB_FUTURES";
    private int id;
    private String name;
    private String label;
    private TimeZone timeZone;
    private Calendar calendar;
    private Map regularHours = new LinkedHashMap();
    private Map extendedHours = new LinkedHashMap();
    private Map specialDays = new LinkedHashMap();
    private Map specialExtDays = new LinkedHashMap();
    private Set holidays = new HashSet();
    private boolean filterEnabled = true;
    private boolean builtIn = false;
    private List exchanges = new ArrayList();
    private boolean weekBeginSaturday = false;
    private Boolean hasSession2RTH = null;
    private Boolean hasSession2EXT = null;
    private int minutesInWeekRth = -1;
    private int minutesInWeekExt = -1;
    private static boolean unsavedChanges = false;
    private static Map directory = new LinkedHashMap();
    private static Map exchange2Hours = new HashMap();
    private static Set selectable = new TreeSet();

    public TradingHours() {
    }

    public TradingHours(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public TradingHours(String string, String string2, TimeZone timeZone) {
        this.name = string;
        this.label = string2;
        this.timeZone = timeZone;
    }

    public void setRegularHours(Enums$DayOfWeek enums$DayOfWeek, DailyHours dailyHours) {
        if (dailyHours == null || !dailyHours.isEnabled()) {
            this.regularHours.remove((Object)enums$DayOfWeek);
        } else {
            this.regularHours.put(enums$DayOfWeek, dailyHours);
        }
        this.hasSession2RTH = null;
    }

    public void addMonFriRegularHours(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setRegularHours(Enums$DayOfWeek.MON, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setRegularHours(Enums$DayOfWeek.TUES, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setRegularHours(Enums$DayOfWeek.WED, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setRegularHours(Enums$DayOfWeek.THUR, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setRegularHours(Enums$DayOfWeek.FRI, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void addMonFriRegularHours(int n2, int n3, int n4, int n5) {
        this.setRegularHours(Enums$DayOfWeek.MON, n2, n3, n4, n5);
        this.setRegularHours(Enums$DayOfWeek.TUES, n2, n3, n4, n5);
        this.setRegularHours(Enums$DayOfWeek.WED, n2, n3, n4, n5);
        this.setRegularHours(Enums$DayOfWeek.THUR, n2, n3, n4, n5);
        this.setRegularHours(Enums$DayOfWeek.FRI, n2, n3, n4, n5);
    }

    public void addMonFriExtendedHours(int n2, int n3, int n4, int n5) {
        this.setExtendedHours(Enums$DayOfWeek.MON, n2, n3, n4, n5);
        this.setExtendedHours(Enums$DayOfWeek.TUES, n2, n3, n4, n5);
        this.setExtendedHours(Enums$DayOfWeek.WED, n2, n3, n4, n5);
        this.setExtendedHours(Enums$DayOfWeek.THUR, n2, n3, n4, n5);
        this.setExtendedHours(Enums$DayOfWeek.FRI, n2, n3, n4, n5);
    }

    public void addMonFriExtendedHours(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setExtendedHours(Enums$DayOfWeek.MON, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setExtendedHours(Enums$DayOfWeek.TUES, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setExtendedHours(Enums$DayOfWeek.WED, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setExtendedHours(Enums$DayOfWeek.THUR, n2, n3, n4, n5, n6, n7, n8, n9);
        this.setExtendedHours(Enums$DayOfWeek.FRI, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    private void setRegularHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5) {
        int n6 = n2 * 60 * 60 * 1000 + n3 * 60 * 1000;
        int n7 = n4 * 60 * 60 * 1000 + n5 * 60 * 1000;
        this.setRegularHours(enums$DayOfWeek, new DailyHours(enums$DayOfWeek, n6, n7));
    }

    private void setRegularHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n2 * 60 * 60 * 1000 + n3 * 60 * 1000;
        int n11 = n4 * 60 * 60 * 1000 + n5 * 60 * 1000;
        int n12 = n6 * 60 * 60 * 1000 + n7 * 60 * 1000;
        int n13 = n8 * 60 * 60 * 1000 + n9 * 60 * 1000;
        this.setRegularHours(enums$DayOfWeek, new DailyHours(enums$DayOfWeek, n10, n11, n12, n13));
    }

    private void setExtendedHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5) {
        int n6 = n2 * 60 * 60 * 1000 + n3 * 60 * 1000;
        int n7 = n4 * 60 * 60 * 1000 + n5 * 60 * 1000;
        this.setExtendedHours(enums$DayOfWeek, new DailyHours(enums$DayOfWeek, n6, n7));
    }

    public void setExtendedHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n2 * 60 * 60 * 1000 + n3 * 60 * 1000;
        int n11 = n4 * 60 * 60 * 1000 + n5 * 60 * 1000;
        int n12 = n6 * 60 * 60 * 1000 + n7 * 60 * 1000;
        int n13 = n8 * 60 * 60 * 1000 + n9 * 60 * 1000;
        this.setExtendedHours(enums$DayOfWeek, new DailyHours(enums$DayOfWeek, n10, n11, n12, n13));
    }

    public void setExtendedHours(Enums$DayOfWeek enums$DayOfWeek, DailyHours dailyHours) {
        if (dailyHours == null || !dailyHours.isEnabled()) {
            this.extendedHours.remove((Object)enums$DayOfWeek);
        } else {
            this.extendedHours.put(enums$DayOfWeek, dailyHours);
        }
        this.hasSession2EXT = null;
    }

    public void clearExtendedHours() {
        this.extendedHours.clear();
    }

    public void clearRegularHours() {
        this.regularHours.clear();
    }

    public void addSpecialDay(long l2, DailyHours dailyHours) {
        this.specialDays.put(l2, dailyHours);
    }

    public void addSpecialExtDay(long l2, DailyHours dailyHours) {
        this.specialExtDays.put(l2, dailyHours);
    }

    public void addHoliday(long l2) {
        this.holidays.add(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHoliday(int n2, int n3, int n4) {
        Calendar calendar;
        Calendar calendar2 = calendar = this.getCalendar();
        synchronized (calendar2) {
            calendar.set(2, n2 - 1);
            calendar.set(1, n4);
            calendar.set(5, n3);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            this.addHoliday(calendar.getTimeInMillis());
        }
    }

    public DailyHours getHours(boolean bl2, Enums$DayOfWeek enums$DayOfWeek, long l2) {
        if (this.holidays.contains(l2)) {
            return null;
        }
        if (bl2) {
            DailyHours dailyHours = (DailyHours)this.specialDays.get(l2);
            if (dailyHours != null) {
                return dailyHours;
            }
            dailyHours = (DailyHours)this.regularHours.get((Object)enums$DayOfWeek);
            if (dailyHours != null) {
                return dailyHours;
            }
            return null;
        }
        DailyHours dailyHours = (DailyHours)this.specialExtDays.get(l2);
        if (dailyHours != null) {
            return dailyHours;
        }
        dailyHours = (DailyHours)this.specialDays.get(l2);
        if (dailyHours != null) {
            return dailyHours;
        }
        dailyHours = (DailyHours)this.extendedHours.get((Object)enums$DayOfWeek);
        if (dailyHours != null) {
            return dailyHours;
        }
        dailyHours = (DailyHours)this.regularHours.get((Object)enums$DayOfWeek);
        if (dailyHours != null) {
            return dailyHours;
        }
        return null;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int n2) {
        this.id = n2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void delete() {
        if (this.isBuiltIn()) {
            return;
        }
        directory.remove(this.getName());
    }

    public int getMinutesInWeek(boolean bl2) {
        if (bl2 || h.a(this.extendedHours)) {
            if (this.minutesInWeekRth > 0) {
                return this.minutesInWeekRth;
            }
            int n2 = 0;
            for (DailyHours dailyHours : this.regularHours.values()) {
                n2 += dailyHours.getMinutesInDay();
            }
            this.minutesInWeekRth = n2;
            return n2;
        }
        if (this.minutesInWeekExt > 0) {
            return this.minutesInWeekExt;
        }
        int n3 = 0;
        for (DailyHours dailyHours : this.extendedHours.values()) {
            n3 += dailyHours.getMinutesInDay();
        }
        this.minutesInWeekExt = n3;
        return n3;
    }

    public int getDaysInWeek(boolean bl2) {
        if (bl2 || h.a(this.extendedHours)) {
            return this.regularHours.size();
        }
        return this.extendedHours.size();
    }

    public DailyHours getRegularHours(Enums$DayOfWeek enums$DayOfWeek) {
        return (DailyHours)this.regularHours.get((Object)enums$DayOfWeek);
    }

    public DailyHours getHours(Enums$DayOfWeek enums$DayOfWeek, boolean bl2) {
        if (bl2) {
            return this.getRegularHours(enums$DayOfWeek);
        }
        return this.getExtendedHours(enums$DayOfWeek);
    }

    public DailyHours getHours(long l2, boolean bl2) {
        if (bl2) {
            return this.getRegularHours(l2);
        }
        return this.getExtendedHours(l2);
    }

    public DailyHours getExtendedHours(Enums$DayOfWeek enums$DayOfWeek) {
        DailyHours dailyHours = (DailyHours)this.extendedHours.get((Object)enums$DayOfWeek);
        if (dailyHours != null) {
            return dailyHours;
        }
        return this.getRegularHours(enums$DayOfWeek);
    }

    public DailyHours getExtendedHoursOnly(Enums$DayOfWeek enums$DayOfWeek) {
        DailyHours dailyHours = (DailyHours)this.extendedHours.get((Object)enums$DayOfWeek);
        if (dailyHours != null) {
            return dailyHours;
        }
        return this.getRegularHours(enums$DayOfWeek);
    }

    public DailyHours getRegularHours(long l2) {
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l3 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = (DailyHours)this.specialDays.get(l3);
        if (dailyHours2 == null && !this.holidays.contains(l3)) {
            dailyHours2 = this.getRegularHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getRegularHours(enums$DayOfWeek.nextDay())) == null) {
            if (dailyHours2 == null) {
                return null;
            }
            int n2 = (int)(l2 - l3);
            if (n2 >= dailyHours2.getEndTime()) {
                return null;
            }
            return dailyHours2;
        }
        if (dailyHours.getStartTime1() < 0 && (l3 = h.o(l3, this.timeZone)) + (long)dailyHours.getStartTime1() <= l2) {
            return dailyHours;
        }
        return dailyHours2;
    }

    public DailyHours getExtendedHours(long l2) {
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l3 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = (DailyHours)this.specialExtDays.get(l3);
        if (dailyHours2 == null && !this.holidays.contains(l3)) {
            dailyHours2 = this.getExtendedHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getExtendedHours(enums$DayOfWeek.nextDay())) == null) {
            if (dailyHours2 == null) {
                return null;
            }
            int n2 = (int)(l2 - l3);
            if (n2 >= dailyHours2.getEndTime()) {
                return null;
            }
            return dailyHours2;
        }
        if (dailyHours.getStartTime1() < 0 && (l3 = h.o(l3, this.timeZone)) + (long)dailyHours.getStartTime1() <= l2) {
            return dailyHours;
        }
        return dailyHours2;
    }

    public long calcTradingTime(long l2, long l3, boolean bl2) {
        DailyHours dailyHours;
        long l4 = l2;
        DailyHours dailyHours2 = dailyHours = bl2 ? this.getRegularHours(l2) : this.getExtendedHours(l2);
        while (l2 < l3 && dailyHours == null) {
            dailyHours = bl2 ? this.getRegularHours(l2) : this.getExtendedHours(l2 += 86400000L);
        }
        if (dailyHours == null) {
            return 0L;
        }
        if (l2 - l3 > 86400000L) {
            return 0L;
        }
        long l5 = h.a(l2, this.timeZone);
        int n2 = (int)(l2 - l5);
        if (n2 >= dailyHours.getEndTime()) {
            l5 = h.o(l5, this.timeZone);
            n2 = (int)(l2 - l5);
        }
        if (l2 > l4) {
            n2 = dailyHours.getStartTime1();
        }
        if (dailyHours.getStartTime1() < 0 && n2 >= dailyHours.getEndTime() && (n2 = (int)(l2 - (l5 = h.o(l5, this.timeZone)))) < dailyHours.getStartTime1()) {
            n2 = dailyHours.getStartTime1();
        }
        DailyHours dailyHours3 = bl2 ? this.getRegularHours(l3) : this.getExtendedHours(l3);
        long l6 = l3;
        while (l6 > l2 && dailyHours3 == null) {
            dailyHours3 = bl2 ? this.getRegularHours(l6) : this.getExtendedHours(l6 -= 86400000L);
        }
        if (dailyHours3 == null) {
            return 0L;
        }
        long l7 = h.a(l6, this.timeZone);
        int n3 = (int)(l6 - l7);
        if (n3 >= dailyHours3.getEndTime()) {
            l7 = h.o(l7, this.timeZone);
            n3 = (int)(l3 - l7);
        }
        if (l7 < l5) {
            return dailyHours.getRemainingTime(n2);
        }
        if (l7 == l5 && n3 == n2) {
            return 0L;
        }
        if (l3 - l2 <= 86400000L) {
            DailyHours dailyHours4;
            l7 = h.a(l3, this.timeZone);
            n3 = (int)(l3 - l7);
            if (n3 > dailyHours.getEndTime() && n2 < 0) {
                l7 = h.o(l3, this.timeZone);
                n3 = (int)(l3 - l7);
                if (l7 <= l5) {
                    if (n3 < n2) {
                        return 0L;
                    }
                    return dailyHours.getTradingTime(n2, n3);
                }
            }
            if (l5 + (long)dailyHours.getEndTime() >= l3) {
                return dailyHours.getTradingTime(n2, n3);
            }
            DailyHours dailyHours5 = dailyHours4 = bl2 ? this.getRegularHours(l3) : this.getExtendedHours(l3);
            if (dailyHours4 == null) {
                return dailyHours.getRemainingTime(n2);
            }
            long l8 = dailyHours.getRemainingTime(n2);
            long l9 = dailyHours4.getConsumedTime(n3);
            return l8 + l9;
        }
        long l10 = dailyHours.getRemainingTime(n2);
        l5 = h.K(l5);
        while (l5 <= l7) {
            DailyHours dailyHours6 = dailyHours = bl2 ? this.getRegularHours(l5) : this.getExtendedHours(l5);
            if (dailyHours == null) {
                l5 = h.K(l5);
                continue;
            }
            long l11 = l5 + (long)dailyHours.getEndTime();
            if (l3 < l11) {
                n3 = (int)(l3 - l7);
                return l10 + (long)dailyHours.getConsumedTime(n3);
            }
            l10 += (long)dailyHours.getTradingTime();
            l5 = h.K(l5);
        }
        return l10;
    }

    public boolean isTradeOnWeekend(boolean bl2) {
        if (bl2 && !this.hasRegularHours()) {
            bl2 = false;
        }
        if (!bl2 && !this.hasExtendedHours()) {
            bl2 = true;
        }
        if (bl2) {
            return this.regularHours.containsKey((Object)Enums$DayOfWeek.SAT) || this.regularHours.containsKey((Object)Enums$DayOfWeek.SUN);
        }
        return this.extendedHours.containsKey((Object)Enums$DayOfWeek.SAT) || this.extendedHours.containsKey((Object)Enums$DayOfWeek.SUN);
    }

    public boolean isTradeOnSaturday(boolean bl2) {
        if (bl2 && !this.hasRegularHours()) {
            bl2 = false;
        }
        if (!bl2 && !this.hasExtendedHours()) {
            bl2 = true;
        }
        if (bl2) {
            return this.regularHours.containsKey((Object)Enums$DayOfWeek.SAT);
        }
        return this.extendedHours.containsKey((Object)Enums$DayOfWeek.SAT);
    }

    public boolean isTradeOnSunday(boolean bl2) {
        if (bl2 && !this.hasRegularHours()) {
            bl2 = false;
        }
        if (!bl2 && !this.hasExtendedHours()) {
            bl2 = true;
        }
        if (bl2) {
            if (this.regularHours.containsKey((Object)Enums$DayOfWeek.SUN)) {
                return true;
            }
            DailyHours dailyHours = (DailyHours)this.regularHours.get((Object)Enums$DayOfWeek.MON);
            return dailyHours != null && dailyHours.getStartTime1() < 0;
        }
        if (this.extendedHours.containsKey((Object)Enums$DayOfWeek.SUN)) {
            return true;
        }
        DailyHours dailyHours = (DailyHours)this.extendedHours.get((Object)Enums$DayOfWeek.MON);
        return dailyHours != null && dailyHours.getStartTime1() < 0;
    }

    public boolean isTradingDay(long l2) {
        long l3;
        if (!h.a(this.holidays) && this.holidays.contains(l3 = h.a(l2, this.timeZone))) {
            return false;
        }
        DailyHours dailyHours = this.getRegularHours(this.getDayOfWeek(l2));
        return dailyHours != null;
    }

    public boolean isTradingDay(long l2, boolean bl2) {
        long l3;
        if (!h.a(this.holidays) && this.holidays.contains(l3 = h.a(l2, this.timeZone))) {
            return false;
        }
        DailyHours dailyHours = this.getHours(this.getDayOfWeek(l2), bl2);
        return dailyHours != null;
    }

    public int getMinutesInDay(boolean bl2) {
        if (h.a(this.regularHours)) {
            return 1440;
        }
        DailyHours dailyHours = (DailyHours)this.regularHours.get(this.regularHours.keySet().iterator().next());
        if (!bl2 && !h.a(this.extendedHours)) {
            dailyHours = (DailyHours)this.extendedHours.get(this.extendedHours.keySet().iterator().next());
        }
        if (dailyHours == null) {
            return 0;
        }
        return dailyHours.getMinutesInDay();
    }

    public boolean hasHours(Enums$DayOfWeek enums$DayOfWeek, boolean bl2) {
        if (bl2 || this.extendedHours.isEmpty()) {
            return this.regularHours.containsKey((Object)enums$DayOfWeek);
        }
        return this.extendedHours.containsKey((Object)enums$DayOfWeek);
    }

    public long getStartOfWeek(long l2, boolean bl2) {
        long l3 = h.i(l2, this.timeZone);
        if (this.isTradeOnSaturday(bl2)) {
            l3 = h.p(l3, this.timeZone);
        }
        return this.getStartOfDay(l3, bl2);
    }

    public long getEndOfWeek(long l2, boolean bl2) {
        long l3 = h.j(l2, this.timeZone);
        l3 = h.p(l3, this.timeZone);
        l3 = h.p(l3, this.timeZone);
        return this.getEndOfDay(l3, bl2);
    }

    public long getStartOfDay(long l2, boolean bl2) {
        long l3;
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l4 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l4 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l4 = h.o(l2, this.timeZone);
        }
        if (bl2) {
            long l5;
            Enums$DayOfWeek enums$DayOfWeek2;
            DailyHours dailyHours3;
            dailyHours2 = (DailyHours)this.specialDays.get(l4);
            if (dailyHours2 == null && !this.holidays.contains(l4)) {
                dailyHours2 = this.getRegularHours(enums$DayOfWeek);
            }
            if ((dailyHours3 = this.getRegularHours(enums$DayOfWeek2 = enums$DayOfWeek.nextDay())) != null && dailyHours3.getStartTime1() < 0 && (l5 = h.o(l2, this.timeZone) + (long)dailyHours3.getStartTime1()) <= l2) {
                return l5;
            }
            if (dailyHours2 != null) {
                return l4 + (long)dailyHours2.getStartTime1();
            }
            if (dailyHours3 != null) {
                return l4 + (long)dailyHours3.getStartTime1();
            }
            return l4;
        }
        dailyHours2 = (DailyHours)this.specialExtDays.get(l4);
        if (dailyHours2 == null && !this.holidays.contains(l4)) {
            dailyHours2 = this.getExtendedHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getExtendedHours(enums$DayOfWeek.nextDay())) != null && dailyHours.getStartTime1() < 0 && (l3 = h.o(l2, this.timeZone) + (long)dailyHours.getStartTime1()) <= l2) {
            return l3;
        }
        if (dailyHours2 != null) {
            return l4 + (long)dailyHours2.getStartTime1();
        }
        if (dailyHours != null) {
            return l4 + (long)dailyHours.getStartTime1();
        }
        return l4;
    }

    public long getStartOfDay2(long l2, boolean bl2) {
        long l3;
        if (!this.hasSession2(bl2)) {
            return -1L;
        }
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l4 = h.a(l2, this.timeZone);
        DailyHours dailyHours = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l4 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l4 = h.o(l2, this.timeZone);
        }
        if (bl2) {
            long l5;
            dailyHours = (DailyHours)this.specialDays.get(l4);
            if (dailyHours == null && !this.holidays.contains(l4)) {
                dailyHours = this.getRegularHours(enums$DayOfWeek);
            }
            DailyHours dailyHours2 = this.getRegularHours(enums$DayOfWeek.nextDay());
            if (dailyHours == null && dailyHours2 == null) {
                return -1L;
            }
            if (dailyHours2 != null && dailyHours2.getStartTime2() < 0 && dailyHours2.hasSecondaryTime() && (l5 = h.o(l2, this.timeZone) + (long)dailyHours2.getStartTime2()) <= l2) {
                return l5;
            }
            if (dailyHours != null && dailyHours.hasSecondaryTime()) {
                return l4 + (long)dailyHours.getStartTime2();
            }
            if (dailyHours2 != null && dailyHours2.hasSecondaryTime()) {
                return l4 + (long)dailyHours2.getStartTime2();
            }
            return -1L;
        }
        dailyHours = (DailyHours)this.specialExtDays.get(l4);
        if (dailyHours == null && !this.holidays.contains(l4)) {
            dailyHours = this.getExtendedHours(enums$DayOfWeek);
        }
        DailyHours dailyHours3 = this.getExtendedHours(enums$DayOfWeek.nextDay());
        if (dailyHours == null && dailyHours3 == null) {
            return -1L;
        }
        if (dailyHours3 != null && dailyHours3.getStartTime2() < 0 && dailyHours3.hasSecondaryTime() && (l3 = h.o(l2, this.timeZone) + (long)dailyHours3.getStartTime2()) <= l2) {
            return l3;
        }
        if (dailyHours != null && dailyHours.hasSecondaryTime()) {
            return l4 + (long)dailyHours.getStartTime2();
        }
        if (dailyHours3 != null && dailyHours3.hasSecondaryTime()) {
            return l4 + (long)dailyHours3.getStartTime2();
        }
        return -1L;
    }

    public long getEndOfDay1(long l2, boolean bl2) {
        long l3;
        long l4;
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l5 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l5 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l5 = h.o(l2, this.timeZone);
        }
        if (bl2) {
            long l6;
            long l7;
            DailyHours dailyHours3;
            dailyHours2 = (DailyHours)this.specialDays.get(l5);
            if (dailyHours2 == null && !this.holidays.contains(l5)) {
                dailyHours2 = this.getRegularHours(enums$DayOfWeek);
            }
            if ((dailyHours3 = this.getRegularHours(enums$DayOfWeek.nextDay())) == null) {
                if (dailyHours2 == null) {
                    return h.o(l5, this.timeZone);
                }
                return l5 + (long)dailyHours2.getEndTime1();
            }
            if (dailyHours3.getStartTime1() < 0 && (l7 = (l6 = h.o(l2, this.timeZone)) + (long)dailyHours3.getStartTime1()) <= l2) {
                return l6 + (long)dailyHours3.getEndTime1();
            }
            if (dailyHours2 == null) {
                return h.o(l5, this.timeZone);
            }
            return l5 + (long)dailyHours2.getEndTime1();
        }
        dailyHours2 = (DailyHours)this.specialExtDays.get(l5);
        if (dailyHours2 == null && !this.holidays.contains(l5)) {
            dailyHours2 = this.getExtendedHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getExtendedHours(enums$DayOfWeek.nextDay())) == null) {
            if (dailyHours2 == null) {
                return h.o(l5, this.timeZone);
            }
            return l5 + (long)dailyHours2.getEndTime1();
        }
        if (dailyHours.getStartTime1() < 0 && (l4 = (l3 = h.o(l2, this.timeZone)) + (long)dailyHours.getStartTime1()) <= l2) {
            return l3 + (long)dailyHours.getEndTime1();
        }
        if (dailyHours2 == null) {
            return h.o(l5, this.timeZone);
        }
        return l5 + (long)dailyHours2.getEndTime1();
    }

    public long getEndOfDay(long l2, boolean bl2) {
        long l3;
        long l4;
        DailyHours dailyHours;
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l5 = h.a(l2, this.timeZone);
        DailyHours dailyHours2 = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l5 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l5 = h.o(l2, this.timeZone);
        }
        if (bl2) {
            long l6;
            long l7;
            DailyHours dailyHours3;
            dailyHours2 = (DailyHours)this.specialDays.get(l5);
            if (dailyHours2 == null && !this.holidays.contains(l5)) {
                dailyHours2 = this.getRegularHours(enums$DayOfWeek);
            }
            if ((dailyHours3 = this.getRegularHours(enums$DayOfWeek.nextDay())) == null) {
                if (dailyHours2 == null) {
                    return h.o(l5, this.timeZone);
                }
                if (dailyHours2.hasSecondaryTime()) {
                    return l5 + (long)dailyHours2.getEndTime2();
                }
                return l5 + (long)dailyHours2.getEndTime1();
            }
            if (dailyHours3.getStartTime1() < 0 && (l7 = (l6 = h.o(l2, this.timeZone)) + (long)dailyHours3.getStartTime1()) <= l2) {
                if (dailyHours3.hasSecondaryTime()) {
                    return l6 + (long)dailyHours3.getEndTime2();
                }
                return l6 + (long)dailyHours3.getEndTime1();
            }
            if (dailyHours2 == null) {
                return h.o(l5, this.timeZone);
            }
            if (dailyHours2.hasSecondaryTime()) {
                return l5 + (long)dailyHours2.getEndTime2();
            }
            return l5 + (long)dailyHours2.getEndTime1();
        }
        dailyHours2 = (DailyHours)this.specialExtDays.get(l5);
        if (dailyHours2 == null && !this.holidays.contains(l5)) {
            dailyHours2 = this.getExtendedHours(enums$DayOfWeek);
        }
        if ((dailyHours = this.getExtendedHours(enums$DayOfWeek.nextDay())) == null) {
            if (dailyHours2 == null) {
                return h.o(l5, this.timeZone);
            }
            if (dailyHours2.hasSecondaryTime()) {
                return l5 + (long)dailyHours2.getEndTime2();
            }
            return l5 + (long)dailyHours2.getEndTime1();
        }
        if (dailyHours.getStartTime1() < 0 && (l4 = (l3 = h.o(l2, this.timeZone)) + (long)dailyHours.getStartTime1()) <= l2) {
            if (dailyHours.hasSecondaryTime()) {
                return l3 + (long)dailyHours.getEndTime2();
            }
            return l3 + (long)dailyHours.getEndTime1();
        }
        if (dailyHours2 == null) {
            return h.o(l5, this.timeZone);
        }
        if (dailyHours2.hasSecondaryTime()) {
            return l5 + (long)dailyHours2.getEndTime2();
        }
        return l5 + (long)dailyHours2.getEndTime1();
    }

    public long getEndOfDay2(long l2, boolean bl2) {
        long l3;
        if (!this.hasSession2(bl2)) {
            return -1L;
        }
        Enums$DayOfWeek enums$DayOfWeek = h.a(this.getCalendar(), l2);
        long l4 = h.a(l2, this.timeZone);
        DailyHours dailyHours = null;
        if (enums$DayOfWeek == Enums$DayOfWeek.SAT && !this.hasHours(Enums$DayOfWeek.SAT, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.FRI;
            l4 -= 86400000L;
        } else if (enums$DayOfWeek == Enums$DayOfWeek.SUN && !this.hasHours(Enums$DayOfWeek.SUN, bl2)) {
            enums$DayOfWeek = Enums$DayOfWeek.MON;
            l4 = h.o(l2, this.timeZone);
        }
        if (bl2) {
            long l5;
            dailyHours = (DailyHours)this.specialDays.get(l4);
            if (dailyHours == null && !this.holidays.contains(l4)) {
                dailyHours = this.getRegularHours(enums$DayOfWeek);
            }
            DailyHours dailyHours2 = this.getRegularHours(enums$DayOfWeek.nextDay());
            if (dailyHours == null && dailyHours2 == null) {
                return -1L;
            }
            if (dailyHours2 != null && dailyHours2.getEndTime2() < 0 && dailyHours2.hasSecondaryTime() && (l5 = h.o(l2, this.timeZone) + (long)dailyHours2.getEndTime2()) >= l2) {
                return l5;
            }
            if (dailyHours != null && dailyHours.hasSecondaryTime()) {
                return l4 + (long)dailyHours.getEndTime2();
            }
            if (dailyHours2 != null && dailyHours2.hasSecondaryTime()) {
                return l4 + (long)dailyHours2.getEndTime2();
            }
            return -1L;
        }
        dailyHours = (DailyHours)this.specialExtDays.get(l4);
        if (dailyHours == null && !this.holidays.contains(l4)) {
            dailyHours = this.getExtendedHours(enums$DayOfWeek);
        }
        DailyHours dailyHours3 = this.getExtendedHours(enums$DayOfWeek.nextDay());
        if (dailyHours == null && dailyHours3 == null) {
            return -1L;
        }
        if (dailyHours3 != null && dailyHours3.getEndTime2() < 0 && dailyHours3.hasSecondaryTime() && (l3 = h.o(l2, this.timeZone) + (long)dailyHours3.getEndTime2()) >= l2) {
            return l3;
        }
        if (dailyHours != null && dailyHours.hasSecondaryTime()) {
            return l4 + (long)dailyHours.getEndTime2();
        }
        if (dailyHours3 != null && dailyHours3.hasSecondaryTime()) {
            return l4 + (long)dailyHours3.getEndTime2();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enums$DayOfWeek getDayOfWeek(long l2) {
        Calendar calendar;
        Calendar calendar2 = calendar = this.getCalendar();
        synchronized (calendar2) {
            calendar.setTimeInMillis(l2);
            return this.convert(calendar.get(7));
        }
    }

    public Calendar getCalendar() {
        if (this.calendar != null) {
            return this.calendar;
        }
        this.calendar = h.a(this.timeZone);
        return this.calendar;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilterEnabled(boolean bl2) {
        this.filterEnabled = bl2;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public void setBuiltIn(boolean bl2) {
        this.builtIn = bl2;
    }

    public boolean hasRegularHours() {
        return !h.a(this.regularHours);
    }

    public boolean hasExtendedHours() {
        return !h.a(this.extendedHours);
    }

    public List getExchanges() {
        return this.exchanges;
    }

    public void addExchange(String string) {
        this.exchanges.add(string);
    }

    public boolean isWeekBeginSaturday() {
        return this.weekBeginSaturday;
    }

    public void setWeekBeginSaturday(boolean bl2) {
        this.weekBeginSaturday = bl2;
    }

    public int calculateTradingDays(long l2, long l3) {
        return 0;
    }

    @Override
    public List getNVPs() {
        List list = h.b(new String[]{this.b("name", this.name), this.b("label", this.label), this.a("exchanges", (Collection)this.exchanges), this.a("timeZone", (Object)this.timeZone), this.a("filterEnabled", this.filterEnabled), this.a("weekSaturday", this.weekBeginSaturday, false), this.a("regularHours", this.regularHours.values()), this.a("extHours", this.extendedHours.values())});
        return list;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        DailyHours dailyHours;
        this.name = jSONObject.str("name");
        this.label = jSONObject.str("label");
        this.exchanges.clear();
        if (jSONObject.has("exchange")) {
            this.exchanges.add(jSONObject.str("exchange"));
        } else if (jSONObject.has("exchanges")) {
            for (Object object : jSONObject.getStringList("exchanges")) {
                this.exchanges.add(object);
            }
        }
        this.timeZone = jSONObject.has("timeZone") ? TimeZone.getTimeZone(jSONObject.str("timeZone")) : TimeZone.getDefault();
        this.filterEnabled = jSONObject.is("filterEnabled");
        this.weekBeginSaturday = jSONObject.is("weekSaturday", false);
        this.regularHours.clear();
        for (Object object : jSONObject.getObjList("regularHours")) {
            dailyHours = new DailyHours((JSONObject)object);
            this.regularHours.put(dailyHours.getDayOfWeek(), dailyHours);
        }
        this.extendedHours.clear();
        for (Object object : jSONObject.getObjList("extHours")) {
            dailyHours = new DailyHours((JSONObject)object);
            this.extendedHours.put(dailyHours.getDayOfWeek(), dailyHours);
        }
    }

    public void read(Element element) {
        DailyHours dailyHours;
        Node node;
        this.name = element.getAttribute("id");
        this.label = element.getAttribute("name");
        this.timeZone = TimeZone.getTimeZone(element.getAttribute("timezone"));
        this.exchanges.add(element.getAttribute("exchange"));
        String string = element.getAttribute("weekSaturday");
        if (!h.g(string)) {
            this.weekBeginSaturday = h.a((Object)string);
        }
        if ((node = g.b("regular_hours", element)) != null) {
            for (Element element2 : g.c("hours", node)) {
                dailyHours = new DailyHours(Enums$DayOfWeek.valueOf(element2.getAttribute("day")), h.b(element2.getAttribute("start1")), h.b(element2.getAttribute("end1")), h.b(element2.getAttribute("start2")), h.b(element2.getAttribute("end2")));
                this.regularHours.put(dailyHours.getDayOfWeek(), dailyHours);
            }
        }
        if ((node = g.b("extended_hours", element)) != null) {
            for (Element element2 : g.c("hours", node)) {
                dailyHours = new DailyHours(Enums$DayOfWeek.valueOf(element2.getAttribute("day")), h.b(element2.getAttribute("start1")), h.b(element2.getAttribute("end1")), h.b(element2.getAttribute("start2")), h.b(element2.getAttribute("end2")));
                this.extendedHours.put(dailyHours.getDayOfWeek(), dailyHours);
            }
        }
    }

    public void read(String string) {
        this.read(g.a(string).getDocumentElement());
    }

    private Enums$DayOfWeek convert(int n2) {
        switch (n2) {
            case 1: {
                return Enums$DayOfWeek.SUN;
            }
            case 2: {
                return Enums$DayOfWeek.MON;
            }
            case 3: {
                return Enums$DayOfWeek.TUES;
            }
            case 4: {
                return Enums$DayOfWeek.WED;
            }
            case 5: {
                return Enums$DayOfWeek.THUR;
            }
            case 6: {
                return Enums$DayOfWeek.FRI;
            }
            case 7: {
                return Enums$DayOfWeek.SAT;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            DailyHours dailyHours;
            DailyHours dailyHours2;
            TradingHours tradingHours = (TradingHours)object;
            if (!h.a((Object)this.name, (Object)tradingHours.name)) {
                return false;
            }
            if (!h.a((Object)this.label, (Object)tradingHours.label)) {
                return false;
            }
            if (!h.a((Object)this.timeZone, (Object)tradingHours.timeZone)) {
                return false;
            }
            if (!h.c(this.exchanges, tradingHours.exchanges)) {
                return false;
            }
            if (this.builtIn != tradingHours.builtIn) {
                return false;
            }
            if (this.filterEnabled != tradingHours.filterEnabled) {
                return false;
            }
            if (this.regularHours.size() != tradingHours.regularHours.size()) {
                return false;
            }
            if (this.extendedHours.size() != tradingHours.extendedHours.size()) {
                return false;
            }
            if (this.specialDays.size() != tradingHours.specialDays.size()) {
                return false;
            }
            if (this.specialExtDays.size() != tradingHours.specialExtDays.size()) {
                return false;
            }
            if (this.holidays.size() != tradingHours.holidays.size()) {
                return false;
            }
            for (Object object2 : this.regularHours.keySet()) {
                dailyHours2 = (DailyHours)this.regularHours.get(object2);
                if (h.a((Object)dailyHours2, (Object)(dailyHours = (DailyHours)tradingHours.regularHours.get(object2)))) continue;
                return false;
            }
            for (Object object2 : this.extendedHours.keySet()) {
                dailyHours2 = (DailyHours)this.extendedHours.get(object2);
                if (h.a((Object)dailyHours2, (Object)(dailyHours = (DailyHours)tradingHours.extendedHours.get(object2)))) continue;
                return false;
            }
            for (Object object2 : this.specialDays.keySet()) {
                dailyHours2 = (DailyHours)this.specialDays.get(object2);
                if (h.a((Object)dailyHours2, (Object)(dailyHours = (DailyHours)tradingHours.specialDays.get(object2)))) continue;
                return false;
            }
            for (Object object2 : this.specialExtDays.keySet()) {
                dailyHours2 = (DailyHours)this.specialExtDays.get(object2);
                if (h.a((Object)dailyHours2, (Object)(dailyHours = (DailyHours)tradingHours.specialExtDays.get(object2)))) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public TradingHours clone() {
        TradingHours tradingHours = (TradingHours)super.clone();
        Map<Enums$DayOfWeek, DailyHours> map = Collections.synchronizedMap(new HashMap());
        for (Enums$DayOfWeek enums$DayOfWeek : this.regularHours.keySet()) {
            map.put(enums$DayOfWeek, ((DailyHours)this.regularHours.get((Object)enums$DayOfWeek)).clone());
        }
        tradingHours.regularHours = map;
        map = Collections.synchronizedMap(new HashMap());
        for (Enums$DayOfWeek enums$DayOfWeek : this.extendedHours.keySet()) {
            map.put(enums$DayOfWeek, ((DailyHours)this.extendedHours.get((Object)enums$DayOfWeek)).clone());
        }
        tradingHours.extendedHours = map;
        tradingHours.exchanges = new ArrayList(this.exchanges);
        return tradingHours;
    }

    public boolean hasSession2(boolean bl2) {
        return bl2 ? this.hasSession2RTH() : this.hasSession2EXT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession2RTH() {
        if (this.hasSession2RTH != null) {
            return this.hasSession2RTH;
        }
        TradingHours tradingHours = this;
        synchronized (tradingHours) {
            boolean bl2 = false;
            for (DailyHours dailyHours : this.regularHours.values()) {
                if (!dailyHours.hasSecondaryTime()) continue;
                bl2 = true;
                break;
            }
            this.hasSession2RTH = bl2;
            return this.hasSession2RTH;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession2EXT() {
        if (this.hasSession2EXT != null) {
            return this.hasSession2EXT;
        }
        TradingHours tradingHours = this;
        synchronized (tradingHours) {
            boolean bl2 = false;
            for (DailyHours dailyHours : this.extendedHours.values()) {
                if (!dailyHours.hasSecondaryTime()) continue;
                bl2 = true;
                break;
            }
            this.hasSession2EXT = bl2;
            return this.hasSession2EXT;
        }
    }

    public static void saveAll(File file) {
        ArrayList<TradingHours> arrayList = new ArrayList<TradingHours>();
        for (TradingHours tradingHours : directory.values()) {
            if (tradingHours == null || tradingHours.isBuiltIn()) continue;
            arrayList.add(tradingHours);
        }
        h.a(new File(file, "trading_hours.json"), new ar().b(arrayList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getNames() {
        Map map = directory;
        synchronized (map) {
            return new ArrayList(directory.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll() {
        Map map = directory;
        synchronized (map) {
            return new ArrayList(directory.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSelectableNames() {
        Map map = directory;
        synchronized (map) {
            return new ArrayList(selectable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TradingHours get(String string) {
        Map map = directory;
        synchronized (map) {
            return (TradingHours)directory.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TradingHours getByExchange(String string) {
        Map map = exchange2Hours;
        synchronized (map) {
            List list = (List)exchange2Hours.get(string);
            if (h.a((Collection)list)) {
                return null;
            }
            if (list.size() == 1) {
                return (TradingHours)list.get(0);
            }
            for (TradingHours tradingHours : list) {
                if (tradingHours.isBuiltIn()) continue;
                return tradingHours;
            }
            return (TradingHours)list.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(TradingHours tradingHours) {
        Map map = directory;
        synchronized (map) {
            directory.put(tradingHours.getName(), tradingHours);
            selectable.add(tradingHours.getName());
        }
        if (!h.a((Collection)tradingHours.getExchanges())) {
            map = exchange2Hours;
            synchronized (map) {
                for (String string : tradingHours.getExchanges()) {
                    ArrayList<TradingHours> arrayList = (ArrayList<TradingHours>)exchange2Hours.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<TradingHours>();
                        exchange2Hours.put(string, arrayList);
                    }
                    if (arrayList.contains(tradingHours)) continue;
                    arrayList.add(tradingHours);
                }
            }
        }
        unsavedChanges = true;
    }

    public static void update(TradingHours tradingHours) {
        unsavedChanges = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map map = directory;
        synchronized (map) {
            for (String string : new ArrayList(directory.keySet())) {
                TradingHours tradingHours = (TradingHours)directory.get(string);
                if (tradingHours.isBuiltIn()) continue;
                directory.remove(string);
                selectable.remove(string);
                for (String string2 : tradingHours.getExchanges()) {
                    exchange2Hours.remove(string2);
                }
            }
        }
        unsavedChanges = true;
    }

    public static void saveAll() {
        if (!unsavedChanges) {
            return;
        }
        TradingHours.saveAll(Workspace.findDir("trading_hours"));
        unsavedChanges = false;
    }

    public static void initFutures() {
        TradingHours tradingHours = new TradingHours(CME_ENERGY, ai.a("TH_CME_ENERGY", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 30, 17, 0);
        tradingHours.addMonFriExtendedHours(-6, 0, 17, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(CME_CURRENCY, ai.a("TH_CME_CURRENCY", new Object[0]), h.a);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(-7, 0, 16, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(CME_METALS, ai.a("TH_CME_METALS", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 30, 17, 0);
        tradingHours.addMonFriExtendedHours(-6, 0, 17, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(CME_WEATHER, ai.a("TH_CME_WEATHER", new Object[0]), h.a);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(8, 30, 15, 15);
        tradingHours.addMonFriExtendedHours(-7, 0, 15, 15);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(CME_INTEREST, ai.a("TH_CME_INTEREST", new Object[0]), h.a);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(7, 20, 14, 0);
        tradingHours.addMonFriExtendedHours(-7, 0, 16, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(CME_EQUITY, ai.a("TH_CME_EQUITY", new Object[0]), h.a);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(8, 30, 15, 15);
        tradingHours.addMonFriExtendedHours(-7, 0, 15, 15, 15, 30, 16, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(CME_AGRICULTURE, ai.a("TH_CME_AGRICULTURE", new Object[0]), h.a);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(8, 30, 14, 30);
        tradingHours.addMonFriExtendedHours(-7, 0, 16, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(CME_WHEAT, ai.a("TH_CME_WHEAT", new Object[0]), h.a);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(8, 30, 13, 15);
        tradingHours.addMonFriExtendedHours(-7, 0, 7, 45, 8, 30, 13, 20);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_SUGAR11, ai.a("TH_ICE_SUGAR11", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(3, 30, 13, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_SUGAR16, ai.a("TH_ICE_SUGAR16", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 0, 13, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_COTTON2, ai.a("TH_ICE_COTTON2", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(-3, 0, 14, 20);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_COCOA, ai.a("TH_ICE_COCOA", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(4, 45, 13, 30);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_COFFEE, ai.a("TH_ICE_COFFEE", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(4, 15, 13, 30);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_FCOJ_A, ai.a("TH_ICE_FCOJ_A", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(8, 0, 14, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_GRAINS, ai.a("TH_ICE_GRAINS", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(-4, 0, 14, 30);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, 0, 14, 30);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_RUSSELL, ai.a("TH_ICE_RUSSELL", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(-4, 0, 18, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, 0, 18, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_CURRENCY, ai.a("TH_ICE_CURRENCY", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(-4, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, 0, 17, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_METALS, ai.a("TH_ICE_METALS", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(-4, 0, 18, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, 0, 18, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_ENERGY, ai.a("TH_ICE_ENERGY", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(-5, 50, 18, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 50, 18, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ICE_CREDIT, ai.a("TH_ICE_CREDIT", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(2, 0, 18, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(JPX_EQUITY_INDEX_FUTURES, ai.a("TH_JPX_EQUITY_INDEX_FUTURES", new Object[0]), TimeZone.getTimeZone("JST"));
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(8, 45, 15, 15);
        tradingHours.addMonFriExtendedHours(-7, -30, 5, 30, 8, 45, 15, 15);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(JPX_NIKKEI_FUTURES, ai.a("TH_JPX_NIKKEI_FUTURES", new Object[0]), TimeZone.getTimeZone("JST"));
        tradingHours.addExchange("OSE.JPN");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 0, 15, 15);
        tradingHours.addMonFriExtendedHours(9, 0, 15, 15, 16, 30, 19, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(JPX_TAIEX_FUTURES, ai.a("TH_JPX_TAIEX_FUTURES", new Object[0]), TimeZone.getTimeZone("JST"));
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(8, 45, 15, 15);
        TradingHours.register(tradingHours);
    }

    public static void initFXCM() {
        TradingHours tradingHours = new TradingHours(FXCM, ai.a("TH_FXCM", new Object[0]), h.b);
        tradingHours.setBuiltIn(true);
        tradingHours.setFilterEnabled(false);
        tradingHours.setRegularHours(Enums$DayOfWeek.MON, -9, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
        tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
        TradingHours.register(tradingHours);
    }

    public static void initStocks() {
        TradingHours tradingHours = new TradingHours(NASDAQ, ai.a("TH_NASDAQ", new Object[0]), h.b);
        tradingHours.addExchange("NASDAQ");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(7, 0, 20, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(NYSE, ai.a("TH_NYSE", new Object[0]), h.b);
        tradingHours.addExchange("NYSE");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(4, 0, 20, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(TSX, ai.a("TH_TSX", new Object[0]), h.b);
        tradingHours.addExchange("TSX");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(9, 0, 17, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(OTC, ai.a("TH_OTC", new Object[0]), h.b);
        tradingHours.addExchange("OTC");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 30, 16, 0);
        tradingHours.addMonFriExtendedHours(6, 0, 17, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(CHX, ai.a("TH_CHX", new Object[0]), h.a);
        tradingHours.addExchange("CHX");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(8, 30, 15, 0);
        tradingHours.addMonFriExtendedHours(8, 30, 16, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(XETRA, ai.a("TH_XETRA", new Object[0]), TimeZone.getTimeZone("Europe/Berlin"));
        tradingHours.addExchange("XETRA");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 0, 17, 30);
        tradingHours.addMonFriExtendedHours(8, 0, 20, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(ASX, ai.a("TH_ASX", new Object[0]), TimeZone.getTimeZone("Australia/Sydney"));
        tradingHours.addExchange("ASX");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(10, 0, 16, 0);
        tradingHours.addMonFriExtendedHours(7, 0, 16, 12);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(NSE, ai.a("TH_NSE", new Object[0]), h.c);
        tradingHours.addExchange("NSE");
        tradingHours.addExchange("NSE_IDX");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 15, 15, 30);
        tradingHours.addMonFriExtendedHours(9, 0, 16, 0);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(MCX, ai.a("TH_MCX", new Object[0]), h.c);
        tradingHours.addExchange("MCX");
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(10, 0, 23, 55);
        TradingHours.register(tradingHours);
        tradingHours = new TradingHours(JPX_TSE, ai.a("TH_JPX_TSE", new Object[0]), TimeZone.getTimeZone("JST"));
        tradingHours.setBuiltIn(true);
        tradingHours.addMonFriRegularHours(9, 0, 11, 30, 12, 30, 15, 0);
        TradingHours.register(tradingHours);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDefaults() {
        Map map = directory;
        synchronized (map) {
            TradingHours tradingHours;
            directory.clear();
            if (ae.a(Enums$InstrumentType.STOCK)) {
                TradingHours.initStocks();
            }
            if (ae.d() || ae.l() || ae.m() || ae.n()) {
                TradingHours.initFXCM();
            }
            if (ae.j()) {
                tradingHours = new TradingHours(TS_FOREX, ai.a("TH_TS_FOREX", new Object[0]), h.b);
                tradingHours.setBuiltIn(true);
                tradingHours.setFilterEnabled(false);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
                TradingHours.register(tradingHours);
            }
            if (ae.k()) {
                tradingHours = new TradingHours(MB_FOREX, ai.a("TH_MB_FOREX", new Object[0]), h.b);
                tradingHours.setBuiltIn(true);
                tradingHours.setFilterEnabled(false);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
                TradingHours.register(tradingHours);
            }
            if (ae.f()) {
                tradingHours = new TradingHours(OANDA, ai.a("TH_OANDA", new Object[0]), h.b);
                tradingHours.setBuiltIn(true);
                tradingHours.setFilterEnabled(true);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
                TradingHours.register(tradingHours);
            }
            if (ae.e() || ae.g() || ae.l() || ae.m() || ae.n()) {
                tradingHours = new TradingHours(FOREX, ai.a("TH_FOREX", new Object[0]), h.b);
                tradingHours.setBuiltIn(true);
                tradingHours.setFilterEnabled(true);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -7, 0, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -7, 0, 17, 0);
                TradingHours.register(tradingHours);
            }
            if (ae.h()) {
                tradingHours = new TradingHours(IB_FOREX, ai.a("TH_IB_FOREX", new Object[0]), h.b);
                tradingHours.setBuiltIn(true);
                tradingHours.setFilterEnabled(false);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, -6, -45, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, -6, -45, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, -6, -45, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, -6, -45, 17, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, -6, -45, 17, 0);
                directory.put(tradingHours.getName(), tradingHours);
            }
            if (ae.a(Enums$InstrumentType.FUTURE)) {
                TradingHours.initFutures();
            }
            if (ae.a(Enums$InstrumentType.CRYPTO_CURRENCY)) {
                tradingHours = new TradingHours(CRYPTO, ai.a("TH_CRYPTO_CURRENCY", new Object[0]), h.b);
                tradingHours.setBuiltIn(true);
                tradingHours.setRegularHours(Enums$DayOfWeek.SUN, 0, 0, 24, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.MON, 0, 0, 24, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.TUES, 0, 0, 24, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.WED, 0, 0, 24, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.THUR, 0, 0, 24, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.FRI, 0, 0, 24, 0);
                tradingHours.setRegularHours(Enums$DayOfWeek.SAT, 0, 0, 24, 0);
                TradingHours.register(tradingHours);
            }
        }
    }

    public static void load() {
        TradingHours.loadDefaults();
        File file = Workspace.findFile("trading_hours");
        if (file != null) {
            TradingHours.read(file);
            return;
        }
        if (!Workspace.hasDB()) {
            return;
        }
        try {
            b b2 = CommandFactory.createCmd("LOAD_TRADING_HOURS");
            List list = (List)b2.a();
            if (h.a((Collection)list)) {
                return;
            }
            for (TradingHours tradingHours : list) {
                TradingHours.register(tradingHours);
            }
        }
        catch (MWException mWException) {
            mWException.printStackTrace();
        }
    }

    private static void read(File file) {
        String string = h.a(file);
        if (h.g(string)) {
            unsavedChanges = false;
            return;
        }
        try {
            ArrayList<TradingHours> arrayList = new ArrayList<TradingHours>();
            boolean bl2 = q.a(string);
            if (bl2) {
                for (JSONObject object : new JSONArray(string).asObjList()) {
                    arrayList.add(new TradingHours(object));
                }
            } else {
                for (Element element : g.c("trading_hours", g.a(string))) {
                    TradingHours tradingHours = new TradingHours();
                    tradingHours.read(element);
                    arrayList.add(tradingHours);
                }
            }
            for (TradingHours tradingHours : arrayList) {
                TradingHours.register(tradingHours);
            }
            if (bl2) {
                unsavedChanges = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

