/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.command.b;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.a;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.TradeHistory;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.aq;
import com.motivewave.platform.service.ae;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import k.f;
import q.j;

public class TradeHistoryDirectory {
    private static Map positionID2History = new HashMap();
    private static List allActive = new ArrayList();
    private static List all = new ArrayList();
    private static f listeners = new f();
    private static InstrumentListener instrListener = new aq();
    private static boolean unsavedChanges = false;

    public static void save() {
        if (!unsavedChanges) {
            return;
        }
        unsavedChanges = false;
        File file = Workspace.findDir("trade_history");
        try {
            long l2 = System.currentTimeMillis();
            PrintWriter printWriter = new PrintWriter(new File(file, "trade_history.csv"));
            int n2 = 1;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (TradeHistory tradeHistory : all) {
                n2 = TradeHistory.addIds(tradeHistory, linkedHashMap, n2);
            }
            a.a(printWriter, linkedHashMap);
            for (TradeHistory tradeHistory : all) {
                TradeHistory.toCSV(tradeHistory, linkedHashMap, printWriter);
            }
            printWriter.flush();
            printWriter.close();
            long l3 = System.currentTimeMillis() - l2;
            h.a.info("TradeHistoryDirectory::write() wrote: " + all.size() + " records elapsed time: " + l3 + " ms");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void load() {
        ArrayList<TradeHistory> arrayList = new ArrayList<TradeHistory>();
        File file = new File(ae.a().getConfigDir(), "trade_history.csv");
        if (!file.exists() && Workspace.hasDB()) {
            try {
                b b2 = CommandFactory.createCmd("LOAD_TRADE_HISTORY");
                List list = (List)b2.a();
                if (!h.a((Collection)list)) {
                    arrayList.addAll(list);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            unsavedChanges = true;
        } else {
            if (!file.exists()) {
                unsavedChanges = false;
                return;
            }
            long l2 = System.currentTimeMillis();
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                if (string != null) {
                    Map map = a.a(string);
                    if (map != null) {
                        string = bufferedReader.readLine();
                    }
                    while (string != null) {
                        TradeHistory tradeHistory = TradeHistory.fromCSV(string, map);
                        if (tradeHistory != null) {
                            arrayList.add(tradeHistory);
                        }
                        string = bufferedReader.readLine();
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l3 = System.currentTimeMillis() - l2;
            h.a.info("TradeHistoryDirectory::read() read: " + arrayList.size() + " records elapsed time: " + l3 + " ms");
            unsavedChanges = false;
        }
        all = arrayList;
    }

    public static TradeHistory register(MWInstrument mWInstrument, String string, String string2, String string3, String string4, String string5, String string6, long l2, String string7, Enums$OrderAction enums$OrderAction, float f2, float f3, double d2, boolean bl2, double d3) {
        return TradeHistoryDirectory.register(mWInstrument, string, string2, string3, string4, string5, string6, l2, string7, enums$OrderAction, f2, f3, d2, bl2, d3, 0.0);
    }

    public static TradeHistory register(MWInstrument mWInstrument, String string, String string2, String string3, String string4, String string5, String string6, long l2, String string7, Enums$OrderAction enums$OrderAction, float f2, float f3, double d2, boolean bl2, double d3, double d4) {
        if (mWInstrument == null) {
            h.a.severe("TradeHistoryDirectory::register() instrument is null! orderId: " + string6);
            return null;
        }
        TradeHistory tradeHistory = TradeHistoryDirectory.find(mWInstrument, string3, string);
        if (tradeHistory != null) {
            return tradeHistory;
        }
        tradeHistory = new TradeHistory(LiveTicker.get(mWInstrument), string, string2, string3, string4, string5, string6, l2, string7, enums$OrderAction, f2, f3, bl2, d3, d2, d4);
        TradeHistoryDirectory.create(tradeHistory);
        TradeHistoryDirectory.registerNoCreate(tradeHistory);
        if (!h.g(string5)) {
            for (TradeHistory tradeHistory2 : TradeHistoryDirectory.getByPosition(string5)) {
                tradeHistory2.updateInfo();
            }
        }
        return tradeHistory;
    }

    static TradeHistory register(String string, String string2, MWOrder mWOrder, boolean bl2, float f2, float f3, double d2) {
        if (mWOrder.getInstrument() == null) {
            h.a.severe("TradeHistory::register() order instrument is null! " + mWOrder);
            return null;
        }
        TradeHistory tradeHistory = TradeHistoryDirectory.find(mWOrder.getInstrument(), mWOrder.getAccountID(), string);
        if (tradeHistory != null) {
            return tradeHistory;
        }
        long l2 = mWOrder.getLastFillTime();
        if (l2 == 0L) {
            l2 = ae.a();
        }
        tradeHistory = new TradeHistory(mWOrder.getTicker(), string, null, mWOrder.getAccountID(), null, string2, mWOrder.getOrderId(), l2, mWOrder.getInstrument().getExchange(), mWOrder.getAction(), f2, f3, bl2, d2, mWOrder.getCommission() * (double)Math.abs(f2) / (double)Math.abs(mWOrder.getFilled()), 0.0);
        tradeHistory.updateInfo();
        TradeHistoryDirectory.create(tradeHistory);
        TradeHistoryDirectory.registerNoCreate(tradeHistory);
        for (TradeHistory tradeHistory2 : TradeHistoryDirectory.getByPosition(string2)) {
            tradeHistory2.updateInfo();
        }
        return tradeHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void create(TradeHistory tradeHistory) {
        if (tradeHistory == null) {
            return;
        }
        List list = all;
        synchronized (list) {
            if (!all.contains(tradeHistory)) {
                all.add(tradeHistory);
                unsavedChanges = true;
            }
        }
    }

    public static void update(TradeHistory tradeHistory) {
        unsavedChanges = true;
    }

    public static void register(List list) {
        for (Object object : list) {
            TradeHistoryDirectory._register((TradeHistory)object);
        }
        for (Object object : list) {
            ((TradeHistory)object).updateInfo();
        }
        for (Object object : listeners.a()) {
            try {
                object.d_(list);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void registerNoCreate(TradeHistory tradeHistory) {
        if (tradeHistory == null) {
            return;
        }
        TradeHistoryDirectory._register(tradeHistory);
        tradeHistory.updateInfo();
        TradeHistoryDirectory.notifyCreated(tradeHistory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _register(TradeHistory tradeHistory) {
        try {
            List list = allActive;
            synchronized (list) {
                if (allActive.contains(tradeHistory)) {
                    allActive.remove(tradeHistory);
                }
                allActive.add(tradeHistory);
                if (tradeHistory.getInstrument() != null) {
                    tradeHistory.getInstrument().addListener(instrListener);
                }
                if (h.g(tradeHistory.getPositionId())) {
                    return;
                }
                ArrayList<TradeHistory> arrayList = (ArrayList<TradeHistory>)positionID2History.get(tradeHistory.getPositionId());
                if (arrayList == null) {
                    arrayList = new ArrayList<TradeHistory>();
                    positionID2History.put(tradeHistory.getPositionId(), arrayList);
                } else if (!h.a((Collection)arrayList)) {
                    TradeHistory tradeHistory2;
                    arrayList.remove(tradeHistory);
                    if (arrayList.size() > 0 && (tradeHistory2 = (TradeHistory)arrayList.get(0)).equals(tradeHistory)) {
                        tradeHistory2.setLinkedTrade(tradeHistory);
                        tradeHistory.setLinkedTrade(tradeHistory2);
                    }
                }
                arrayList.add(tradeHistory);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getByPosition(String string) {
        List list = allActive;
        synchronized (list) {
            List list2 = (List)positionID2History.get(string);
            return list2 == null ? new ArrayList() : new ArrayList(list2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TradeHistory findByOrderId(String string) {
        List list = allActive;
        synchronized (list) {
            for (TradeHistory tradeHistory : new ArrayList(allActive)) {
                if (!h.a((Object)tradeHistory.getOrderId(), (Object)string)) continue;
                return tradeHistory;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List loadByUserId(String string) {
        List list = all;
        synchronized (list) {
            ArrayList<TradeHistory> arrayList = new ArrayList<TradeHistory>();
            for (TradeHistory tradeHistory : all) {
                if (!h.g(string) && !h.a((Object)tradeHistory.getUserId(), (Object)string)) continue;
                arrayList.add(tradeHistory);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List loadByAccount(Account account) {
        List list = all;
        synchronized (list) {
            ArrayList<TradeHistory> arrayList = new ArrayList<TradeHistory>();
            for (TradeHistory tradeHistory : all) {
                if (account != null && !account.isAccount(tradeHistory.getAccountId())) continue;
                arrayList.add(tradeHistory);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearByAccount(Account account) {
        List list = allActive;
        synchronized (list) {
            for (TradeHistory tradeHistory : new ArrayList(allActive)) {
                if (!account.isAccount(tradeHistory.getAccountId())) continue;
                allActive.remove(tradeHistory);
                positionID2History.remove(tradeHistory.getPositionId());
                tradeHistory.destroy();
            }
        }
        TradeHistoryDirectory.notifyCleared(account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearByUserId(String string) {
        if (h.g(string)) {
            return;
        }
        List list = allActive;
        synchronized (list) {
            for (TradeHistory tradeHistory : new ArrayList(allActive)) {
                if (!h.a((Object)tradeHistory.getUserId(), (Object)string)) continue;
                allActive.remove(tradeHistory);
                positionID2History.remove(tradeHistory.getPositionId());
                tradeHistory.destroy();
            }
        }
        TradeHistoryDirectory.notifyCleared(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAll() {
        List list = all;
        synchronized (list) {
            for (TradeHistory tradeHistory : all) {
                tradeHistory.destroy();
            }
            all.clear();
            allActive.clear();
            positionID2History.clear();
            unsavedChanges = true;
        }
        TradeHistoryDirectory.notifyCleared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(Account account) {
        if (account == null) {
            return;
        }
        List list = all;
        synchronized (list) {
            for (TradeHistory tradeHistory : new ArrayList(all)) {
                if (!account.isAccount(tradeHistory.getAccountId())) continue;
                all.remove(tradeHistory);
            }
        }
        unsavedChanges = true;
        TradeHistoryDirectory.clearByAccount(account);
    }

    public static void addListener(j j2) {
        listeners.a(j2);
    }

    public static void removeListener(j j2) {
        listeners.a(j2);
    }

    public static List getAllValid() {
        List list = TradeHistoryDirectory.getAll();
        for (TradeHistory tradeHistory : new ArrayList(list)) {
            if (tradeHistory.getAccount() != null) continue;
            list.remove(tradeHistory);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TradeHistory getLatest(Enums$ServiceType enums$ServiceType) {
        List list = allActive;
        synchronized (list) {
            if (h.a((Collection)allActive)) {
                return null;
            }
            for (TradeHistory tradeHistory : allActive) {
                if (tradeHistory.getInstrument().getSourceType() != enums$ServiceType) continue;
                return tradeHistory;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getByInstrument(MWInstrument mWInstrument) {
        List list = allActive;
        synchronized (list) {
            if (mWInstrument == null) {
                return TradeHistoryDirectory.getAll();
            }
            ArrayList<TradeHistory> arrayList = new ArrayList<TradeHistory>();
            for (TradeHistory tradeHistory : allActive) {
                if (tradeHistory == null || tradeHistory.getInstrument() == null || tradeHistory.getInstrument() != mWInstrument) continue;
                arrayList.add(tradeHistory);
            }
            return arrayList;
        }
    }

    public static boolean exists(MWInstrument mWInstrument, String string, String string2) {
        return TradeHistoryDirectory.find(mWInstrument, string, string2) != null;
    }

    public static TradeHistory find(MWInstrument mWInstrument, String string, String string2) {
        for (TradeHistory tradeHistory : TradeHistoryDirectory.getAll()) {
            if (!h.a((Object)tradeHistory.getId(), (Object)string2) || !h.a((Object)tradeHistory.getAccountId(), (Object)string) || !h.a((Object)tradeHistory.getInstrument(), (Object)mWInstrument)) continue;
            return tradeHistory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getAll() {
        List list = allActive;
        synchronized (list) {
            return new ArrayList(allActive);
        }
    }

    private static void notifyCreated(TradeHistory tradeHistory) {
        if (tradeHistory == null) {
            return;
        }
        for (j j2 : listeners.a()) {
            try {
                j2.a(tradeHistory);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void notifyCleared(Account account) {
        for (j j2 : listeners.a()) {
            try {
                j2.a(account);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void notifyCleared(String string) {
        for (j j2 : listeners.a()) {
            try {
                j2.a(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void notifyCleared() {
        for (j j2 : listeners.a()) {
            try {
                j2.b();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ boolean access$002(boolean bl2) {
        unsavedChanges = bl2;
        return unsavedChanges;
    }
}

