/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.a;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.PositionDirectory;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.TradeHistoryDirectory;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.service.as;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import k.i;
import q.g;

public class TradeHistory
extends a.b
implements Comparable,
i {
    private String id;
    private String userId;
    private String accountId;
    private String positionId;
    private String orderId;
    private String transId;
    private double balance;
    private long execTime;
    private String exchange;
    private Enums$OrderAction action;
    private float quantity;
    private float price;
    private boolean entry;
    private double pnl;
    private double realizedPnl;
    private float pips;
    private double commission;
    private TradeHistory linkedTrade;
    private float openQuantity;
    private Boolean supportsPL = null;
    private Ticker ticker;
    private g plListener = (mWInstrument, string, d2) -> {
        if (!this.isOpen()) {
            return;
        }
        this.updatePnl();
        this.updatePips();
    };

    public static TradeHistory fromCSV(String string, Map map) {
        List list = a.a(string);
        if (h.a((Collection)list)) {
            return null;
        }
        String string2 = a.a((String)list.get(1), map);
        MWInstrument mWInstrument = MWInstrument.getByKey(string2);
        if (mWInstrument == null) {
            h.a.warning("TradeHistory::fromCSV() unable to resolve instrument: " + string2);
            return null;
        }
        TradeHistory tradeHistory = new TradeHistory();
        tradeHistory.id = (String)list.get(0);
        tradeHistory.ticker = LiveTicker.get(mWInstrument);
        tradeHistory.exchange = a.a((String)list.get(2), map);
        if (h.a((Object)tradeHistory.exchange, (Object)mWInstrument.getExchange())) {
            tradeHistory.exchange = null;
        }
        tradeHistory.accountId = a.a((String)list.get(3), map);
        tradeHistory.userId = a.a((String)list.get(4), map);
        tradeHistory.orderId = (String)list.get(5);
        tradeHistory.positionId = (String)list.get(6);
        tradeHistory.transId = (String)list.get(7);
        tradeHistory.action = h.b((Object)h.j((String)list.get(8)), (Object)"B") ? Enums$OrderAction.BUY : Enums$OrderAction.SELL;
        tradeHistory.entry = a.a((String)list.get(9));
        tradeHistory.execTime = a.a((String)list.get(10));
        tradeHistory.price = a.a((String)list.get(11));
        String string3 = (String)list.get(12);
        if (string3.indexOf(46) >= 0 && Character.isDigit(string3.charAt(string3.length() - 1))) {
            tradeHistory.quantity = a.a(string3);
        } else {
            try {
                tradeHistory.quantity = s.a(string3);
            }
            catch (Exception exception) {
                tradeHistory.quantity = h.b(string3);
                h.a.warning("TradeHistory::fromCSV() unable to parse quantity: " + string3);
            }
        }
        tradeHistory.pnl = a.a((String)list.get(13));
        tradeHistory.balance = a.a((String)list.get(14));
        tradeHistory.commission = a.a((String)list.get(15));
        if (h.g(tradeHistory.id)) {
            if (!h.g(tradeHistory.transId)) {
                tradeHistory.id = tradeHistory.transId;
            } else if (!h.g(tradeHistory.orderId)) {
                tradeHistory.id = tradeHistory.orderId;
            }
        }
        tradeHistory.init();
        return tradeHistory;
    }

    public static void toCSV(TradeHistory tradeHistory, Map map, PrintWriter printWriter) {
        String string;
        String string2 = tradeHistory.exchange;
        if (h.a((Object)string2, (Object)tradeHistory.ticker.getExchangeSymbol())) {
            string2 = "";
        }
        String string3 = tradeHistory.userId;
        if (h.a((Object)tradeHistory.accountId, (Object)"simulated")) {
            string3 = null;
        }
        if (h.a((Object)(string = tradeHistory.id), (Object)tradeHistory.transId) || h.a((Object)string, (Object)tradeHistory.orderId)) {
            string = null;
        }
        a.a(printWriter, string, a.a(tradeHistory.ticker.getKey(), map), a.a(string2, map), a.a(tradeHistory.accountId, map), a.a(string3, map), tradeHistory.orderId, tradeHistory.positionId, tradeHistory.transId, tradeHistory.isBuy() ? "B" : "S", tradeHistory.entry, tradeHistory.execTime, h.c(tradeHistory.price, 4), s.a(tradeHistory.quantity), h.d(tradeHistory.getPnl(), 4), h.d(tradeHistory.balance, 4), h.d(tradeHistory.commission, 4));
    }

    public static int addIds(TradeHistory tradeHistory, Map map, int n2) {
        String string = tradeHistory.exchange;
        if (h.a((Object)string, (Object)tradeHistory.ticker.getExchangeSymbol())) {
            string = "";
        }
        n2 = a.a(string, map, n2);
        String string2 = tradeHistory.userId;
        if (h.a((Object)tradeHistory.accountId, (Object)"simulated")) {
            string2 = null;
        }
        n2 = a.a(string2, map, n2);
        if (tradeHistory.ticker != null) {
            n2 = a.a(tradeHistory.ticker.getKey(), map, n2);
        }
        return a.a(tradeHistory.accountId, map, n2);
    }

    private TradeHistory() {
    }

    public TradeHistory(Ticker ticker, String string2, String string3, String string4, String string5, String string6, String string7, long l2, String string8, Enums$OrderAction enums$OrderAction, float f2, float f3, boolean bl2, double d3, double d4, double d5) {
        this.ticker = ticker;
        this.id = string2;
        this.userId = string3;
        this.accountId = string4;
        this.transId = string5;
        this.positionId = string6;
        this.orderId = string7;
        this.execTime = l2;
        this.exchange = string8;
        if (h.a((Object)string8, (Object)ticker.getExchangeSymbol())) {
            this.exchange = null;
        }
        this.action = enums$OrderAction;
        this.quantity = f2;
        this.price = f3;
        this.entry = bl2;
        this.pnl = d3;
        this.commission = d4;
        this.balance = d5;
        this.init();
    }

    private void init() {
        if (this.entry) {
            this.openQuantity = Math.abs(this.quantity);
            if (!this.isBuy()) {
                this.openQuantity *= -1.0f;
            }
        }
        if (this.isEntry() && !h.g(this.positionId) && !this.isReplay() && this.supportsPL()) {
            PositionDirectory.addPLListener(this.getInstrument(), this.getAccountId(), this.plListener);
        }
        this.updatePnl();
        this.updatePips();
    }

    @Override
    public void destroy() {
        PositionDirectory.removePLListener(this.plListener);
    }

    public int compareTo(TradeHistory tradeHistory) {
        if (tradeHistory == this) {
            return 0;
        }
        if (tradeHistory.execTime > this.execTime) {
            return 1;
        }
        if (tradeHistory.execTime < this.execTime) {
            return -1;
        }
        return this.id.compareTo(tradeHistory.id);
    }

    @Override
    public String formatPrice(float f2) {
        return this.getInstrument().formatValue(f2);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "execTime": {
                return s.k(this.execTime, b.a());
            }
            case "underlying": {
                return this.getInstrument() == null ? "" : this.getInstrument().getUnderlying();
            }
            case "action": {
                return this.isBuy() ? ai.a("LBL_BOT", new Object[0]) : ai.a("LBL_SLD", new Object[0]);
            }
            case "symbol": {
                return this.getInstrument() == null ? "" : this.getInstrument().getSymbol();
            }
            case "exchange": {
                return h.b((Object)this.getExchange());
            }
            case "symbolDisplay": {
                return this.getInstrument() == null ? "" : this.getInstrument().getSymbolDisplay();
            }
            case "price": 
            case "avgPrice": 
            case "entryPrice": 
            case "exitPrice": {
                if (this.getInstrument() == null) {
                    return "";
                }
                float f2 = ((Float)this.getProperty(string)).floatValue();
                if ((double)f2 < this.getInstrument().getMinTick()) {
                    return "";
                }
                return this.getInstrument().formatValue(f2);
            }
            case "quantity": {
                return s.b(Math.abs(this.quantity), this.getInstrument());
            }
            case "pips": {
                return this.pips == 0.0f ? "" : h.c((double)this.pips, 1);
            }
            case "pnl": {
                double d2 = this.getPnl();
                if (d2 == 0.0) {
                    return "";
                }
                return s.a(d2);
            }
            case "balance": {
                return s.a(this.getBalance());
            }
            case "commission": {
                return s.a(this.getCommission());
            }
            case "entry": {
                if (this.entry) {
                    return ai.a("LBL_ENTRY", new Object[0]);
                }
                return ai.a("LBL_EXIT", new Object[0]);
            }
            case "serviceType": {
                return this.getServiceType() == null ? "" : this.getServiceType().toString();
            }
        }
        return h.b(this.getProperty(string));
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccount() == null ? "" : this.getAccount().getAccountName();
            }
            case "accountCurrency": {
                return this.getAccount() == null ? "" : this.getAccount().getBaseCurrency();
            }
            case "action": {
                return this.getAction();
            }
            case "commission": {
                return this.getCommission();
            }
            case "entryPrice": {
                return Float.valueOf(this.getEntryPrice());
            }
            case "exchange": {
                return this.getExchange();
            }
            case "execTime": {
                return this.getExecTime();
            }
            case "exitPrice": {
                return Float.valueOf(this.getExitPrice());
            }
            case "id": {
                return this.getId();
            }
            case "linkedTrade": {
                return this.getLinkedTrade();
            }
            case "orderId": {
                return this.getOrderId();
            }
            case "pips": {
                return Float.valueOf(this.pips);
            }
            case "pnl": {
                return this.getPnl();
            }
            case "positionId": {
                return this.getPositionId();
            }
            case "price": 
            case "avgPrice": {
                return Float.valueOf(this.getPrice());
            }
            case "symbol": {
                return this.getInstrument().getSymbol();
            }
            case "symbolDisplay": {
                return this.getInstrument().getSymbolDisplay();
            }
            case "quantity": {
                return Float.valueOf(this.getQuantity());
            }
            case "instrument": {
                return this.getInstrument();
            }
            case "underlying": {
                return this.getInstrument().getUnderlying();
            }
            case "userId": {
                return this.getUserId();
            }
            case "buy": {
                return this.isBuy();
            }
            case "entry": {
                return this.isEntry();
            }
            case "open": {
                return this.isOpen();
            }
            case "serviceType": {
                return this.getServiceType();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "realizedPnl": {
                return this.realizedPnl;
            }
            case "ticket": {
                if (this.isReplay()) {
                    return this.orderId;
                }
                if (!h.g(this.transId)) {
                    return this.transId;
                }
                if (!h.g(this.orderId)) {
                    return this.orderId;
                }
                if (!h.g(this.positionId)) {
                    return this.positionId;
                }
                return this.id;
            }
        }
        return super.getProperty(string);
    }

    private String getServiceName() {
        as as2 = ae.a(this.getAccount());
        if (as2 != null) {
            return as2.a().getType().toString();
        }
        return "";
    }

    private String getConnectionName() {
        as as2 = ae.a(this.getAccount());
        if (as2 != null) {
            return as2.a().getName();
        }
        return "";
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getKey() {
        String string = this.id;
        if (h.g(string)) {
            string = this.transId;
        }
        if (h.g(string)) {
            string = this.orderId;
        }
        return this.getInstrument().getKey() + "|" + this.getAccountId() + "|" + string;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Account getAccount() {
        return ae.a(this.accountId);
    }

    public String getUserId() {
        return this.userId;
    }

    public Position getPosition() {
        if (!this.isOpen() || h.g(this.positionId)) {
            return null;
        }
        return PositionDirectory.find(this.positionId);
    }

    public String getPositionId() {
        return this.positionId;
    }

    public String getTransId() {
        return this.transId;
    }

    public MWInstrument getInstrument() {
        return this.ticker.getInstrument();
    }

    public long getExecTime() {
        return this.execTime;
    }

    public String getExchange() {
        if (!h.g(this.exchange)) {
            return this.exchange;
        }
        MWInstrument mWInstrument = this.getInstrument();
        return mWInstrument == null ? null : mWInstrument.getExchange();
    }

    public Enums$OrderAction getAction() {
        return this.action;
    }

    public boolean isBuy() {
        return this.action == Enums$OrderAction.BUY || this.action == Enums$OrderAction.BUY_TO_COVER;
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float f2) {
        this.quantity = f2;
    }

    public float getPrice() {
        return this.price;
    }

    public double getCommission() {
        return this.commission;
    }

    public double getBalance() {
        return this.balance;
    }

    public boolean isEntry() {
        return this.entry;
    }

    public boolean isOpen() {
        if (!this.isEntry() || h.g(this.getPositionId())) {
            return false;
        }
        Position position = PositionDirectory.find(this.getPositionId());
        if (position == null) {
            return false;
        }
        return position.isOpen();
    }

    public TradeHistory getLinkedTrade() {
        return this.linkedTrade;
    }

    public void setLinkedTrade(TradeHistory tradeHistory) {
        this.linkedTrade = tradeHistory;
    }

    private float getEntryPrice() {
        if (this.isEntry()) {
            return this.price;
        }
        if (this.linkedTrade != null && this.linkedTrade.isEntry()) {
            return this.linkedTrade.getPrice();
        }
        return 0.0f;
    }

    private float getExitPrice() {
        return this.isEntry() ? 0.0f : this.getPrice();
    }

    private Enums$ServiceType getServiceType() {
        return this.getInstrument().getSourceType();
    }

    private String getBaseCurrency() {
        return s.b(this.getAccountId());
    }

    public float fill(float f2, float f3) {
        if (this.openQuantity == 0.0f) {
            return f2;
        }
        if (this.openQuantity > 0.0f && f2 > 0.0f || this.openQuantity < 0.0f && f2 < 0.0f) {
            return f2;
        }
        MWInstrument mWInstrument = this.getInstrument();
        if (Math.abs(this.openQuantity) > Math.abs(f2)) {
            this.realizedPnl += mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f3, -f2, this.getBaseCurrency());
            this.openQuantity += f2;
            this.updateInfo();
            return 0.0f;
        }
        this.realizedPnl += mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f3, this.openQuantity, this.getBaseCurrency());
        this.openQuantity = 0.0f;
        this.updatePnl();
        return f2 += this.openQuantity;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            TradeHistory tradeHistory = (TradeHistory)object;
            if (!h.a((Object)tradeHistory.getInstrument(), (Object)this.getInstrument())) {
                return false;
            }
            if (!h.a((Object)this.accountId, (Object)tradeHistory.accountId)) {
                return false;
            }
            if (this.id == null && tradeHistory.id == null) {
                if (this.orderId == null || tradeHistory.orderId == null) {
                    return false;
                }
                return this.orderId.equals(tradeHistory.orderId);
            }
            return this.id.equals(tradeHistory.id);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public double getPnl() {
        if (!this.supportsPL()) {
            return 0.0;
        }
        return this.pnl;
    }

    private void setPnl(double d2) {
        double d3 = this.pnl;
        this.pnl = d2;
        this.firePropertyChange("pnl", d3, d2);
    }

    private void setPips(float f2) {
        if (f2 == this.pips) {
            return;
        }
        float f3 = this.pips;
        this.pips = f2;
        this.firePropertyChange("pips", f3, this.pips);
    }

    public void updateInfo() {
        this.updatePips();
        this.updatePnl();
    }

    private void updatePnl() {
        Account account = this.getAccount();
        if (ae.d(account) || ae.c(account) || !this.supportsPL()) {
            return;
        }
        if (this.isEntry()) {
            if (account.isSimulatedAccount()) {
                this.setPnl(0.0);
                this.realizedPnl = 0.0;
                return;
            }
            float f2 = this.ticker.getCurrentPrice(this.openQuantity);
            MWInstrument mWInstrument = this.getInstrument();
            if (this.isReplay()) {
                if (this.openQuantity == 0.0f) {
                    this.setPnl(this.realizedPnl);
                } else {
                    this.setPnl(this.realizedPnl + mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f2, this.openQuantity, this.getBaseCurrency()));
                }
                return;
            }
            List list = TradeHistoryDirectory.getByPosition(this.getPositionId());
            list.remove(this);
            if (h.a((Collection)list)) {
                this.setPnl(this.realizedPnl + mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f2, this.openQuantity, this.getBaseCurrency()));
                return;
            }
            float f3 = this.openQuantity;
            float f4 = 0.0f;
            for (TradeHistory tradeHistory : list) {
                if (tradeHistory.isEntry()) {
                    h.a.severe("TradeHistory::getPnl() linked trade is entry!!! id: " + this.getId() + " linked id: " + tradeHistory.getId());
                    continue;
                }
                float f5 = Math.abs(tradeHistory.getQuantity());
                if (!tradeHistory.isBuy()) {
                    f5 *= -1.0f;
                }
                f3 += f5;
                f4 = (float)((double)f4 + tradeHistory.getPnl());
            }
            if (f3 == 0.0f) {
                this.setPnl(f4);
                return;
            }
            if (this.isOpen()) {
                this.setPnl((double)f4 + this.realizedPnl + mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f2, f3, this.getBaseCurrency()));
                return;
            }
            this.setPnl(f4);
            return;
        }
        if (this.getPnl() != 0.0) {
            return;
        }
        if (this.linkedTrade != null) {
            this.setPnl(this.linkedTrade.getPnl());
        }
    }

    private void updatePips() {
        if (!this.supportsPips()) {
            return;
        }
        float f2 = 0.0f;
        if (this.linkedTrade != null) {
            f2 = (float)Math.abs((double)(this.getPrice() - this.linkedTrade.getPrice()) / this.getInstrument().getPointSize());
        } else {
            float f3 = 0.0f;
            if (this.quantity < 0.0f) {
                f3 = this.ticker.getAskPrice();
            } else if (this.quantity > 0.0f) {
                f3 = this.ticker.getBidPrice();
            }
            if (f3 == 0.0f) {
                f3 = this.ticker.getLastPrice();
            }
            f2 = (float)Math.abs((double)(this.getPrice() - f3) / this.getInstrument().getPointSize());
        }
        if (this.getPnl() > 0.0) {
            this.setPips(f2);
        } else {
            this.setPips(-1.0f * f2);
        }
    }

    public String toString() {
        return "TradeHistory::acct: " + this.accountId + " id: " + this.id + " userId: " + this.userId + " symbol: " + this.getInstrument().getKey() + " orderId: " + this.orderId + " posId: " + this.positionId + " action: " + this.action + " qty: " + this.quantity + " price: " + this.price + " entry: " + this.entry + " pnl: " + this.pnl;
    }

    public boolean supportsPL() {
        if (this.isReplay()) {
            return true;
        }
        if (this.supportsPL != null) {
            return this.supportsPL;
        }
        Account account = this.getAccount();
        if (account == null) {
            return false;
        }
        this.supportsPL = ae.h(account);
        return this.supportsPL;
    }

    public boolean supportsPips() {
        if (!this.getInstrument().isCash()) {
            return false;
        }
        if (!this.supportsPL()) {
            return false;
        }
        return !ae.d(this.getAccount()) && !ae.c(this.getAccount());
    }

    public boolean isReplay() {
        Account account = this.getAccount();
        if (account == null) {
            return false;
        }
        return account.isReplay();
    }
}

