/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import bt.bh;
import bx.ae;
import bx.c;
import bx.d;
import bx.x;
import bx.y;
import bx.z;
import cn.dj;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$BarType;
import com.motivewave.platform.databean.FormatRule;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.StudyInfo;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataContext;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.common.Settings;
import com.motivewave.platform.sdk.common.Tick;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.ui.draw.n;
import com.motivewave.platform.ui.draw.o;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.List;
import k.i;
import o.a;
import o.p;

public abstract class TickerStudyProperty
implements ae,
z,
o,
i {
    protected boolean destroyed = false;
    private Object value;
    private LiveTicker ticker;
    protected com.motivewave.platform.ui.draw.p dm;
    protected Study study;
    protected bh model;
    protected StudyInfo studyInfo;
    protected d dataSeries;
    protected c dataContext;
    private boolean formatMK = false;
    private Double minTick = null;
    private boolean barUpdateInProgress = false;

    TickerStudyProperty(LiveTicker liveTicker) {
        this.ticker = liveTicker;
    }

    protected void reinitialize() {
        this.dm.b(this);
        this.dm.destroy();
        this.study.destroy();
        this.dataSeries.destroy();
        this.dataContext.destroy();
        y.b(this);
        this.dm = null;
        this.study = null;
        this.model = null;
        this.studyInfo = null;
        this.dataSeries = null;
        this.dataContext = null;
        this.initialize();
    }

    protected void initialize() {
        this.setValue(null);
        MWInstrument mWInstrument = this.ticker.getInstrument();
        this.dm = new com.motivewave.platform.ui.draw.p(mWInstrument);
        this.dm.a(this.getBarSize());
        this.dm.a(com.motivewave.platform.service.ae.r(mWInstrument) ? Enums.BarData.PRICE : Enums.BarData.MIDPOINT);
        this.dm.a(Enums$BarType.CANDLESTICK);
        this.dm.b(this.isRthData());
        this.dm.d(100);
        this.dm.a(true);
        dj dj2 = this.getStudyWithModel();
        this.study = dj2.a().clone();
        this.model = dj2.a().a();
        this.studyInfo = dj2.a().a();
        this.updateStudySettings();
        for (BarSize barSize : this.study.getBarSizes()) {
            this.dm.a(barSize.getIntervalMinutes(), this.study.getMinBars() + 10);
        }
        if (dj2.a().a() != null) {
            this.dm.a((MWInstrument)dj2.a().a());
        }
        for (BarSize barSize : this.study.getInstruments()) {
            MWInstrument mWInstrument2 = MWInstrument.get((Instrument)barSize);
            if (mWInstrument2 == null || this.dm.a(mWInstrument2)) continue;
            this.dm.a(mWInstrument2);
        }
        this.dm.f(this.study.getMinBars() + 50);
        try {
            this.dm.b(com.motivewave.platform.service.ae.a() + 60000L, 100, (n)null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        List list = this.dm.c();
        this.dataSeries = new d(list, this.getBarSize(), this.dm.a(), Enums$BarType.CANDLESTICK, this.ticker);
        this.dataSeries.a(0);
        this.dataSeries.b(list.size() - 1);
        this.dataContext = new c(this.dataSeries, this.dm, this.study, this.model);
        this.study.onLoad(this.dataContext.getDefaults());
        this.study.clearState();
        this.study.onNewDataSeries((DataContext)this.dataContext);
        this.setValue(this.dataSeries.getValue(this.getStudyValue().getKey()));
        this.dataSeries.a(this);
        this.dm.a(this);
        y.a(this);
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        System.err.println("destroying custom property: " + this.getProperty());
        this.destroyed = true;
        this.dm.b(this);
        this.dm.destroy();
        this.study.destroy();
        this.dataSeries.destroy();
        this.dataContext.destroy();
        y.b(this);
        this.dm = null;
        this.study = null;
        this.model = null;
        this.studyInfo = null;
        this.ticker = null;
        this.dataSeries = null;
        this.dataContext = null;
    }

    @Override
    public void onBarOpen(a a2) {
        if (this.destroyed || !this.model.n()) {
            return;
        }
        this.dataSeries.a(this.dm.c(), this.dm.a());
        this.dataSeries.a(this.dm.b());
        this.dataSeries.b(this.dm.c());
        this.dataContext.e();
        try {
            this.study.beginFigureUpdate();
            this.study.onBarOpen((DataContext)this.dataContext);
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
        finally {
            this.study.endFigureUpdate();
            this.dataContext.f();
        }
    }

    @Override
    public void onBarClose(a a2) {
        if (this.destroyed) {
            return;
        }
        this.dataSeries.a(this.dm.c(), this.dm.a());
        this.dataSeries.a(this.dm.b());
        this.dataSeries.b(this.dm.c());
        this.dataContext.e();
        try {
            this.study.beginFigureUpdate();
            this.study.onBarClose((DataContext)this.dataContext);
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
        finally {
            this.study.endFigureUpdate();
            this.dataContext.f();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBarUpdate(a a2) {
        block10: {
            if (this.destroyed || !this.model.n()) {
                return;
            }
            if (this.barUpdateInProgress) {
                return;
            }
            this.barUpdateInProgress = true;
            try {
                this.dataContext.e();
                try {
                    this.study.beginFigureUpdate();
                    this.study.onBarUpdate((DataContext)this.dataContext);
                }
                catch (Throwable throwable) {
                    try {
                        this.logTrace(throwable);
                        break block10;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        this.study.endFigureUpdate();
                        this.dataContext.f();
                    }
                }
                this.study.endFigureUpdate();
                this.dataContext.f();
            }
            finally {
                this.barUpdateInProgress = false;
            }
        }
    }

    @Override
    public void onTick(p p2) {
        if (this.destroyed || !this.model.n()) {
            return;
        }
        this.dataContext.e();
        try {
            this.study.onTick((DataContext)this.dataContext, (Tick)p2);
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
        finally {
            this.dataContext.f();
        }
    }

    @Override
    public void studyClassLoaded(StudyInfo studyInfo) {
        if (this.destroyed) {
            return;
        }
        if (studyInfo == null || !h.a((Object)studyInfo.getID(), (Object)this.studyInfo.getID()) || !h.a((Object)studyInfo.getNamespace(), (Object)this.studyInfo.getNamespace())) {
            return;
        }
        Study study = y.a(studyInfo);
        if (study == null) {
            h.a.warning("StudyWrapper::studyClassLoaded() unable to create study! " + studyInfo.getID());
            return;
        }
        this.studyInfo = studyInfo;
        this.study = study;
        try {
            this.updateStudySettings();
            this.reset();
            this.recalculate();
            this.dataSeries.c();
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        if (h.a(object, this.value)) {
            return;
        }
        Object object2 = this.value;
        this.value = object;
        this.ticker.firePropertyChange(this.getProperty(), object2, object);
    }

    public String getFormattedValue() {
        Object object = this.getValue();
        if (object == null || this.study == null) {
            return "";
        }
        if (object instanceof Number) {
            double d2;
            double d3 = ((Number)object).doubleValue();
            if (this.formatMK) {
                if (d3 >= 2.5E12) {
                    double d4 = h.a(d3 / 1.0E12, 1);
                    return h.c(d4, 1) + "T";
                }
                if (d3 >= 2.5E9) {
                    double d5 = h.a(d3 / 1.0E9, 1);
                    return h.c(d5, 1) + "B";
                }
                if (d3 >= 1000000.0 || d3 <= -1000000.0) {
                    double d6 = h.a(d3 / 1000000.0, 1);
                    return h.c(d6, 1) + "M";
                }
                if (d3 >= 10000.0 || d3 <= -10000.0) {
                    double d7 = h.a(d3 / 1000.0, 1);
                    return h.c(d7, 1) + "K";
                }
            }
            double d8 = d2 = this.minTick == null ? 1.0E-5 : this.minTick;
            if (this.minTick == null) {
                if (d3 >= 1000.0 || d3 <= -1000.0) {
                    d2 = 0.1;
                } else if (d3 >= 100.0 || d3 <= -100.0) {
                    d2 = 0.01;
                } else if (d3 >= 10.0 || d3 <= -10.0) {
                    d2 = 0.001;
                } else if (d3 >= 1.0 || d3 <= -1.0) {
                    d2 = 1.0E-4;
                } else if (d3 >= 0.1 || d3 <= -0.1) {
                    d2 = 1.0E-5;
                } else if (d3 >= 0.01 || d3 <= -0.01) {
                    d2 = 1.0E-6;
                } else if (d3 >= 0.001 || d3 <= -0.001) {
                    d2 = 1.0E-7;
                }
            }
            return h.a(d3, d2);
        }
        return object.toString();
    }

    public FormatRule getApplicableRule() {
        return null;
    }

    protected abstract ValueDescriptor getStudyValue();

    protected abstract dj getStudyWithModel();

    protected abstract String getProperty();

    protected abstract BarSize getBarSize();

    protected abstract boolean isRthData();

    @Override
    public void valueUpdated(Object object, Object object2, Object object3) {
        if (!h.a(this.getStudyValue().getKey(), object)) {
            return;
        }
        this.setValue(object3);
    }

    private void updateStudySettings() {
        if (this.destroyed) {
            return;
        }
        Settings settings = this.getStudyWithModel().a().a();
        if (h.a(settings.getInstruments())) {
            this.study.setSettings(settings);
        }
        this.study.setSettings((Settings)new x(settings, this.dm, null));
        this.formatMK = this.study.getRuntimeDescriptor().getDefaultPlot().isFormatMK();
        this.minTick = this.study.getRuntimeDescriptor().getMinTick();
    }

    private void reset() {
        try {
            d d2 = this.dataSeries;
            Study study = this.study;
            if (d2 == null || study == null) {
                return;
            }
            study.clearState();
            d2.b();
            this.dataContext.b();
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
    }

    private void recalculate() {
        try {
            if (this.destroyed) {
                return;
            }
            this.study.onDataSeriesUpdated((DataContext)this.dataContext);
            this.dataSeries.c();
        }
        catch (Throwable throwable) {
            this.logTrace(throwable);
        }
    }

    private void logTrace(Throwable throwable) {
        throwable.printStackTrace();
        String string = h.a(throwable);
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            String string3 = bufferedReader.readLine();
            String string4 = bufferedReader.readLine();
            String string5 = bufferedReader.readLine();
            String string6 = bufferedReader.readLine();
            String string7 = bufferedReader.readLine();
            String string8 = string2 + " " + h.b((Object)string3);
            if (this.study != null) {
                this.study.error(string8);
            }
            if (string2 != null) {
                System.err.println(string2);
            }
            if (string3 != null) {
                System.err.println(string3);
            }
            if (string4 != null) {
                System.err.println(string4);
            }
            if (string5 != null) {
                System.err.println(string5);
            }
            if (string6 != null) {
                System.err.println(string6);
            }
            if (string7 != null) {
                System.err.println(string7);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

