/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import bt.bh;
import bx.y;
import com.motivewave.common.command.CommandFactory;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$BackTestType;
import com.motivewave.platform.common.Enums$ReplayData;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.b;
import com.motivewave.platform.common.o;
import com.motivewave.platform.common.s;
import com.motivewave.platform.databean.DataSettings;
import com.motivewave.platform.databean.ExecutionReport;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.WatchListDirectory;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.sdk.common.Enums;
import com.motivewave.platform.sdk.study.Study;
import com.motivewave.platform.service.ae;
import com.motivewave.platform.ui.strategy_analysis.u;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import k.al;
import k.f;
import k.g;
import k.q;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StrategyAnalysis
extends a.b
implements o {
    private String name;
    private String config;
    private long lastModified;
    private Study strategy;
    private bh model;
    private u optimizeSettings = new u();
    private List instruments = new ArrayList();
    private DataSettings dataSettings = new DataSettings();
    private List backTestReports = new ArrayList();
    private List optimizeReports = new ArrayList();
    private List walkForwardReports = new ArrayList();
    private float initialAccountValue = 100000.0f;
    private int slippage = 0;
    private boolean fillOnBidAsk = ae.p(null);
    private boolean includeCommission = false;
    private boolean modified = false;
    private Enums$BackTestType type = Enums$BackTestType.BACKTEST;
    private static f loadedAnalyses = new f();
    private static al untitledAnalyses = new al();

    public StrategyAnalysis() {
    }

    public StrategyAnalysis(String string, long l2, String string2) {
        this.name = string;
        this.lastModified = l2;
        this.config = string2;
        if (q.a(this.config)) {
            this.b(this.config);
        } else {
            this.readXML();
        }
    }

    @Override
    public String format(String string) {
        if (h.g(string)) {
            return "";
        }
        if (string.equals("name")) {
            return this.getName();
        }
        if (string.equals("lastModified")) {
            return s.k(this.getLastModified(), b.a());
        }
        return super.format(string);
    }

    public boolean isModified() {
        return this.modified || h.g(this.name);
    }

    public void setModified() {
        if (this.modified) {
            return;
        }
        this.modified = true;
        this.firePropertyChange("modified", false, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (h.a((Object)string, (Object)this.name)) {
            return;
        }
        String string2 = this.name;
        this.name = string;
        this.modified = true;
        this.firePropertyChange("name", string2, string);
    }

    public String getUntitledName() {
        if (!h.g(this.name)) {
            return this.name;
        }
        if (this.strategy == null) {
            return "";
        }
        return this.strategy.getLabel();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long l2) {
        this.lastModified = l2;
    }

    public bh getModel() {
        return this.model;
    }

    public void setModel(bh bh2) {
        if (h.a((Object)this.model, (Object)bh2)) {
            return;
        }
        bh bh3 = this.model;
        this.model = bh2;
        this.modified = true;
        this.firePropertyChange("name", bh3, bh2);
    }

    public u getOptimizeSettings() {
        return this.optimizeSettings;
    }

    public void setOptimizeSettings(u u2) {
        if (h.a((Object)this.optimizeSettings, (Object)u2)) {
            return;
        }
        this.optimizeSettings = u2;
        this.setModified();
    }

    public Study getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Study study) {
        if (h.a((Object)study, (Object)this.strategy)) {
            return;
        }
        this.strategy = study;
        this.setModified();
    }

    public List getInstruments() {
        return this.instruments;
    }

    public void setInstruments(List list) {
        this.instruments = list;
        this.setModified();
    }

    public DataSettings getDataSettings() {
        return this.dataSettings;
    }

    public List getBackTestReports() {
        return this.backTestReports;
    }

    public void setBackTestReports(List list) {
        this.backTestReports = list;
        this.setModified();
    }

    public List getOptimizeReports() {
        return this.optimizeReports;
    }

    public void setOptimizeReports(List list) {
        this.optimizeReports = list;
        this.setModified();
    }

    public List getWalkForwardReports() {
        return this.walkForwardReports;
    }

    public void setWalkForwardReports(List list) {
        this.walkForwardReports = list;
        this.setModified();
    }

    public void setInitialAccountValue(float f2) {
        this.initialAccountValue = f2;
    }

    public float getInitialAccountValue() {
        return this.initialAccountValue;
    }

    public void setSlippage(int n2) {
        this.slippage = n2;
    }

    public int getSlippage() {
        return this.slippage;
    }

    public void setFillOnBidAsk(boolean bl2) {
        this.fillOnBidAsk = bl2;
    }

    public boolean isFillOnBidAsk() {
        return this.fillOnBidAsk;
    }

    public void setIncludeCommission(boolean bl2) {
        this.includeCommission = bl2;
    }

    public boolean isIncludeCommission() {
        return this.includeCommission;
    }

    public void setType(Enums$BackTestType enums$BackTestType) {
        if (enums$BackTestType == this.type) {
            return;
        }
        Enums$BackTestType enums$BackTestType2 = this.type;
        this.type = enums$BackTestType;
        this.setModified();
        this.firePropertyChange("type", (Object)enums$BackTestType2, (Object)enums$BackTestType);
    }

    public Enums$BackTestType getType() {
        return this.type;
    }

    public void update(StrategyAnalysis strategyAnalysis) {
        this.setName(strategyAnalysis.name);
        this.strategy = strategyAnalysis.strategy;
        this.setType(strategyAnalysis.type);
        this.setModel(strategyAnalysis.model);
        this.optimizeSettings = strategyAnalysis.optimizeSettings;
        this.instruments = new ArrayList(strategyAnalysis.instruments);
        this.dataSettings = strategyAnalysis.dataSettings.clone();
        this.backTestReports = new ArrayList(strategyAnalysis.backTestReports);
        this.optimizeReports = new ArrayList(strategyAnalysis.optimizeReports);
        this.walkForwardReports = new ArrayList(strategyAnalysis.walkForwardReports);
        this.initialAccountValue = strategyAnalysis.initialAccountValue;
        this.slippage = strategyAnalysis.slippage;
        this.fillOnBidAsk = strategyAnalysis.fillOnBidAsk;
        this.includeCommission = strategyAnalysis.includeCommission;
        this.setModified();
    }

    @Override
    public StrategyAnalysis clone() {
        try {
            StrategyAnalysis strategyAnalysis = (StrategyAnalysis)super.clone();
            strategyAnalysis.strategy = this.strategy.clone();
            strategyAnalysis.dataSettings = this.dataSettings.clone();
            strategyAnalysis.model = this.model.a();
            strategyAnalysis.optimizeSettings = this.optimizeSettings.a();
            strategyAnalysis.instruments = new ArrayList(this.instruments);
            strategyAnalysis.backTestReports = new ArrayList();
            strategyAnalysis.dataSettings = this.dataSettings.clone();
            for (ExecutionReport executionReport : this.backTestReports) {
                strategyAnalysis.backTestReports.add(executionReport.clone());
            }
            strategyAnalysis.optimizeReports = new ArrayList();
            for (ExecutionReport executionReport : this.optimizeReports) {
                strategyAnalysis.optimizeReports.add(executionReport.clone());
            }
            strategyAnalysis.walkForwardReports = new ArrayList();
            for (ExecutionReport executionReport : this.walkForwardReports) {
                strategyAnalysis.walkForwardReports.add(executionReport.clone());
            }
            return strategyAnalysis;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void save() {
        if (h.g(this.name)) {
            h.a.severe("StrategyAnalysis::update() name is null!");
            return;
        }
        this.lastModified = ae.a();
        this.config = this.c_();
        File file = StrategyAnalysis.getDir();
        file.mkdirs();
        h.a(StrategyAnalysis.getFile(this.name), this.config);
        this.modified = false;
        this.firePropertyChange("modified", true, false);
        StrategyAnalysis.discardUntitled(this);
    }

    @Override
    public List getNVPs() {
        List list = h.b(new String[]{this.a("type", (Object)this.type), this.a("acctValue", this.initialAccountValue), this.a("fillOnBidAsk", this.fillOnBidAsk), this.a("includeCommission", this.includeCommission), this.a("slippage", this.slippage)});
        list.add(this.a("instruments", (Collection)this.instruments));
        list.add(this.a("data", this.dataSettings));
        list.add(this.a("strategy", this.model));
        list.add(this.a("optSettings", this.optimizeSettings));
        list.add(this.a("backtestReports", (Collection)this.backTestReports));
        list.add(this.a("optimizeReports", (Collection)this.optimizeReports));
        list.add(this.a("walkforwardReports", (Collection)this.walkForwardReports));
        return list;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        a.b b2;
        this.type = Enums$BackTestType.valueOf(jSONObject.str("type"));
        this.initialAccountValue = jSONObject.getFloat("acctValue");
        this.fillOnBidAsk = jSONObject.is("fillOnBidAsk");
        this.includeCommission = jSONObject.is("includeCommission");
        this.slippage = jSONObject.getInt("slippage");
        this.instruments = new ArrayList();
        for (Object object : jSONObject.getStringList("instruments")) {
            b2 = WatchListDirectory.get((String)object);
            if (b2 == null) {
                b2 = this.a((String)object);
            }
            if (b2 != null) {
                this.instruments.add(b2);
                continue;
            }
            h.a.warning("ScanInfo::fromJSON() unable to resolve instrument/watch list: " + (String)object);
        }
        this.dataSettings.fromJSON(jSONObject.obj("data"));
        this.model = new bh(jSONObject.obj("strategy"));
        this.strategy = y.a(this.model.a());
        this.optimizeSettings = new u();
        this.optimizeSettings.fromJSON(jSONObject.obj("optSettings"));
        this.backTestReports.clear();
        for (Object object : jSONObject.getObjList("backtestReports")) {
            b2 = MWInstrument.get(((JSONObject)object).str("symbol"), ((JSONObject)object).str("exchange"));
            if (b2 == null) continue;
            try {
                this.backTestReports.add(new ExecutionReport(this, (JSONObject)object));
            }
            catch (Exception exception) {
                System.err.println("error loading back test report: " + (JSONObject)object);
                exception.printStackTrace();
            }
        }
        this.optimizeReports.clear();
        for (Object object : jSONObject.getObjList("optimizeReports")) {
            b2 = MWInstrument.get(((JSONObject)object).str("symbol"), ((JSONObject)object).str("exchange"));
            if (b2 == null) continue;
            try {
                this.optimizeReports.add(new ExecutionReport(this, (JSONObject)object));
            }
            catch (Exception exception) {
                System.err.println("error loading execution report: " + (JSONObject)object);
                exception.printStackTrace();
            }
        }
        this.walkForwardReports.clear();
        for (Object object : jSONObject.getObjList("walkforwardReports")) {
            b2 = MWInstrument.get(((JSONObject)object).str("symbol"), ((JSONObject)object).str("exchange"));
            if (b2 == null) continue;
            try {
                this.walkForwardReports.add(new ExecutionReport(this, (JSONObject)object));
            }
            catch (Exception exception) {
                System.err.println("error loading walk forward report: " + (JSONObject)object);
                exception.printStackTrace();
            }
        }
    }

    private void readXML() {
        try {
            ExecutionReport executionReport;
            Object object;
            Object object2;
            Node node2;
            Element element = g.a(this.config);
            this.initialAccountValue = 100000.0f;
            if (!h.g(element.getAttribute("type"))) {
                this.type = Enums$BackTestType.valueOf(element.getAttribute("type"));
            }
            if (!h.g(element.getAttribute("acctValue"))) {
                this.initialAccountValue = h.b(element.getAttribute("acctValue"));
            }
            if (!h.g(element.getAttribute("fillOnBidAsk"))) {
                this.fillOnBidAsk = h.a((Object)element.getAttribute("fillOnBidAsk"));
            }
            if (!h.g(element.getAttribute("includeCommission"))) {
                this.includeCommission = h.a((Object)element.getAttribute("includeCommission"));
            }
            if (!h.g(element.getAttribute("slippage"))) {
                this.slippage = h.b(element.getAttribute("slippage"));
            }
            this.instruments = new ArrayList();
            for (Node node2 : g.a(g.b("instruments", element))) {
                Object object3;
                if (h.a((Object)node2.getNodeName(), (Object)"instrument")) {
                    object2 = node2.getAttribute("symbol");
                    object3 = MWInstrument.get((String)object2, (String)(object = node2.getAttribute("exchange")));
                    if (object3 == null) {
                        h.a.warning("BackTestSettings::readXML() unable to resolve instrument: " + (String)object2 + ":" + (String)object);
                        continue;
                    }
                    this.instruments.add(object3);
                    continue;
                }
                if (!h.a((Object)node2.getNodeName(), (Object)"watchlist")) continue;
                int n2 = h.b(node2.getAttribute("id"));
                object = node2.getAttribute("name");
                object3 = WatchListDirectory.get((String)object);
                if (object3 == null) {
                    object3 = WatchListDirectory.get(n2);
                }
                if (object3 == null) {
                    h.a.warning("BackTestSettings::readXML() unable to resolve watch list: " + (String)object);
                    continue;
                }
                this.instruments.add(object3);
            }
            Node node3 = g.b("data", element);
            this.dataSettings.setBarData(Enums.BarData.valueOf((String)node3.getAttribute("barData")));
            this.dataSettings.setSourceData(Enums$ReplayData.valueOf(node3.getAttribute("sourceData")));
            this.dataSettings.setGenerateTicks(h.a((Object)node3.getAttribute("generateTicks")));
            this.dataSettings.setRTHData(h.a((Object)node3.getAttribute("rthData")));
            this.dataSettings.setStartDate(h.b(node3.getAttribute("startDate")));
            this.dataSettings.setEndDate(h.b(node3.getAttribute("endDate")));
            this.dataSettings.setOptimizePeriod(h.b(node3.getAttribute("optimizePeriod")));
            this.dataSettings.setWalkForwardPeriod(h.b(node3.getAttribute("walkForwardPeriod")));
            this.dataSettings.setAnchorOptimizePeriod(h.a((Object)node3.getAttribute("anchorOptimizePeriod")));
            this.dataSettings.setBarSize(s.a((Element)g.b("barSize", node3)));
            node2 = g.b("strategy", element);
            this.model = bh.a((Element)g.b("study", node2));
            this.strategy = y.a(this.model.a());
            object2 = g.b("opt_settings", element);
            if (object2 != null) {
                this.optimizeSettings = new u();
                this.optimizeSettings.a((Element)object2);
            }
            this.backTestReports.clear();
            object = g.b("backtest_reports", element);
            if (object != null) {
                for (Element element2 : g.c("report", (Node)object)) {
                    executionReport = new ExecutionReport(this);
                    executionReport.readXML(element2);
                    this.backTestReports.add(executionReport);
                }
            }
            this.optimizeReports.clear();
            object = g.b("optimize_reports", element);
            if (object != null) {
                for (Element element2 : g.c("report", (Node)object)) {
                    executionReport = new ExecutionReport(this);
                    executionReport.readXML(element2);
                    this.optimizeReports.add(executionReport);
                }
            }
            this.walkForwardReports.clear();
            object = g.b("walkforward_reports", element);
            if (object != null) {
                for (Element element2 : g.c("report", (Node)object)) {
                    executionReport = new ExecutionReport(this);
                    executionReport.readXML(element2);
                    this.walkForwardReports.add(executionReport);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            h.a.severe("StrategyAnalysis::readXML() " + exception.getMessage());
            h.a.severe(this.config);
        }
    }

    public String toString() {
        if (!h.g(this.name)) {
            return this.name;
        }
        return ai.a("UNTITLED", new Object[0]) + " - " + this.getUntitledName();
    }

    public static StrategyAnalysis load(String string) {
        File file = StrategyAnalysis.getFile(string);
        if (file == null || !file.exists()) {
            return null;
        }
        for (StrategyAnalysis strategyAnalysis : loadedAnalyses.a()) {
            if (!h.a((Object)strategyAnalysis.getName(), (Object)string)) continue;
            return strategyAnalysis;
        }
        StrategyAnalysis strategyAnalysis = new StrategyAnalysis(string, file.lastModified(), h.a(file));
        loadedAnalyses.a(strategyAnalysis);
        return strategyAnalysis;
    }

    public static void load() {
        if (!Workspace.hasDB()) {
            return;
        }
        try {
            File file = StrategyAnalysis.getDir();
            if (file != null && file.exists()) {
                return;
            }
            com.motivewave.common.command.b b2 = CommandFactory.createCmd("LOAD_STRATEGY_ANALYSES");
            for (StrategyAnalysis strategyAnalysis : (List)b2.a()) {
                strategyAnalysis.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static File getDir() {
        return new File(Workspace.findDir("strategy_analysis"), "strategy_analysis");
    }

    public static void remove(String string) {
        File file = new File(StrategyAnalysis.getDir(), string + ".json");
        file.delete();
        for (StrategyAnalysis strategyAnalysis : loadedAnalyses.a()) {
            if (!h.a((Object)strategyAnalysis.getName(), (Object)string)) continue;
            loadedAnalyses.a(strategyAnalysis);
        }
    }

    public static void rename(String string, String string2) {
        if (h.a((Object)string, (Object)string2)) {
            return;
        }
        StrategyAnalysis.getFile(string).renameTo(StrategyAnalysis.getFile(string2));
        for (StrategyAnalysis strategyAnalysis : loadedAnalyses.a()) {
            if (!h.a((Object)strategyAnalysis.getName(), (Object)string)) continue;
            strategyAnalysis.setName(string2);
        }
    }

    public static List getUntitled() {
        return untitledAnalyses.a();
    }

    public static void registerUntitled(StrategyAnalysis strategyAnalysis) {
        if (strategyAnalysis == null || !h.g(strategyAnalysis.getName())) {
            return;
        }
        if (untitledAnalyses.a(strategyAnalysis)) {
            return;
        }
        untitledAnalyses.a(strategyAnalysis);
    }

    public static void discardUntitled(StrategyAnalysis strategyAnalysis) {
        if (strategyAnalysis == null) {
            return;
        }
        untitledAnalyses.b(strategyAnalysis);
    }

    private static File getFile(String string) {
        return new File(StrategyAnalysis.getDir(), string + ".json");
    }

    public static List getNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = StrategyAnalysis.getDir();
        if (file == null || !file.exists()) {
            return arrayList;
        }
        for (File file2 : StrategyAnalysis.getDir().listFiles()) {
            if (file2.isDirectory() || !file2.getName().toUpperCase().endsWith(".JSON")) continue;
            arrayList.add(file2.getName().substring(0, h.b(file2.getName(), ".JSON")));
        }
        return arrayList;
    }

    public static List getModified() {
        ArrayList<StrategyAnalysis> arrayList = new ArrayList<StrategyAnalysis>();
        for (StrategyAnalysis strategyAnalysis : loadedAnalyses.a()) {
            if (!strategyAnalysis.isModified()) continue;
            arrayList.add(strategyAnalysis);
        }
        return arrayList;
    }
}

