/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.databean.ConnectionID;
import com.motivewave.platform.databean.ConnectionInfo;
import com.motivewave.platform.service.ad;
import com.motivewave.platform.service.ae;
import java.util.Collection;
import java.util.List;
import k.f;
import k.g;
import k.q;
import org.json.JSONObject;
import org.w3c.dom.Element;

public class ServiceInfo
implements q {
    private ConnectionInfo primaryInfo;
    private ConnectionInfo realTimeInfo;
    private ConnectionInfo historicalInfo;
    private ConnectionInfo newsInfo;
    private f connections = new f();
    private String name;
    private boolean googleStocks = false;
    private int counter = 0;
    private String id = Long.toUnsignedString(System.currentTimeMillis(), 32);

    public ServiceInfo(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public ServiceInfo() {
    }

    public void updateFrom(ServiceInfo serviceInfo) {
        this.name = serviceInfo.name;
        this.googleStocks = serviceInfo.googleStocks;
        this.primaryInfo = serviceInfo.primaryInfo;
        this.realTimeInfo = serviceInfo.realTimeInfo;
        this.historicalInfo = serviceInfo.historicalInfo;
        this.newsInfo = serviceInfo.newsInfo;
    }

    public String getName() {
        if (!h.g(this.name)) {
            return this.name;
        }
        if (this.primaryInfo == null || this.primaryInfo.getDescriptor() == null) {
            return "";
        }
        return this.primaryInfo.getDescriptor().l();
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getId() {
        return this.id;
    }

    public ConnectionID getConnectionID() {
        return ConnectionID.get(this.getName(), this.getId(), this.primaryInfo == null ? null : this.primaryInfo.getType());
    }

    public String getService() {
        if (this.primaryInfo == null || this.primaryInfo.getDescriptor() == null) {
            return "";
        }
        return this.primaryInfo.getDescriptor().l();
    }

    public Enums$ServiceType getType() {
        return this.primaryInfo == null ? null : this.primaryInfo.getType();
    }

    public ConnectionInfo getPrimaryInfo() {
        return this.primaryInfo;
    }

    public void setPrimaryInfo(ConnectionInfo connectionInfo) {
        this.primaryInfo = connectionInfo;
        if (connectionInfo == null) {
            return;
        }
        if (this.realTimeInfo == null && connectionInfo.getDescriptor().B()) {
            this.realTimeInfo = connectionInfo;
        }
        if (this.historicalInfo == null && connectionInfo.getDescriptor().C()) {
            this.historicalInfo = connectionInfo;
        }
        if (this.newsInfo == null && connectionInfo.getDescriptor().A()) {
            this.newsInfo = connectionInfo;
        }
    }

    public ConnectionInfo getRealTimeInfo() {
        return this.realTimeInfo;
    }

    public void setRealTimeInfo(ConnectionInfo connectionInfo) {
        this.realTimeInfo = connectionInfo;
    }

    public ConnectionInfo getHistoricalInfo() {
        return this.historicalInfo;
    }

    public void setHistoricalInfo(ConnectionInfo connectionInfo) {
        this.historicalInfo = connectionInfo;
    }

    public ConnectionInfo getNewsInfo() {
        return this.newsInfo;
    }

    public void setNewsInfo(ConnectionInfo connectionInfo) {
        this.newsInfo = connectionInfo;
    }

    public boolean isGoogleStocks() {
        return this.googleStocks;
    }

    public void setGoogleStocks(boolean bl2) {
        this.googleStocks = bl2;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int n2) {
        this.counter = n2;
    }

    public int nextCounter() {
        return this.counter++;
    }

    @Override
    public List getNVPs() {
        List list;
        ad ad2;
        Object object;
        List list2 = h.b(new String[]{this.b("name", this.getName()), this.b("id", this.getId()), this.a("googleStocks", this.googleStocks, false), this.a("counter", this.counter)});
        List list3 = h.b(new String[0]);
        if (this.primaryInfo != null) {
            object = "BROKER";
            ad2 = ae.a(this.primaryInfo.getType());
            if (ad2.B() && (this.realTimeInfo == this.primaryInfo || this.realTimeInfo == null)) {
                object = (String)object + "|REALTIME";
            }
            if (ad2.C() && (this.historicalInfo == this.primaryInfo || this.historicalInfo == null)) {
                object = (String)object + "|HISTORICAL";
            }
            if (ad2.A() && (this.newsInfo == this.primaryInfo || this.newsInfo == null)) {
                object = (String)object + "|NEWS";
            }
            list = this.primaryInfo.getNVPs();
            list.add(this.a_("services", (String)object));
            list3.add(this.a(list));
        }
        if (this.realTimeInfo != null && this.realTimeInfo != this.primaryInfo) {
            object = "REALTIME";
            ad2 = ae.a(this.realTimeInfo.getType());
            if (ad2.C() && this.historicalInfo == this.realTimeInfo) {
                object = (String)object + "|HISTORICAL";
            }
            if (ad2.A() && this.newsInfo == this.realTimeInfo) {
                object = (String)object + "|NEWS";
            }
            list = this.realTimeInfo.getNVPs();
            list.add(this.a_("services", (String)object));
            list3.add(this.a(list));
        }
        if (this.historicalInfo != null && !h.a((Object)this.historicalInfo, new Object[]{this.newsInfo, this.primaryInfo})) {
            object = "HISTORICAL";
            ad2 = ae.a(this.historicalInfo.getType());
            if (ad2.A() && this.newsInfo == this.historicalInfo) {
                object = (String)object + "|NEWS";
            }
            list = this.historicalInfo.getNVPs();
            list.add(this.a_("services", (String)object));
            list3.add(this.a(list));
        }
        if (this.newsInfo != null && !h.a((Object)this.newsInfo, new Object[]{this.primaryInfo, this.realTimeInfo, this.historicalInfo}) && this.newsInfo.getDescriptor().A()) {
            object = this.newsInfo.getNVPs();
            object.add(this.a_("services", "NEWS"));
            list3.add(this.a((Collection)object));
        }
        list2.add(this.a("connections", list3));
        return list2;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.name = jSONObject.str("name");
        this.id = jSONObject.str("id");
        this.googleStocks = jSONObject.is("googleStocks", false);
        this.counter = jSONObject.getInt("counter");
        for (JSONObject jSONObject2 : jSONObject.getObjList("connections")) {
            String string;
            ConnectionInfo connectionInfo = new ConnectionInfo(jSONObject2);
            ad ad2 = connectionInfo.getDescriptor();
            if (ad2 == null) {
                h.a.warning("ServiceInfo::fromJSON() descriptor not found: " + connectionInfo.getType());
                continue;
            }
            if (this.primaryInfo == null) {
                this.setPrimaryInfo(connectionInfo);
            }
            if ((string = jSONObject2.str("services")).indexOf("BROKER") >= 0) {
                this.primaryInfo = connectionInfo;
            }
            if (string.indexOf("REALTIME") >= 0 && ad2.B()) {
                this.realTimeInfo = connectionInfo;
            }
            if (string.indexOf("HISTORICAL") >= 0 && ad2.C()) {
                this.historicalInfo = connectionInfo;
            }
            if (string.indexOf("NEWS") < 0 || !ad2.A()) continue;
            this.newsInfo = connectionInfo;
        }
    }

    public boolean read(Element element) {
        List list;
        if (element.getNodeName().equals("broker")) {
            ConnectionInfo connectionInfo = new ConnectionInfo(Enums$ServiceType.read(g.c("provider", element)), g.c("username", element), g.c("server", element), g.b("port", element), g.b("connectionType", element));
            String string = g.c("password", element);
            if (!h.g(string)) {
                connectionInfo.setPassword(string);
            }
            this.primaryInfo = connectionInfo;
            this.realTimeInfo = connectionInfo;
            if (connectionInfo.getDescriptor().C()) {
                this.historicalInfo = connectionInfo;
            }
            if (connectionInfo.getDescriptor().A()) {
                this.newsInfo = connectionInfo;
            }
            return true;
        }
        String string = element.getAttribute("googleStocks");
        if (!h.g(string)) {
            this.googleStocks = h.a((Object)string);
        }
        if (!h.g(string = element.getAttribute("counter"))) {
            this.counter = h.b(string);
        }
        if (!h.g(string = element.getAttribute("name"))) {
            this.name = string;
        }
        if (!h.g(string = element.getAttribute("id"))) {
            this.id = string;
        }
        if (h.a((Collection)(list = g.c("service", element)))) {
            h.a.warning("ServiceInfo::read() no services defined!");
            return false;
        }
        for (Element element2 : list) {
            ConnectionInfo connectionInfo = this.readInfo(element2);
            ad ad2 = ae.a(connectionInfo.getType());
            if (ad2 == null) {
                h.a.warning("ServiceInfo::read() descriptor not found: " + connectionInfo.getType());
                continue;
            }
            if (this.primaryInfo == null) {
                this.setPrimaryInfo(connectionInfo);
            }
            if (this.connections.b(connectionInfo)) {
                for (ConnectionInfo connectionInfo2 : this.connections.a()) {
                    if (!connectionInfo2.equals(connectionInfo)) continue;
                    connectionInfo = connectionInfo2;
                }
            } else {
                this.connections.a(connectionInfo);
            }
            String string2 = element2.getAttribute("services");
            if (string2.indexOf("BROKER") >= 0) {
                this.primaryInfo = connectionInfo;
            }
            if (string2.indexOf("REALTIME") >= 0 && ad2.B()) {
                this.realTimeInfo = connectionInfo;
            }
            if (string2.indexOf("HISTORICAL") >= 0 && ad2.C()) {
                this.historicalInfo = connectionInfo;
            }
            if (string2.indexOf("NEWS") < 0 || !ad2.A()) continue;
            this.newsInfo = connectionInfo;
        }
        return true;
    }

    private ConnectionInfo readInfo(Element element) {
        String string;
        ConnectionInfo connectionInfo = new ConnectionInfo(Enums$ServiceType.read(g.b("type", element)), g.b("username", element), g.b("server", element), g.b("port", element), g.b("connectionType", element));
        String string2 = g.b("clientId", element);
        if (!h.g(string2)) {
            connectionInfo.setClientId(h.b(string2));
        }
        if (!h.g(string = g.b("password", element))) {
            connectionInfo.setPassword(string);
        }
        return connectionInfo;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            ServiceInfo serviceInfo = (ServiceInfo)object;
            if (!h.a((Object)this.getName(), (Object)serviceInfo.getName())) {
                return false;
            }
            if (this.googleStocks != serviceInfo.googleStocks) {
                return false;
            }
            if (!h.a((Object)this.primaryInfo, (Object)serviceInfo.primaryInfo)) {
                return false;
            }
            if (!h.a((Object)this.realTimeInfo, (Object)serviceInfo.realTimeInfo)) {
                return false;
            }
            if (!h.a((Object)this.historicalInfo, (Object)serviceInfo.historicalInfo)) {
                return false;
            }
            return h.a((Object)this.newsInfo, (Object)serviceInfo.newsInfo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ServiceInfo clone() {
        try {
            ServiceInfo serviceInfo = (ServiceInfo)super.clone();
            serviceInfo.primaryInfo = this.primaryInfo == null ? null : this.primaryInfo.clone();
            serviceInfo.realTimeInfo = this.realTimeInfo == null ? null : this.realTimeInfo.clone();
            serviceInfo.historicalInfo = this.historicalInfo == null ? null : this.historicalInfo.clone();
            serviceInfo.newsInfo = this.newsInfo == null ? null : this.newsInfo.clone();
            serviceInfo.id = this.id;
            return serviceInfo;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

